/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.DenseVector;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelVector;
import cc.mallet.types.RankedFeatureVector;
import cc.mallet.types.SparseVector;

public class PartiallyRankedFeatureVector
extends RankedFeatureVector {
    private static final int SORTINIT = -1;
    int numRanked = -1;

    public PartiallyRankedFeatureVector(Alphabet dict, int[] indices, double[] values) {
        super(dict, indices, values);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, double[] values) {
        super(dict, values);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, DenseVector v) {
        this(dict, v.values);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, AugmentableFeatureVector v) {
        super(dict, v);
    }

    public PartiallyRankedFeatureVector(Alphabet dict, SparseVector v) {
        super(dict, v);
    }

    public int numRanked() {
        if (this.numRanked == -1) {
            this.numRanked = 0;
            int i = 0;
            while (i < this.values.length) {
                if (!Double.isNaN(this.values[i])) {
                    ++this.numRanked;
                }
                ++i;
            }
        }
        return this.numRanked;
    }

    @Override
    protected void setRankOrder(int extent, boolean reset) {
        int sortExtent;
        int n = sortExtent = extent >= this.values.length ? this.values.length - 1 : extent;
        if (sortExtent >= this.numRanked()) {
            return;
        }
        if (this.sortedTo == -1 || reset) {
            this.rankOrder = new int[this.values.length];
            int i = 0;
            while (i < this.rankOrder.length) {
                this.rankOrder[i] = i;
                ++i;
            }
        }
        int i = this.sortedTo + 1;
        while (i <= sortExtent) {
            double front = this.values[this.rankOrder[i]];
            double max = Double.isNaN(front) ? Double.NEGATIVE_INFINITY : front;
            int maxIndex = i;
            int j = this.sortedTo + 1;
            while (j < this.rankOrder.length) {
                double next = this.values[this.rankOrder[j]];
                if (!Double.isNaN(next) && next > max) {
                    max = next;
                    maxIndex = j;
                }
                ++j;
            }
            int r = this.rankOrder[maxIndex];
            this.rankOrder[maxIndex] = this.rankOrder[i];
            this.rankOrder[i] = r;
            this.sortedTo = i++;
        }
    }

    public static interface Factory {
        public PartiallyRankedFeatureVector newPartiallyRankedFeatureVector(InstanceList var1, LabelVector[] var2);
    }

    public static interface PerLabelFactory {
        public PartiallyRankedFeatureVector[] newPartiallyRankedFeatureVectors(InstanceList var1, LabelVector[] var2);
    }
}

