/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.RankedFeatureVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.regex.Pattern;

public class FeatureSelection
implements AlphabetCarrying,
Serializable {
    Alphabet dictionary;
    BitSet selectedFeatures;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    static final int NULL_INTEGER = -1;

    public FeatureSelection(Alphabet dictionary, BitSet selectedFeatures) {
        this.dictionary = dictionary;
        this.selectedFeatures = selectedFeatures;
    }

    public FeatureSelection(Alphabet dictionary) {
        this.dictionary = dictionary;
        this.selectedFeatures = new BitSet();
    }

    public FeatureSelection(RankedFeatureVector rsv, int numFeatures) {
        this.dictionary = rsv.getAlphabet();
        this.selectedFeatures = new BitSet(this.dictionary.size());
        int numSelections = Math.min(numFeatures, this.dictionary.size());
        int i = 0;
        while (i < numSelections) {
            this.selectedFeatures.set(rsv.getIndexAtRank(i));
            ++i;
        }
    }

    public static FeatureSelection createFromRegex(Alphabet dictionary, Pattern regex) {
        BitSet included = new BitSet(dictionary.size());
        int i = 0;
        while (i < dictionary.size()) {
            String feature = (String)dictionary.lookupObject(i);
            if (regex.matcher(feature).matches()) {
                included.set(i);
            }
            ++i;
        }
        return new FeatureSelection(dictionary, included);
    }

    public Object clone() {
        return new FeatureSelection(this.dictionary, (BitSet)this.selectedFeatures.clone());
    }

    @Override
    public Alphabet getAlphabet() {
        return this.dictionary;
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.dictionary};
    }

    public int cardinality() {
        return this.selectedFeatures.cardinality();
    }

    public BitSet getBitSet() {
        return this.selectedFeatures;
    }

    public void add(Object o) {
        this.add(this.dictionary.lookupIndex(o));
    }

    public void add(int index) {
        assert (index >= 0);
        this.selectedFeatures.set(index);
    }

    public void remove(Object o) {
        this.remove(this.dictionary.lookupIndex(o));
    }

    public void remove(int index) {
        this.selectedFeatures.set(index, false);
    }

    public boolean contains(Object o) {
        int index = this.dictionary.lookupIndex(o, false);
        if (index == -1) {
            return false;
        }
        return this.contains(index);
    }

    public boolean contains(int index) {
        return this.selectedFeatures.get(index);
    }

    public void or(FeatureSelection fs) {
        this.selectedFeatures.or(fs.selectedFeatures);
    }

    public int nextSelectedIndex(int index) {
        return this.selectedFeatures.nextSetBit(index);
    }

    public int nextDeselectedIndex(int index) {
        return this.selectedFeatures.nextClearBit(index);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.dictionary);
        out.writeObject(this.selectedFeatures);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.dictionary = (Alphabet)in.readObject();
        this.selectedFeatures = (BitSet)in.readObject();
    }
}

