/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.InstanceList;
import cc.mallet.types.MultiInstanceList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public class CrossValidationIterator
implements Iterator<InstanceList[]>,
Serializable {
    private static final long serialVersionUID = 234516468015114991L;
    private final int nfolds;
    private final InstanceList[] folds;
    private int index;

    public CrossValidationIterator(InstanceList ilist, int nfolds, Random r) {
        this.nfolds = nfolds;
        assert (nfolds > 0) : "nfolds: " + this.nfolds;
        this.index = 0;
        double fraction = 1.0 / (double)nfolds;
        double[] proportions = new double[nfolds];
        int i = 0;
        while (i < nfolds) {
            proportions[i] = fraction;
            ++i;
        }
        this.folds = ilist.split(r, proportions);
    }

    public CrossValidationIterator(InstanceList ilist, int _nfolds) {
        this(ilist, _nfolds, new Random(System.currentTimeMillis()));
    }

    public void clear() {
        InstanceList[] instanceListArray = this.folds;
        int n = this.folds.length;
        int n2 = 0;
        while (n2 < n) {
            InstanceList list = instanceListArray[n2];
            list.clear();
            ++n2;
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.nfolds;
    }

    public InstanceList[] nextSplit() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        InstanceList[] ret = new InstanceList[2];
        if (this.folds.length == 1) {
            ret[0] = this.folds[0];
            ret[1] = this.folds[0];
        } else {
            InstanceList[] training = new InstanceList[this.folds.length - 1];
            int j = 0;
            int i = 0;
            while (i < this.folds.length) {
                if (i != this.index) {
                    training[j++] = this.folds[i];
                }
                ++i;
            }
            ret[0] = new MultiInstanceList(training);
            ret[1] = this.folds[this.index];
        }
        ++this.index;
        return ret;
    }

    public InstanceList[] nextSplit(int numTrainFolds) {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<InstanceList> trainingSet = new ArrayList<InstanceList>();
        ArrayList<InstanceList> testSet = new ArrayList<InstanceList>();
        int i = 0;
        while (i < this.folds.length) {
            int foldno = (this.index + i) % this.folds.length;
            if (i < numTrainFolds) {
                trainingSet.add(this.folds[foldno]);
            } else {
                testSet.add(this.folds[foldno]);
            }
            ++i;
        }
        InstanceList[] ret = new InstanceList[]{new MultiInstanceList((List<InstanceList>)trainingSet), new MultiInstanceList((List<InstanceList>)testSet)};
        ++this.index;
        return ret;
    }

    @Override
    public InstanceList[] next() {
        return this.nextSplit();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

