/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseVector;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.SparseVector;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AugmentableFeatureVector
extends FeatureVector
implements Serializable {
    int size;
    int maxSortedIndex;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        super(dict, indices, values, capacity, size, copy, checkIndicesSorted, removeDuplicates);
        if (!checkIndicesSorted) {
            if (!removeDuplicates) {
                this.size = size;
            }
            this.maxSortedIndex = this.size - 1;
        }
    }

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, boolean copy, boolean checkIndicesSorted) {
        this(dict, indices, values, capacity, indices.length, copy, checkIndicesSorted, true);
    }

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity, boolean copy) {
        this(dict, indices, values, capacity, indices.length, copy, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, int[] indices, double[] values, int capacity) {
        this(dict, indices, values, capacity, indices.length, true, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, double[] values, int capacity) {
        this(dict, null, values, capacity, values.length, true, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, double[] values) {
        this(dict, null, values, values.length, values.length, true, true, true);
    }

    public AugmentableFeatureVector(Alphabet dict, int capacity, boolean binary) {
        this(dict, new int[capacity], binary ? null : new double[capacity], capacity, 0, false, false, false);
    }

    public AugmentableFeatureVector(Alphabet dict, boolean binary) {
        this(dict, 4, binary);
    }

    public AugmentableFeatureVector(Alphabet dict) {
        this(dict, false);
    }

    public AugmentableFeatureVector(FeatureVector fv) {
        this(fv.dictionary, fv.indices, fv.values, fv.indices == null ? fv.values.length : fv.indices.length, fv.indices == null ? fv.values.length : fv.indices.length, true, false, false);
    }

    public AugmentableFeatureVector(FeatureSequence fs, boolean binary) {
        this(fs.getAlphabet(), binary);
        int i = fs.size() - 1;
        while (i >= 0) {
            this.add(fs.getIndexAtPosition(i), 1.0);
            --i;
        }
    }

    public AugmentableFeatureVector(Alphabet dict, PropertyList pl, boolean binary, boolean growAlphabet) {
        this(dict, binary);
        if (pl == null) {
            return;
        }
        PropertyList.Iterator iter = pl.numericIterator();
        while (iter.hasNext()) {
            iter.nextProperty();
            int index = dict.lookupIndex(iter.getKey(), growAlphabet);
            if (index < 0) continue;
            this.add(index, iter.getNumericValue());
        }
    }

    public AugmentableFeatureVector(Alphabet dict, PropertyList pl, boolean binary) {
        this(dict, pl, binary, true);
    }

    public void add(FeatureVector fv) {
        int loc = 0;
        while (loc < fv.numLocations()) {
            int index = fv.indexAtLocation(loc);
            double value = fv.valueAtLocation(loc);
            if (this.location(index) == -1) {
                this.add(index, value);
            }
            ++loc;
        }
    }

    public void add(FeatureVector fv, String prefix) {
        Alphabet otherDict = fv.getAlphabet();
        int loc = 0;
        while (loc < fv.numLocations()) {
            int idx = fv.indexAtLocation(loc);
            String otherName = (String)otherDict.lookupObject(idx);
            this.add(String.valueOf(prefix) + otherName, 1.0);
            ++loc;
        }
    }

    public void add(FeatureVector fv, String prefix, boolean binary) {
        if (binary) {
            this.add(fv, prefix);
        } else {
            Alphabet otherDict = fv.getAlphabet();
            int loc = 0;
            while (loc < fv.numLocations()) {
                int idx = fv.indexAtLocation(loc);
                double val = fv.valueAtLocation(loc);
                String otherName = (String)otherDict.lookupObject(idx);
                this.add(String.valueOf(prefix) + otherName, val);
                ++loc;
            }
        }
    }

    public void add(int index, double value) {
        if (this.values == null && value != 1.0) {
            throw new IllegalArgumentException("Trying to add non-1.0 value (" + this.dictionary.lookupObject(index) + "=" + value + ") to binary vector");
        }
        assert (index >= 0);
        if (this.indices == null) {
            if (index >= this.values.length) {
                int newLength = index + 10;
                double[] newValues = new double[newLength];
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.values = newValues;
                this.values[index] = value;
                assert (this.size <= index);
            } else {
                int n = index;
                this.values[n] = this.values[n] + value;
            }
            if (this.size <= index) {
                this.size = index + 1;
            }
        } else {
            if (this.size == this.indices.length) {
                int newLength = this.indices.length == 0 ? 4 : (this.indices.length < 4 ? this.indices.length * 2 : (this.indices.length < 100 ? this.indices.length * 3 / 2 : this.indices.length + 150));
                if (this.values != null) {
                    double[] newValues = new double[newLength];
                    System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                    this.values = newValues;
                }
                int[] newIndices = new int[newLength];
                System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
                this.indices = newIndices;
            }
            this.indices[this.size] = index;
            if (this.values != null) {
                this.values[this.size] = value;
            }
            ++this.size;
        }
    }

    public void add(Object key, double value) {
        int index = this.dictionary.lookupIndex(key);
        assert (index != -1);
        this.add(index, value);
    }

    public void add(int index) {
        if (this.values != null) {
            throw new IllegalArgumentException("Trying to add binary feature to real-valued vector");
        }
        assert (index >= 0);
        this.add(index, 1.0);
    }

    @Override
    public final int numLocations() {
        if (this.indices == null) {
            return this.size;
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return this.size;
    }

    @Override
    public final int location(int index) {
        if (this.indices == null) {
            return index;
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        int i = 0;
        while (i < this.size) {
            if (this.indices[i] == index) {
                return i;
            }
            if (this.indices[i] > index) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final double valueAtLocation(int location) {
        if (this.indices == null) {
            return this.values[location];
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return super.valueAtLocation(location);
    }

    @Override
    public final int indexAtLocation(int location) {
        if (this.indices == null) {
            return location;
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        assert (location < this.size);
        return super.indexAtLocation(location);
    }

    @Override
    public final double value(int index) {
        int loc;
        if (this.indices == null) {
            return this.values[index];
        }
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if ((loc = this.location(index)) >= 0) {
            if (this.values == null) {
                return 1.0;
            }
            return this.values[loc];
        }
        return 0.0;
    }

    @Override
    public final void addTo(double[] accumulator, double scale) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if (this.indices == null) {
            int i = 0;
            while (i < this.size) {
                int n = i;
                accumulator[n] = accumulator[n] + this.values[i] * scale;
                ++i;
            }
        } else if (this.values == null) {
            int i = 0;
            while (i < this.size) {
                int n = this.indices[i];
                accumulator[n] = accumulator[n] + scale;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.indices[i];
                accumulator[n] = accumulator[n] + this.values[i] * scale;
                ++i;
            }
        }
    }

    @Override
    public final void addTo(double[] accumulator) {
        this.addTo(accumulator, 1.0);
    }

    @Override
    public final void setValue(int index, double value) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        assert (this.values != null);
        if (this.indices == null) {
            assert (index < this.size);
            this.values[index] = value;
        } else {
            this.values[this.location((int)index)] = value;
        }
    }

    @Override
    public final void setValueAtLocation(int location, double value) {
        assert (location < this.size);
        this.values[location] = value;
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new AugmentableFeatureVector(this.dictionary, this.indices, this.values, this.indices.length, this.size, true, false, false);
    }

    @Override
    public ConstantMatrix cloneMatrixZeroed() {
        if (this.indices == null) {
            return new AugmentableFeatureVector(this.dictionary, new double[this.values.length]);
        }
        int[] newIndices = new int[this.indices.length];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        return new AugmentableFeatureVector(this.dictionary, newIndices, new double[this.values.length], this.values.length, this.values.length, false, false, false);
    }

    @Override
    public int singleSize() {
        return this.indices == null ? this.values.length : (this.size == 0 ? 0 : this.indices[this.size - 1]);
    }

    public SparseVector toSparseVector() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return new SparseVector(this.indices, this.values, this.size, this.size, true, false, false);
    }

    public FeatureVector toFeatureVector() {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        return new FeatureVector(this.dictionary, this.indices, this.values, this.size, this.size, true, false, false);
    }

    @Override
    public double dotProduct(DenseVector v) {
        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        if (this.values == null) {
            int i = 0;
            while (i < this.size) {
                ret += v.value(this.indices[i]);
                ++i;
            }
        } else if (this.indices == null) {
            int i = 0;
            while (i < this.size) {
                ret += this.values[i] * v.value(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                ret += this.values[i] * v.value(this.indices[i]);
                ++i;
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final double dotProduct(SparseVector v) {
        block11: {
            block12: {
                block10: {
                    if (v instanceof AugmentableFeatureVector) {
                        return this.dotProduct((AugmentableFeatureVector)v);
                    }
                    if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
                        this.sortIndices();
                    }
                    ret = 0.0;
                    vl = 0;
                    vnl = v.numLocations();
                    if (this.values != null) break block10;
                    i = 0;
                    ** GOTO lbl17
                    {
                        ++vl;
                        do {
                            if (vl < vnl && v.indexAtLocation(vl) < this.indices[i]) continue block0;
                            if (vl < vnl && v.indexAtLocation(vl) == this.indices[i]) {
                                ret += v.valueAtLocation(vl);
                            }
                            ++i;
lbl17:
                            // 2 sources

                        } while (i < this.size);
                    }
                    break block11;
                }
                if (this.indices != null) break block12;
                i = 0;
                while (i < vnl) {
                    index = v.indexAtLocation(i);
                    if (index < this.size) {
                        ret += v.valueAtLocation(i) * this.values[index];
                    }
                    ++i;
                }
                break block11;
            }
            loc = 0;
            ** GOTO lbl38
            {
                ++vl;
                do {
                    if (vl < vnl && v.indexAtLocation(vl) < this.indices[loc]) continue block3;
                    if (vl < vnl && v.indexAtLocation(vl) == this.indices[loc]) {
                        ret += this.values[loc] * v.value(this.indices[loc]);
                    }
                    ++loc;
lbl38:
                    // 2 sources

                } while (loc < this.size);
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public final double dotProduct(AugmentableFeatureVector v) {
        block18: {
            block20: {
                block19: {
                    block16: {
                        block17: {
                            if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
                                this.sortIndices();
                            }
                            if (v.indices != null && v.size - 1 != v.maxSortedIndex) {
                                v.sortIndices();
                            }
                            ret = 0.0;
                            vl = 0;
                            vnl = v.size;
                            if (this.values != null) break block16;
                            if (v.values != null) break block17;
                            i = 0;
                            ** GOTO lbl18
                            {
                                ++vl;
                                do {
                                    if (vl < vnl && v.indices[vl] < this.indices[i]) continue block0;
                                    if (vl < vnl && v.indices[vl] == this.indices[i]) {
                                        ret += 1.0;
                                    }
                                    ++i;
lbl18:
                                    // 2 sources

                                } while (i < this.size);
                            }
                            break block18;
                        }
                        i = 0;
                        ** GOTO lbl29
                        {
                            ++vl;
                            do {
                                if (vl < vnl && v.indices[vl] < this.indices[i]) continue block2;
                                if (vl < vnl && v.indices[vl] == this.indices[i]) {
                                    ret += v.values[vl];
                                }
                                ++i;
lbl29:
                                // 2 sources

                            } while (i < this.size);
                        }
                        break block18;
                    }
                    if (this.indices != null) break block19;
                    i = 0;
                    while (i < vnl) {
                        index = v.indexAtLocation(i);
                        if (index < this.size) {
                            ret += v.valueAtLocation(i) * this.values[index];
                        }
                        ++i;
                    }
                    break block18;
                }
                if (v.values != null) break block20;
                i = 0;
                ** GOTO lbl51
                {
                    ++vl;
                    do {
                        if (vl < vnl && v.indices[vl] < this.indices[i]) continue block5;
                        if (vl < vnl && v.indices[vl] == this.indices[i]) {
                            ret += this.values[i];
                        }
                        ++i;
lbl51:
                        // 2 sources

                    } while (i < this.size);
                }
                break block18;
            }
            i = 0;
            ** GOTO lbl62
            {
                ++vl;
                do {
                    if (vl < vnl && v.indices[vl] < this.indices[i]) continue block7;
                    if (vl < vnl && v.indices[vl] == this.indices[i]) {
                        ret += this.values[i] * v.values[vl];
                    }
                    ++i;
lbl62:
                    // 2 sources

                } while (i < this.size);
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public void plusEquals(AugmentableFeatureVector v, double factor) {
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
                            this.sortIndices();
                        }
                        if (v.indices != null && v.size - 1 != v.maxSortedIndex) {
                            v.sortIndices();
                        }
                        vl = 0;
                        vnl = v.size;
                        if (!AugmentableFeatureVector.$assertionsDisabled && this.values == null) {
                            throw new AssertionError();
                        }
                        if (this.indices != null) break block17;
                        if (v.indices == null) {
                            vnl = Math.min(vnl, this.size);
                            i = 0;
                            while (i < vnl) {
                                v0 = i;
                                this.values[v0] = this.values[v0] + v.values[i];
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < vnl) {
                                index = v.indices[i];
                                if (index < this.values.length) {
                                    v1 = index;
                                    this.values[v1] = this.values[v1] + v.values[i] * factor;
                                    if (index >= this.size) {
                                        this.size = index + 1;
                                    }
                                }
                                ++i;
                            }
                        }
                        break block18;
                    }
                    if (v.indices != null) break block19;
                    i = 0;
                    while (i < this.size) {
                        if (this.indices[i] < vnl) {
                            v2 = i;
                            this.values[v2] = this.values[v2] + v.values[this.indices[i]];
                        }
                        ++i;
                    }
                    break block18;
                }
                if (v.values != null) break block20;
                i = 0;
                ** GOTO lbl51
                {
                    ++vl;
                    do {
                        if (vl < vnl && v.indices[vl] < this.indices[i]) continue block3;
                        if (vl < vnl && v.indices[vl] == this.indices[i]) {
                            v3 = i;
                            this.values[v3] = this.values[v3] + factor;
                        }
                        ++i;
lbl51:
                        // 2 sources

                    } while (i < this.size);
                }
                break block18;
            }
            i = 0;
            ** GOTO lbl63
            {
                ++vl;
                do {
                    if (vl < vnl && v.indices[vl] < this.indices[i]) continue block5;
                    if (vl < vnl && v.indices[vl] == this.indices[i]) {
                        v4 = i;
                        this.values[v4] = this.values[v4] + v.values[vl] * factor;
                    }
                    ++i;
lbl63:
                    // 2 sources

                } while (i < this.size);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void plusEquals(SparseVector v, double factor) {
        block21: {
            block23: {
                block22: {
                    block20: {
                        if (v instanceof AugmentableFeatureVector) {
                            this.plusEquals((AugmentableFeatureVector)v, factor);
                            return;
                        }
                        if (this.indices != null && this.size - 1 != this.maxSortedIndex) {
                            this.sortIndices();
                        }
                        vl = 0;
                        if (!AugmentableFeatureVector.$assertionsDisabled && this.values == null) {
                            throw new AssertionError();
                        }
                        if (this.indices != null) break block20;
                        if (v.indices == null) {
                            s = Math.min(this.size, v.values.length);
                            i = 0;
                            while (i < s) {
                                v0 = i;
                                this.values[v0] = this.values[v0] + v.values[i] * factor;
                                ++i;
                            }
                        } else if (v.values == null) {
                            i = 0;
                            while (i < v.indices.length) {
                                index = v.indices[i];
                                if (index < this.size) {
                                    v1 = index;
                                    this.values[v1] = this.values[v1] + factor;
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < v.indices.length) {
                                index = v.indices[i];
                                if (index < this.size) {
                                    v2 = index;
                                    this.values[v2] = this.values[v2] + v.values[i] * factor;
                                }
                                ++i;
                            }
                        }
                        break block21;
                    }
                    if (v.indices != null) break block22;
                    i = 0;
                    while (i < this.size) {
                        if (this.indices[i] < v.values.length) {
                            v3 = i;
                            this.values[v3] = this.values[v3] + v.values[this.indices[i]] * factor;
                        }
                        ++i;
                    }
                    break block21;
                }
                vnl = v.indices.length;
                if (v.values != null) break block23;
                i = 0;
                ** GOTO lbl60
                {
                    ++vl;
                    do {
                        if (vl < vnl && v.indices[vl] < this.indices[i]) continue block4;
                        if (vl < vnl && v.indices[vl] == this.indices[i]) {
                            v4 = i;
                            this.values[v4] = this.values[v4] + v.values[vl] * factor;
                        }
                        ++i;
lbl60:
                        // 2 sources

                    } while (i < this.size);
                }
                break block21;
            }
            i = 0;
            ** GOTO lbl72
            {
                ++vl;
                do {
                    if (vl < vnl && v.indices[vl] < this.indices[i]) continue block6;
                    if (vl < vnl && v.indices[vl] == this.indices[i]) {
                        v5 = i;
                        this.values[v5] = this.values[v5] + v.values[vl] * factor;
                    }
                    ++i;
lbl72:
                    // 2 sources

                } while (i < this.size);
            }
        }
    }

    public void plusEquals(SparseVector v) {
        this.plusEquals(v, 1.0);
    }

    @Override
    public void setAll(double v) {
        assert (this.values != null);
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = v;
            ++i;
        }
    }

    @Override
    public double oneNorm() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        if (this.values == null) {
            return this.size;
        }
        int i = 0;
        while (i < this.size) {
            ret += this.values[i];
            ++i;
        }
        return ret;
    }

    @Override
    public double twoNorm() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        double ret = 0.0;
        if (this.values == null) {
            return Math.sqrt(this.size);
        }
        int i = 0;
        while (i < this.size) {
            ret += this.values[i] * this.values[i];
            ++i;
        }
        return Math.sqrt(ret);
    }

    @Override
    public double infinityNorm() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        if (this.values == null) {
            return 1.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.size) {
            if (Math.abs(this.values[i]) > max) {
                max = Math.abs(this.values[i]);
            }
            ++i;
        }
        return max;
    }

    @Override
    public void print() {
        if (this.size - 1 != this.maxSortedIndex) {
            this.sortIndices();
        }
        super.print();
    }

    @Override
    protected void sortIndices() {
        if (this.indices == null) {
            return;
        }
        if (this.size == 0) {
            this.size = this.indices.length;
            this.maxSortedIndex = -1;
        }
        int i = this.maxSortedIndex + 1;
        while (i < this.size) {
            int j = i;
            while (j > 0) {
                if (this.indices[j] < this.indices[j - 1]) {
                    int f = this.indices[j];
                    this.indices[j] = this.indices[j - 1];
                    this.indices[j - 1] = f;
                    if (this.values != null) {
                        double v = this.values[j];
                        this.values[j] = this.values[j - 1];
                        this.values[j - 1] = v;
                    }
                }
                --j;
            }
            ++i;
        }
        this.removeDuplicates(0);
        this.maxSortedIndex = this.size - 1;
    }

    @Override
    protected void removeDuplicates(int numDuplicates) {
        if (this.indices == null) {
            return;
        }
        if (numDuplicates == 0) {
            int i = 1;
            while (i < this.size) {
                if (this.indices[i - 1] == this.indices[i]) {
                    ++numDuplicates;
                }
                ++i;
            }
        }
        if (numDuplicates == 0) {
            return;
        }
        assert (this.indices.length - numDuplicates > 0) : "size=" + this.size + " indices.length=" + this.indices.length + " numDuplicates=" + numDuplicates;
        int[] newIndices = new int[this.size - numDuplicates];
        double[] newValues = this.values == null ? null : new double[this.size - numDuplicates];
        newIndices[0] = this.indices[0];
        assert (this.indices.length >= this.size);
        int i = 0;
        int j = 0;
        while (i < this.size - 1) {
            if (this.indices[i] == this.indices[i + 1]) {
                if (this.values != null) {
                    int n = j;
                    newValues[n] = newValues[n] + this.values[i];
                }
            } else {
                newIndices[j] = this.indices[i];
                if (this.values != null) {
                    int n = j;
                    newValues[n] = newValues[n] + this.values[i];
                }
                ++j;
            }
            if (i == this.size - 2) {
                if (this.values != null) {
                    int n = j;
                    newValues[n] = newValues[n] + this.values[i + 1];
                }
                newIndices[j] = this.indices[i + 1];
            }
            ++i;
        }
        this.indices = newIndices;
        this.values = newValues;
        this.size -= numDuplicates;
        this.maxSortedIndex = this.size - 1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeInt(this.size);
        out.writeInt(this.maxSortedIndex);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.size = in.readInt();
        this.maxSortedIndex = in.readInt();
    }
}

