/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Sequence;
import java.util.ArrayList;

public class ArraySequence<E>
implements Sequence<E> {
    E[] data;

    public ArraySequence(ArrayList<E> a) {
        this.data = new Object[a.size()];
        int i = 0;
        while (i < a.size()) {
            this.data[i] = a.get(i);
            ++i;
        }
    }

    public ArraySequence(E[] a, boolean copy) {
        if (copy) {
            this.data = new Object[a.length];
            System.arraycopy(a, 0, this.data, 0, a.length);
        } else {
            this.data = a;
        }
    }

    public ArraySequence(E[] a) {
        this(a, true);
    }

    protected ArraySequence(Sequence<E> s, boolean copy) {
        if (s instanceof ArraySequence) {
            if (copy) {
                this.data = new Object[s.size()];
                System.arraycopy(((ArraySequence)s).data, 0, this.data, 0, this.data.length);
            } else {
                this.data = ((ArraySequence)s).data;
            }
        } else {
            this.data = new Object[s.size()];
            int i = 0;
            while (i < s.size()) {
                this.data[i] = s.get(i);
                ++i;
            }
        }
    }

    @Override
    public E get(int index) {
        return this.data[index];
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public String toString() {
        String toret = "";
        int i = 0;
        while (i < this.data.length) {
            toret = String.valueOf(toret) + " " + this.data[i];
            ++i;
        }
        return toret;
    }
}

