/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.regression.tui;

import cc.mallet.regression.LeastSquares;
import cc.mallet.regression.LinearRegression;
import cc.mallet.types.Alphabet;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

public class Regression {
    protected static Logger logger = MalletLogger.getLogger(Regression.class.getName());
    static CommandOption.String inputFile = new CommandOption.String(Regression.class, "input", "FILENAME", true, null, "Filename to read from", null);
    static CommandOption.String outputFile = new CommandOption.String(Regression.class, "output", "FILENAME", true, null, "Filename to write to", null);
    static CommandOption.Double regularizationOption = new CommandOption.Double(Regression.class, "ridge-penalty", "FILENAME", true, 0.0, "Precision (inverse variance) of the Gaussian prior shrinking parameters towards zero", null);
    InstanceList data;
    double regularization;
    double[] coefficients;
    LinearRegression regression;

    public Regression(InstanceList data, double regularization) {
        this.data = data;
        this.regularization = regularization;
        LeastSquares model = new LeastSquares(data, regularization);
        model.printSummary();
        this.coefficients = new double[model.getNumParameters()];
        model.getParameters(this.coefficients);
        this.regression = model.getRegression();
    }

    public void printParameters(String filename) throws IOException {
        Alphabet alphabet = this.data.getDataAlphabet();
        PrintWriter out = new PrintWriter(filename);
        int feature = 0;
        while (feature < alphabet.size()) {
            out.printf("%s\t%.8f\n", alphabet.lookupObject(feature), this.coefficients[feature]);
            ++feature;
        }
        out.close();
    }

    public static void main(String[] args) throws Exception {
        CommandOption.setSummary(Regression.class, "Run a regression, print the learned parameters");
        CommandOption.process(Regression.class, args);
        InstanceList data = InstanceList.load(new File(Regression.inputFile.value));
        double regularization = Regression.regularizationOption.value;
        Regression regression = new Regression(data, regularization);
        if (Regression.outputFile.value != null) {
            regression.printParameters(Regression.outputFile.value);
        }
    }
}

