/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.regression;

import cc.mallet.regression.LinearRegression;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.InvertedIndex;
import java.io.File;
import java.text.NumberFormat;

public class CoordinateDescent {
    LinearRegression regression;
    double[] parameters;
    InstanceList trainingData;
    double[] scaledResiduals;
    double tuningConstant;
    double[] sumSquaredX;
    double[] scaledThresholds;
    InvertedIndex featureIndex;
    int interceptIndex;
    int precisionIndex;
    int dimension;
    NumberFormat formatter;

    public CoordinateDescent(InstanceList data, double l1Weight) {
        int index;
        this.tuningConstant = l1Weight;
        this.trainingData = data;
        this.regression = new LinearRegression(this.trainingData.getDataAlphabet());
        this.parameters = this.regression.getParameters();
        this.interceptIndex = this.parameters.length - 2;
        this.precisionIndex = this.parameters.length - 1;
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(3);
        this.dimension = this.parameters.length - 1;
        this.scaledResiduals = new double[this.dimension];
        this.sumSquaredX = new double[this.dimension];
        this.scaledThresholds = new double[this.dimension];
        this.featureIndex = new InvertedIndex(data);
        for (Instance instance : data) {
            FeatureVector predictors = (FeatureVector)instance.getData();
            double y = (Double)instance.getTarget();
            int n = this.interceptIndex;
            this.scaledResiduals[n] = this.scaledResiduals[n] + y;
            int i = 0;
            while (i < predictors.numLocations()) {
                index = predictors.indexAtLocation(i);
                double value = predictors.valueAtLocation(i);
                int n2 = index;
                this.scaledResiduals[n2] = this.scaledResiduals[n2] + y * value;
                int n3 = index;
                this.sumSquaredX[n3] = this.sumSquaredX[n3] + value * value;
                ++i;
            }
        }
        int n = this.interceptIndex;
        this.scaledResiduals[n] = this.scaledResiduals[n] / (double)data.size();
        int index2 = 0;
        while (index2 < this.dimension - 1) {
            int n4 = index2;
            this.scaledResiduals[n4] = this.scaledResiduals[n4] / this.sumSquaredX[index2];
            this.scaledThresholds[index2] = this.tuningConstant / this.sumSquaredX[index2];
            ++index2;
        }
        boolean converged = false;
        int iteration = 0;
        while (!converged) {
            double value;
            double totalDiff = 0.0;
            double diff = this.parameters[this.interceptIndex] - this.scaledResiduals[this.interceptIndex];
            totalDiff += Math.abs(diff);
            this.parameters[this.interceptIndex] = this.scaledResiduals[this.interceptIndex];
            for (Instance instance : data) {
                FeatureVector predictors = (FeatureVector)instance.getData();
                int i = 0;
                while (i < predictors.numLocations()) {
                    int index3 = predictors.indexAtLocation(i);
                    value = predictors.valueAtLocation(i);
                    int n5 = index3;
                    this.scaledResiduals[n5] = this.scaledResiduals[n5] + value * diff / this.sumSquaredX[index3];
                    ++i;
                }
            }
            index = 0;
            while (index < this.dimension - 1) {
                diff = this.parameters[index];
                if (this.scaledResiduals[index] > this.tuningConstant) {
                    this.parameters[index] = this.scaledResiduals[index] - this.tuningConstant;
                } else if (this.scaledResiduals[index] < -this.tuningConstant) {
                    this.parameters[index] = this.scaledResiduals[index] + this.tuningConstant;
                }
                totalDiff += Math.abs(diff -= this.parameters[index]);
                for (Object o : this.featureIndex.getInstancesWithFeature(index)) {
                    Instance instance = (Instance)o;
                    FeatureVector predictors = (FeatureVector)instance.getData();
                    value = 0.0;
                    int i = 0;
                    while (i < predictors.numLocations()) {
                        if (predictors.indexAtLocation(i) == index) {
                            value = predictors.valueAtLocation(i);
                            break;
                        }
                        ++i;
                    }
                    int n6 = this.interceptIndex;
                    this.scaledResiduals[n6] = this.scaledResiduals[n6] + value * diff / (double)data.size();
                    i = 0;
                    while (i < predictors.numLocations()) {
                        int otherIndex = predictors.indexAtLocation(i);
                        double otherValue = predictors.valueAtLocation(i);
                        if (otherIndex != index) {
                            int n7 = otherIndex;
                            this.scaledResiduals[n7] = this.scaledResiduals[n7] + value * otherValue * diff / this.sumSquaredX[otherIndex];
                        }
                        ++i;
                    }
                }
                ++index;
            }
            if (totalDiff < 1.0E-4) {
                converged = true;
                continue;
            }
            if (++iteration % 100 != 0) continue;
            System.out.println(totalDiff);
        }
    }

    public String toString() {
        double sumSquaredError = 0.0;
        int i = 0;
        while (i < this.trainingData.size()) {
            Instance instance = (Instance)this.trainingData.get(i);
            double prediction = this.regression.predict(instance);
            double y = (Double)instance.getTarget();
            double residual = y - prediction;
            sumSquaredError += residual * residual;
            ++i;
        }
        StringBuilder out = new StringBuilder();
        out.append("(Int)\t" + this.formatter.format(this.parameters[this.interceptIndex]) + "\n");
        int index = 0;
        while (index < this.dimension - 1) {
            out.append(this.trainingData.getDataAlphabet().lookupObject(index) + "\t");
            out.append(String.valueOf(this.formatter.format(this.parameters[index])) + "\n");
            ++index;
        }
        out.append("SSE: " + this.formatter.format(sumSquaredError) + "\n");
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        InstanceList data = InstanceList.load(new File(args[0]));
        CoordinateDescent trainer = new CoordinateDescent(data, Double.parseDouble(args[1]));
        System.out.println(trainer);
    }
}

