/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class OffsetPropertyConjunctions
extends Pipe
implements Serializable {
    int[][] conjunctions;
    boolean includeOriginalSingletons;
    String propertyKey;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    private OffsetPropertyConjunctions(boolean includeOriginalSingletons, String propertyKey, int[][] conjunctions) {
        this.conjunctions = conjunctions;
        this.includeOriginalSingletons = includeOriginalSingletons;
        this.propertyKey = propertyKey;
    }

    public OffsetPropertyConjunctions(boolean includeOriginalSingletons, int[][] conjunctions) {
        this(includeOriginalSingletons, null, conjunctions);
    }

    public OffsetPropertyConjunctions(int[][] conjunctions) {
        this(true, conjunctions);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int tsSize = ts.size();
        PropertyList[] oldfs = new PropertyList[ts.size()];
        PropertyList[] newfs = new PropertyList[ts.size()];
        int i = 0;
        while (i < tsSize) {
            oldfs[i] = ((Token)ts.get(i)).getFeatures();
            ++i;
        }
        if (this.includeOriginalSingletons) {
            i = 0;
            while (i < tsSize) {
                newfs[i] = ((Token)ts.get(i)).getFeatures();
                ++i;
            }
        }
        i = 0;
        while (i < ts.size()) {
            int j = 0;
            while (j < this.conjunctions.length) {
                block21: {
                    int offset0;
                    int k = 0;
                    while (k < this.conjunctions[j].length) {
                        if (this.conjunctions[j][k] + i >= 0 && this.conjunctions[j][k] + i <= tsSize - 1 && oldfs[i + this.conjunctions[j][k]] != null) {
                            ++k;
                            continue;
                        }
                        break block21;
                    }
                    if (this.conjunctions[j].length == 1) {
                        int offset = this.conjunctions[j][0];
                        if (offset == 0 && this.includeOriginalSingletons) {
                            throw new IllegalArgumentException("Original singletons already there.");
                        }
                        PropertyList.Iterator iter = oldfs[i + offset].iterator();
                        while (iter.hasNext()) {
                            iter.next();
                            if (this.propertyKey != null && !this.propertyKey.equals(iter.getKey())) continue;
                            String key = String.valueOf(iter.getKey()) + (offset == 0 ? "" : "@" + offset);
                            newfs[i] = PropertyList.add(key, iter.getNumericValue(), newfs[i]);
                        }
                    } else if (this.conjunctions[j].length == 2) {
                        offset0 = this.conjunctions[j][0];
                        int offset1 = this.conjunctions[j][1];
                        PropertyList.Iterator iter0 = oldfs[i + offset0].iterator();
                        int iter0i = -1;
                        while (iter0.hasNext()) {
                            ++iter0i;
                            iter0.next();
                            if (this.propertyKey != null && !this.propertyKey.equals(iter0.getKey())) continue;
                            PropertyList.Iterator iter1 = oldfs[i + offset1].iterator();
                            int iter1i = -1;
                            while (iter1.hasNext()) {
                                iter1.next();
                                if (this.propertyKey != null && !this.propertyKey.equals(iter1.getKey()) || offset0 == offset1 && ++iter1i <= iter0i) continue;
                                String key = String.valueOf(iter0.getKey()) + (offset0 == 0 ? "" : "@" + offset0) + "&" + iter1.getKey() + (offset1 == 0 ? "" : "@" + offset1);
                                newfs[i] = PropertyList.add(key, iter0.getNumericValue() * iter1.getNumericValue(), newfs[i]);
                            }
                        }
                    } else if (this.conjunctions[j].length == 3) {
                        offset0 = this.conjunctions[j][0];
                        int offset1 = this.conjunctions[j][1];
                        int offset2 = this.conjunctions[j][2];
                        PropertyList.Iterator iter0 = oldfs[i + offset0].iterator();
                        int iter0i = -1;
                        while (iter0.hasNext()) {
                            ++iter0i;
                            iter0.next();
                            if (this.propertyKey != null && !this.propertyKey.equals(iter0.getKey())) continue;
                            PropertyList.Iterator iter1 = oldfs[i + offset1].iterator();
                            int iter1i = -1;
                            while (iter1.hasNext()) {
                                iter1.next();
                                if (this.propertyKey != null && !this.propertyKey.equals(iter1.getKey()) || offset0 == offset1 && ++iter1i <= iter0i) continue;
                                PropertyList.Iterator iter2 = oldfs[i + offset2].iterator();
                                int iter2i = -1;
                                while (iter2.hasNext()) {
                                    iter2.next();
                                    if (this.propertyKey != null && !this.propertyKey.equals(iter2.getKey()) || offset1 == offset2 && ++iter2i <= iter1i) continue;
                                    String key = String.valueOf(iter0.getKey()) + (offset0 == 0 ? "" : "@" + offset0) + "&" + iter1.getKey() + (offset1 == 0 ? "" : "@" + offset1) + "&" + iter2.getKey() + (offset2 == 0 ? "" : "@" + offset2);
                                    newfs[i] = PropertyList.add(key, iter0.getNumericValue() * iter1.getNumericValue() * iter2.getNumericValue(), newfs[i]);
                                }
                            }
                        }
                    } else {
                        throw new UnsupportedOperationException("Conjunctions of length 4 or more not yet implemented.");
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ts.size()) {
            ((Token)ts.get(i)).setFeatures(newfs[i]);
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        int size1 = this.conjunctions == null ? -1 : this.conjunctions.length;
        out.writeInt(size1);
        if (size1 != -1) {
            int i = 0;
            while (i < size1) {
                int size2 = this.conjunctions[i] == null ? -1 : this.conjunctions.length;
                out.writeInt(size2);
                if (size2 != -1) {
                    int j = 0;
                    while (j < size2) {
                        out.writeInt(this.conjunctions[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        out.writeBoolean(this.includeOriginalSingletons);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int size1 = in.readInt();
        if (size1 == -1) {
            this.conjunctions = null;
        } else {
            this.conjunctions = new int[size1][];
            int i = 0;
            while (i < size1) {
                int size2 = in.readInt();
                if (size2 == -1) {
                    this.conjunctions[i] = null;
                } else {
                    this.conjunctions[i] = new int[size2];
                    int j = 0;
                    while (j < size2) {
                        this.conjunctions[i][j] = in.readInt();
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.includeOriginalSingletons = in.readBoolean();
    }
}

