/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;

public class LexiconMembership
extends Pipe
implements Serializable {
    String name;
    THashSet lexicon;
    boolean ignoreCase;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public LexiconMembership(String name, Reader lexiconReader, boolean ignoreCase) {
        this.name = name;
        this.lexicon = new THashSet();
        this.ignoreCase = ignoreCase;
        LineNumberReader reader = new LineNumberReader(lexiconReader);
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
            if (line == null) break;
            this.lexicon.add(ignoreCase ? line.toLowerCase() : line);
        }
        if (this.lexicon.size() == 0) {
            throw new IllegalArgumentException("Empty lexicon");
        }
    }

    public LexiconMembership(String name, File lexiconFile, boolean ignoreCase) throws FileNotFoundException {
        this(name, new BufferedReader(new FileReader(lexiconFile)), ignoreCase);
    }

    public LexiconMembership(File lexiconFile, boolean ignoreCase) throws FileNotFoundException {
        this(lexiconFile.getName(), lexiconFile, ignoreCase);
    }

    public LexiconMembership(File lexiconFile) throws FileNotFoundException {
        this(lexiconFile.getName(), lexiconFile, true);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            String conS = s;
            if (conS.startsWith("(")) {
                conS = conS.substring(1);
            }
            if (conS.endsWith(")") || conS.endsWith(".")) {
                conS = conS.substring(0, conS.length() - 1);
            }
            if (this.lexicon.contains(this.ignoreCase ? s.toLowerCase() : s)) {
                t.setFeatureValue(this.name, 1.0);
            }
            if (conS.compareTo(s) != 0 && this.lexicon.contains(this.ignoreCase ? conS.toLowerCase() : conS)) {
                t.setFeatureValue(this.name, 1.0);
            }
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.name);
        out.writeObject(this.lexicon);
        out.writeBoolean(this.ignoreCase);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.name = (String)in.readObject();
        this.lexicon = (THashSet)in.readObject();
        this.ignoreCase = in.readBoolean();
    }
}

