/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Alphabet;
import cc.mallet.types.Dirichlet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Randoms;
import java.net.URI;
import java.util.Iterator;
import java.util.logging.Logger;

public class RandomFeatureVectorIterator
implements Iterator<Instance> {
    private static Logger logger = MalletLogger.getLogger(RandomFeatureVectorIterator.class.getName());
    Randoms r;
    Dirichlet classCentroidDistribution;
    double classCentroidAvergeAlphaMean;
    double classCentroidAvergeAlphaVariance;
    double featureVectorSizePoissonLambda;
    double classInstanceCountPoissonLamba;
    String[] classNames;
    int[] numInstancesPerClass;
    Dirichlet[] classCentroid;
    int currentClassIndex;
    int currentInstanceIndex;

    public RandomFeatureVectorIterator(Randoms r, Dirichlet classCentroidDistribution, double classCentroidAvergeAlphaMean, double classCentroidAvergeAlphaVariance, double featureVectorSizePoissonLambda, double classInstanceCountPoissonLamba, String[] classNames) {
        this.r = r;
        this.classCentroidDistribution = classCentroidDistribution;
        assert (classCentroidDistribution.getAlphabet() instanceof Alphabet);
        this.classCentroidAvergeAlphaMean = classCentroidAvergeAlphaMean;
        this.classCentroidAvergeAlphaVariance = classCentroidAvergeAlphaVariance;
        this.featureVectorSizePoissonLambda = featureVectorSizePoissonLambda;
        this.classInstanceCountPoissonLamba = classInstanceCountPoissonLamba;
        this.classNames = classNames;
        this.numInstancesPerClass = new int[classNames.length];
        this.classCentroid = new Dirichlet[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            logger.fine("classCentroidAvergeAlphaMean = " + classCentroidAvergeAlphaMean);
            double aveAlpha = r.nextGaussian(classCentroidAvergeAlphaMean, classCentroidAvergeAlphaVariance);
            logger.fine("aveAlpha = " + aveAlpha);
            this.classCentroid[i] = classCentroidDistribution.randomDirichlet(r, aveAlpha);
            ++i;
        }
        this.reset();
    }

    public RandomFeatureVectorIterator(Randoms r, Alphabet vocab, String[] classnames) {
        this(r, new Dirichlet(vocab, 2.0), 30.0, 0.0, 10.0, 20.0, classnames);
    }

    public Alphabet getAlphabet() {
        return this.classCentroidDistribution.getAlphabet();
    }

    private static Alphabet dictOfSize(int size) {
        Alphabet ret = new Alphabet();
        int i = 0;
        while (i < size) {
            ret.lookupIndex("feature" + i);
            ++i;
        }
        return ret;
    }

    private static String[] classNamesOfSize(int size) {
        String[] ret = new String[size];
        int i = 0;
        while (i < size) {
            ret[i] = "class" + i;
            ++i;
        }
        return ret;
    }

    public RandomFeatureVectorIterator(Randoms r, int vocabSize, int numClasses) {
        this(r, new Dirichlet(RandomFeatureVectorIterator.dictOfSize(vocabSize), 2.0), 30.0, 0.0, 10.0, 20.0, RandomFeatureVectorIterator.classNamesOfSize(numClasses));
    }

    public void reset() {
        int i = 0;
        while (i < this.classNames.length) {
            this.numInstancesPerClass[i] = this.r.nextPoisson(this.classInstanceCountPoissonLamba);
            logger.fine("Class " + this.classNames[i] + " will have " + this.numInstancesPerClass[i] + " instances.");
            ++i;
        }
        this.currentClassIndex = this.classNames.length - 1;
        this.currentInstanceIndex = this.numInstancesPerClass[this.currentClassIndex] - 1;
    }

    public LabelAlphabet getLabelAlphabet() {
        return null;
    }

    @Override
    public Instance next() {
        if (this.currentInstanceIndex < 0) {
            if (this.currentClassIndex <= 0) {
                throw new IllegalStateException("No next FeatureVector.");
            }
            --this.currentClassIndex;
            this.currentInstanceIndex = this.numInstancesPerClass[this.currentClassIndex] - 1;
        }
        URI uri = null;
        try {
            uri = new URI("random:" + this.classNames[this.currentClassIndex] + "/" + this.currentInstanceIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        int randomSize = (int)this.featureVectorSizePoissonLambda;
        FeatureVector fv = this.classCentroid[this.currentClassIndex].randomFeatureVector(this.r, randomSize);
        --this.currentInstanceIndex;
        return new Instance(fv, this.classNames[this.currentClassIndex], uri, null);
    }

    @Override
    public boolean hasNext() {
        return this.currentClassIndex != 0 || this.currentInstanceIndex != 0;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

