/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SimpleTaggerSentence2TokenSequence
extends Pipe {
    protected boolean setTokensAsFeatures;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public SimpleTaggerSentence2TokenSequence() {
        super(null, new LabelAlphabet());
        this.setTokensAsFeatures = true;
    }

    public SimpleTaggerSentence2TokenSequence(boolean inc) {
        super(null, new LabelAlphabet());
        this.setTokensAsFeatures = inc;
    }

    protected String[][] parseSentence(String sentence) {
        String[] lines = sentence.split("\n");
        String[][] tokens = new String[lines.length][];
        int i = 0;
        while (i < lines.length) {
            tokens[i] = lines[i].split("\\s");
            ++i;
        }
        return tokens;
    }

    protected String makeText(String[] in) {
        if (in.length > 0) {
            return in[0];
        }
        return "";
    }

    @Override
    public Instance pipe(Instance carrier) {
        String[][] tokens;
        Object inputData = carrier.getData();
        LabelSequence target = null;
        TokenSequence ts = new TokenSequence();
        if (inputData instanceof String) {
            tokens = this.parseSentence((String)inputData);
        } else if (inputData instanceof String[][]) {
            tokens = (String[][])inputData;
        } else {
            throw new IllegalArgumentException("Not a String or String[][]; got " + inputData);
        }
        FeatureVector[] fvs = new FeatureVector[tokens.length];
        if (this.isTargetProcessing()) {
            LabelAlphabet labels = (LabelAlphabet)this.getTargetAlphabet();
            target = new LabelSequence(labels, tokens.length);
        }
        int l = 0;
        while (l < tokens.length) {
            int f;
            int nFeatures;
            if (this.isTargetProcessing()) {
                if (tokens[l].length < 1) {
                    throw new IllegalStateException("Missing label at line " + l + " instance " + carrier.getName());
                }
                nFeatures = tokens[l].length - 1;
                target.add(tokens[l][nFeatures]);
            } else {
                nFeatures = tokens[l].length;
            }
            Token tok = new Token(this.makeText(tokens[l]));
            if (this.setTokensAsFeatures) {
                f = 0;
                while (f < nFeatures) {
                    tok.setFeatureValue(tokens[l][f], 1.0);
                    ++f;
                }
            } else {
                f = 1;
                while (f < nFeatures) {
                    tok.setFeatureValue(tokens[l][f], 1.0);
                    ++f;
                }
            }
            ts.add(tok);
            ++l;
        }
        carrier.setData(ts);
        if (this.isTargetProcessing()) {
            carrier.setTarget(target);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

