/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.Universe;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Variable
implements Comparable,
Serializable {
    private String label;
    private LabelAlphabet outcomes;
    public static final int CONTINUOUS = -1;
    private static int counter = 0;
    private Universe universe;
    private int index;
    private transient PropertyList properties = null;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public Variable(LabelAlphabet outs) {
        this(Universe.DEFAULT, outs);
    }

    public Variable(Universe universe, LabelAlphabet outs) {
        this.universe = universe;
        this.outcomes = outs;
        if (outs.size() < 1) {
            throw new IllegalArgumentException("Attempt to create variable with " + outs.size() + " outcomes.");
        }
        this.setName();
        this.index = universe.add(this);
    }

    public Variable(int numOutcomes) {
        this(Universe.DEFAULT, numOutcomes);
    }

    public Variable(Universe universe, int numOutcomes) {
        this.universe = universe;
        if (numOutcomes > 0) {
            this.outcomes = Variable.createBlankAlphabet(numOutcomes);
        }
        this.setName();
        this.index = universe.add(this);
    }

    private static LabelAlphabet createBlankAlphabet(int numOutcomes) {
        if (numOutcomes > 0) {
            LabelAlphabet outcomes = new LabelAlphabet();
            int i = 0;
            while (i < numOutcomes) {
                outcomes.lookupIndex(new Integer(i));
                ++i;
            }
            return outcomes;
        }
        return null;
    }

    private void setName() {
        this.setLabel("VAR" + counter++);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getNumOutcomes() {
        if (this.outcomes == null) {
            return -1;
        }
        return this.outcomes.size();
    }

    public Object lookupOutcome(int i) {
        return this.outcomes.lookupObject(i);
    }

    public LabelAlphabet getLabelAlphabet() {
        return this.outcomes;
    }

    public int compareTo(Object o) {
        int index = this.index;
        int index2 = ((Variable)o).index;
        if (index == index2) {
            return 0;
        }
        if (index < index2) {
            return -1;
        }
        return 1;
    }

    public void setNumericProperty(String key, double value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public double getNumericProperty(String key) {
        return this.properties.lookupNumber(key);
    }

    public String toString() {
        return this.label;
    }

    public int getIndex() {
        return this.index;
    }

    public Universe getUniverse() {
        return this.universe;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.readInt();
    }

    public boolean isContinuous() {
        return this.outcomes == null;
    }
}

