/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;

public class BoltzmannPairFactor
extends TableFactor {
    private double sigma;
    private Variable x1;
    private Variable x2;

    public BoltzmannPairFactor(Variable x1, Variable x2, double sigma) {
        super((VarSet)new HashVarSet(new Variable[]{x1, x2}), BoltzmannPairFactor.sigma2vals(sigma));
        this.sigma = sigma;
        this.x1 = x1;
        this.x2 = x2;
        if (x1.getNumOutcomes() != 2) {
            throw new IllegalArgumentException("Discrete variable " + x1 + " in BoltzmannUnary must be binary.");
        }
        if (x2.getNumOutcomes() != 2) {
            throw new IllegalArgumentException("Discrete variable " + x2 + " in BoltzmannUnary must be binary.");
        }
    }

    public static double[] sigma2vals(double sigma) {
        return new double[]{1.0, Math.exp(sigma), Math.exp(sigma), 1.0};
    }

    @Override
    public Factor duplicate() {
        return new BoltzmannPairFactor(this.x1, this.x2, this.sigma);
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.sigma);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltzmannPairFactor that = (BoltzmannPairFactor)o;
        if (this.sigma != that.sigma) {
            return false;
        }
        if (this.x1 != null ? !this.x1.equals(that.x1) : that.x1 != null) {
            return false;
        }
        return !(this.x2 != null ? !this.x2.equals(that.x2) : that.x2 != null);
    }

    public int hashCode() {
        int result = new Double(this.sigma).hashCode();
        result = 29 * result + (this.x1 != null ? this.x1.hashCode() : 0);
        result = 29 * result + (this.x2 != null ? this.x2.hashCode() : 0);
        return result;
    }

    @Override
    public String prettyOutputString() {
        return String.valueOf(this.x1.getLabel()) + " " + this.x2.getLabel() + " ~ BinaryPair " + Double.toString(this.sigma);
    }

    @Override
    public Factor multiply(Factor other) {
        TableFactor result = new TableFactor(this);
        result.multiplyBy(other);
        return result;
    }
}

