/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.MIntInt2ObjectMap;
import gnu.trove.TIntObjectIterator;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class MessageArray {
    private FactorGraph fg;
    private MIntInt2ObjectMap messages;
    private int numV;
    private int numF;
    private boolean inLogSpace;

    public MessageArray(FactorGraph fg) {
        this.fg = fg;
        this.numV = fg.numVariables();
        this.numF = fg.factors().size();
        this.messages = new MIntInt2ObjectMap(this.numV + this.numV);
        this.inLogSpace = fg.getFactor(0) instanceof LogTableFactor;
    }

    public boolean isInLogSpace() {
        return this.inLogSpace;
    }

    public Factor get(Object from, Object to) {
        if (from instanceof Factor && to instanceof Variable) {
            return this.get((Factor)from, (Variable)to);
        }
        if (from instanceof Variable && to instanceof Factor) {
            return this.get((Variable)from, (Factor)to);
        }
        throw new IllegalArgumentException();
    }

    public Factor get(Variable from, Factor to) {
        int fromIdx = this.getIndex(from);
        int toIdx = this.getIndex(to);
        return this.get(toIdx, fromIdx);
    }

    public Factor get(Factor from, Variable to) {
        int fromIdx = this.getIndex(from);
        int toIdx = this.getIndex(to);
        return this.get(toIdx, fromIdx);
    }

    Factor get(int toIdx, int fromIdx) {
        return (Factor)this.messages.get(toIdx, fromIdx);
    }

    public void put(Factor from, Variable to, Factor msg) {
        int fromIdx = this.getIndex(from);
        int toIdx = this.getIndex(to);
        this.messages.put(toIdx, fromIdx, msg);
    }

    public void put(Variable from, Factor to, Factor msg) {
        int fromIdx = this.getIndex(from);
        int toIdx = this.getIndex(to);
        this.messages.put(toIdx, fromIdx, msg);
    }

    public void put(int fromIdx, int toIdx, Factor msg) {
        this.messages.put(toIdx, fromIdx, msg);
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public ToMsgsIterator toMessagesIterator(int toIdx) {
        return new ToMsgsIterator(this.messages, toIdx);
    }

    public MessageArray duplicate() {
        MessageArray dup = new MessageArray(this.fg);
        dup.messages = this.deepCopy(this.messages);
        return dup;
    }

    public MIntInt2ObjectMap deepCopy(MIntInt2ObjectMap msgs) {
        MIntInt2ObjectMap copy = new MIntInt2ObjectMap(this.numV + this.numF);
        int[] keys1 = msgs.keys1();
        int i = 0;
        while (i < keys1.length) {
            int k1 = keys1[i];
            ToMsgsIterator msgIt = new ToMsgsIterator(msgs, k1);
            while (msgIt.hasNext()) {
                Factor msg = msgIt.next();
                int from = msgIt.currentFromIdx();
                copy.put(k1, from, msg.duplicate());
            }
            ++i;
        }
        return copy;
    }

    public int getIndex(Factor from) {
        return -(this.fg.getIndex(from) + 1);
    }

    public int getIndex(Variable to) {
        return this.fg.getIndex(to);
    }

    public Object idx2obj(int idx) {
        if (idx >= 0) {
            return this.fg.get(idx);
        }
        return this.fg.getFactor(-idx - 1);
    }

    public void dump() {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(System.out), true));
    }

    public void dump(PrintWriter out) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Factor msg = (Factor)it.next();
            Object from = it.from();
            Object to = it.to();
            out.println("Message from " + from + " to " + to);
            out.println(msg.dumpToString());
        }
    }

    public final class Iterator
    implements java.util.Iterator {
        int idx1 = 0;
        int idx2 = -1;
        int[] keys1;
        int[] keys2;

        public Iterator() {
            this.keys1 = MessageArray.this.messages.keys1();
            this.keys2 = this.keys1.length > 0 ? MessageArray.this.messages.keys2(this.keys1[this.idx1]) : new int[0];
        }

        private void increment() {
            ++this.idx2;
            if (this.idx2 >= this.keys2.length) {
                this.idx2 = 0;
                ++this.idx1;
                this.keys2 = MessageArray.this.messages.keys2(this.keys1[this.idx1]);
            }
        }

        @Override
        public boolean hasNext() {
            return this.idx1 + 1 < this.keys1.length || this.idx2 + 1 < this.keys2.length;
        }

        public Object next() {
            this.increment();
            return MessageArray.this.messages.get(this.keys1[this.idx1], this.keys2[this.idx2]);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object from() {
            return MessageArray.this.idx2obj(this.keys2[this.idx2]);
        }

        public Object to() {
            return MessageArray.this.idx2obj(this.keys1[this.idx1]);
        }
    }

    public static final class ToMsgsIterator {
        private TIntObjectIterator subIt;
        private int toIdx = -1;

        private ToMsgsIterator(MIntInt2ObjectMap msgs, int toIdx) {
            this.toIdx = toIdx;
            this.subIt = msgs.curry(toIdx);
        }

        public boolean hasNext() {
            return this.subIt.hasNext();
        }

        public Factor next() {
            this.subIt.advance();
            return this.currentMessage();
        }

        int currentFromIdx() {
            return this.subIt.key();
        }

        public Factor currentMessage() {
            return (Factor)this.subIt.value();
        }

        public int currentToIdx() {
            return this.toIdx;
        }
    }
}

