/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised.pr;

import cc.mallet.fst.SumLattice;
import cc.mallet.fst.Transducer;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Sequence;

public class SumLatticeKL
implements SumLattice {
    Transducer t;
    double totalWeight;
    int latticeLength;
    double[][][] xis;
    Sequence input;

    protected SumLatticeKL() {
    }

    public SumLatticeKL(Transducer trans, Sequence input, double[] initProbs, double[] finalProbs, double[][][] xis, double[][][] cachedDots, Transducer.Incrementor incrementor) {
        assert (xis != null) : "Need transition probabilities";
        this.t = trans;
        this.input = input;
        this.latticeLength = input.size() + 1;
        int numStates = this.t.numStates();
        this.xis = xis;
        this.totalWeight = 0.0;
        int i = 0;
        while (i < numStates) {
            if (this.t.getState(i).getInitialWeight() != Double.NEGATIVE_INFINITY && initProbs != null) {
                this.totalWeight += initProbs[i] * this.t.getState(i).getInitialWeight();
                if (incrementor != null) {
                    incrementor.incrementInitialState(this.t.getState(i), initProbs[i]);
                }
            }
            ++i;
        }
        int ip = 0;
        while (ip < this.latticeLength - 1) {
            int i2 = 0;
            while (i2 < numStates) {
                Transducer.State s = this.t.getState(i2);
                Transducer.TransitionIterator iter = s.transitionIterator(input, ip);
                while (iter.hasNext()) {
                    Transducer.State destination = iter.next();
                    double weight = iter.getWeight();
                    double p = xis[ip][i2][destination.getIndex()];
                    this.totalWeight += p * weight;
                    if (cachedDots != null) {
                        cachedDots[ip][i2][destination.getIndex()] = weight;
                    }
                    if (incrementor == null) continue;
                    incrementor.incrementTransition(iter, p);
                }
                ++i2;
            }
            ++ip;
        }
        i = 0;
        while (i < numStates) {
            if (this.t.getState(i).getFinalWeight() != Double.NEGATIVE_INFINITY && finalProbs != null) {
                this.totalWeight += finalProbs[i] * this.t.getState(i).getFinalWeight();
                if (incrementor != null) {
                    incrementor.incrementFinalState(this.t.getState(i), finalProbs[i]);
                }
            }
            ++i;
        }
        assert (this.totalWeight > Double.NEGATIVE_INFINITY) : "Total weight=" + this.totalWeight;
    }

    @Override
    public double[][][] getXis() {
        return this.xis;
    }

    @Override
    public double[][] getGammas() {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public double getTotalWeight() {
        assert (!Double.isNaN(this.totalWeight));
        return this.totalWeight;
    }

    @Override
    public double getGammaWeight(int inputPosition, Transducer.State s) {
        throw new UnsupportedOperationException("Not handled!");
    }

    public double getGammaWeight(int inputPosition, int stateIndex) {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public double getGammaProbability(int inputPosition, Transducer.State s) {
        throw new UnsupportedOperationException("Not handled!");
    }

    public double getGammaProbability(int inputPosition, int stateIndex) {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public double getXiProbability(int ip, Transducer.State s1, Transducer.State s2) {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public double getXiWeight(int ip, Transducer.State s1, Transducer.State s2) {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public int length() {
        return this.latticeLength;
    }

    @Override
    public double getAlpha(int ip, Transducer.State s) {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public double getBeta(int ip, Transducer.State s) {
        throw new UnsupportedOperationException("Not handled!");
    }

    @Override
    public LabelVector getLabelingAtPosition(int outputPosition) {
        return null;
    }

    @Override
    public Transducer getTransducer() {
        return this.t;
    }

    @Override
    public Sequence getInput() {
        return this.input;
    }
}

