/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.semi_supervised;

import cc.mallet.fst.Transducer;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.util.Maths;

public class EntropyLattice {
    protected int latticeLength;
    protected int inputLength;
    protected Transducer transducer;
    protected int numStates;
    protected LatticeNode[][] nodes;
    protected double entropy;

    public EntropyLattice(FeatureVectorSequence fvs, double[][] gammas, double[][][] xis, Transducer transducer, Transducer.Incrementor incrementor, double scalingFactor) {
        this.inputLength = fvs.size();
        this.latticeLength = this.inputLength + 1;
        this.transducer = transducer;
        this.numStates = transducer.numStates();
        this.nodes = new LatticeNode[this.latticeLength][this.numStates];
        this.entropy = this.forwardLattice(gammas, xis);
        double backwardEntropy = this.backwardLattice(gammas, xis);
        assert (Maths.almostEquals(this.entropy, backwardEntropy)) : String.valueOf(this.entropy) + " " + backwardEntropy;
        if (incrementor != null) {
            this.updateCounts(fvs, gammas, xis, scalingFactor, incrementor);
        }
    }

    public double getEntropy() {
        return this.entropy;
    }

    public double forwardLattice(double[][] gammas, double[][][] xis) {
        double gamma;
        int a = 0;
        while (a < this.numStates) {
            this.getLatticeNode((int)0, (int)a).alpha = 0.0;
            ++a;
        }
        int ip = 1;
        while (ip < this.latticeLength) {
            int a2 = 0;
            while (a2 < this.numStates) {
                LatticeNode node = this.getLatticeNode(ip, a2);
                gamma = gammas[ip][a2];
                if (gamma > Double.NEGATIVE_INFINITY) {
                    int b = 0;
                    while (b < this.numStates) {
                        double xi = xis[ip - 1][b][a2];
                        if (xi > Double.NEGATIVE_INFINITY) {
                            double condProb = Math.exp(xi) / Math.exp(gamma);
                            node.alpha += condProb * (xi - gamma + this.getLatticeNode((int)(ip - 1), (int)b).alpha);
                        }
                        ++b;
                    }
                }
                ++a2;
            }
            ++ip;
        }
        double entropy = 0.0;
        int a3 = 0;
        while (a3 < this.numStates) {
            gamma = gammas[this.inputLength][a3];
            double gammaProb = Math.exp(gamma);
            if (gamma > Double.NEGATIVE_INFINITY) {
                entropy += gammaProb * gamma;
                entropy += gammaProb * this.getLatticeNode((int)this.inputLength, (int)a3).alpha;
            }
            ++a3;
        }
        return entropy;
    }

    public double backwardLattice(double[][] gammas, double[][][] xis) {
        double gamma;
        int a = 0;
        while (a < this.numStates) {
            this.getLatticeNode((int)this.inputLength, (int)a).beta = 0.0;
            ++a;
        }
        int ip = this.inputLength;
        while (ip >= 0) {
            int a2 = 0;
            while (a2 < this.numStates) {
                LatticeNode node = this.getLatticeNode(ip, a2);
                gamma = gammas[ip][a2];
                if (gamma > Double.NEGATIVE_INFINITY) {
                    int b = 0;
                    while (b < this.numStates) {
                        double xi = xis[ip][a2][b];
                        if (xi > Double.NEGATIVE_INFINITY) {
                            double condProb = Math.exp(xi) / Math.exp(gamma);
                            node.beta += condProb * (xi - gamma + this.getLatticeNode((int)(ip + 1), (int)b).beta);
                        }
                        ++b;
                    }
                }
                ++a2;
            }
            --ip;
        }
        double entropy = 0.0;
        int a3 = 0;
        while (a3 < this.numStates) {
            gamma = gammas[0][a3];
            double gammaProb = Math.exp(gamma);
            if (gamma > Double.NEGATIVE_INFINITY) {
                entropy += gammaProb * gamma;
                entropy += gammaProb * this.getLatticeNode((int)0, (int)a3).beta;
            }
            ++a3;
        }
        return entropy;
    }

    private void updateCounts(FeatureVectorSequence fvs, double[][] gammas, double[][][] xis, double scalingFactor, Transducer.Incrementor incrementor) {
        int ip = 0;
        while (ip < this.inputLength) {
            int a = 0;
            while (a < this.numStates) {
                if (this.nodes[ip][a] != null) {
                    Transducer.State sourceState = this.transducer.getState(a);
                    Transducer.TransitionIterator iter = sourceState.transitionIterator(fvs, ip, null, ip);
                    while (iter.hasNext()) {
                        int b = iter.next().getIndex();
                        double xi = xis[ip][a][b];
                        if (xi == Double.NEGATIVE_INFINITY) continue;
                        double xiProb = Math.exp(xi);
                        double constrEntropy = xiProb * (xi + this.nodes[ip][a].alpha + this.nodes[ip + 1][b].beta);
                        assert (constrEntropy <= 0.0) : "Negative entropy should be negative! " + constrEntropy;
                        double covContribution = constrEntropy - xiProb * this.entropy;
                        assert (!Double.isNaN(covContribution)) : "xi: " + xi + ", nodes[" + ip + "][" + a + "].alpha: " + this.nodes[ip][a].alpha + ", nodes[" + (ip + 1) + "][" + b + "].beta: " + this.nodes[ip + 1][b].beta;
                        incrementor.incrementTransition(iter, covContribution * scalingFactor);
                    }
                }
                ++a;
            }
            ++ip;
        }
    }

    public LatticeNode getLatticeNode(int ip, int si) {
        if (this.nodes[ip][si] == null) {
            this.nodes[ip][si] = new LatticeNode(ip, this.transducer.getState(si));
        }
        return this.nodes[ip][si];
    }

    public class LatticeNode {
        public int ip;
        public Transducer.State state;
        public double alpha;
        public double beta;

        LatticeNode(int ip, Transducer.State state) {
            this.ip = ip;
            this.state = state;
            this.alpha = 0.0;
            this.beta = 0.0;
        }
    }
}

