/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.TransducerSequenceConfidenceEstimator;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class QBCSequenceConfidenceEstimator
extends TransducerSequenceConfidenceEstimator {
    private static Logger logger = MalletLogger.getLogger(QBCSequenceConfidenceEstimator.class.getName());
    Transducer[] committee;

    public QBCSequenceConfidenceEstimator(Transducer model, Transducer[] committee) {
        super(model);
        this.committee = committee;
    }

    @Override
    public double estimateConfidenceFor(Instance instance, Object[] startTags, Object[] inTags) {
        Sequence[] predictions = new Sequence[this.committee.length];
        int i = 0;
        while (i < this.committee.length) {
            predictions[i] = new MaxLatticeDefault(this.committee[i], (Sequence)instance.getData()).bestOutputSequence();
            ++i;
        }
        double avg = this.avgVoteEntropy(predictions);
        return -1.0 * avg;
    }

    private double avgVoteEntropy(Sequence[] predictions) {
        double sum = 0.0;
        int i = 0;
        while (i < predictions[0].size()) {
            HashMap<String, Integer> label2Count = new HashMap<String, Integer>();
            int j = 0;
            while (j < predictions.length) {
                String label = predictions[j].get(i).toString();
                Integer count = (Integer)label2Count.get(label);
                if (count == null) {
                    count = new Integer(0);
                }
                label2Count.put(label, new Integer(count + 1));
                ++j;
            }
            sum += this.voteEntropy(label2Count);
            ++i;
        }
        return sum / (double)predictions[0].size();
    }

    private double voteEntropy(HashMap label2Count) {
        Iterator iter = label2Count.keySet().iterator();
        double sum = 0.0;
        while (iter.hasNext()) {
            String label = (String)iter.next();
            int count = (Integer)label2Count.get(label);
            double quot = (double)count / (double)this.committee.length;
            sum += quot * Math.log(quot);
        }
        double ret = -1.0 * sum / Math.log(this.committee.length);
        return ret;
    }
}

