/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MultiSegmentationEvaluator;
import cc.mallet.fst.Segment;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.ConstrainedForwardBackwardConfidenceEstimator;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.fst.confidence.TransducerCorrector;
import cc.mallet.types.ArraySequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.logging.Logger;

public class IsolatedSegmentTransducerCorrector
implements TransducerCorrector {
    private static Logger logger = MalletLogger.getLogger(IsolatedSegmentTransducerCorrector.class.getName());
    TransducerConfidenceEstimator confidenceEstimator;
    Transducer model;

    public IsolatedSegmentTransducerCorrector(TransducerConfidenceEstimator confidenceEstimator, Transducer model) {
        this.confidenceEstimator = confidenceEstimator;
        this.model = model;
    }

    public IsolatedSegmentTransducerCorrector(Transducer model) {
        this(new ConstrainedForwardBackwardConfidenceEstimator(model), model);
    }

    @Override
    public ArrayList correctLeastConfidentSegments(InstanceList ilist, Object[] startTags, Object[] continueTags) {
        ArrayList<ArraySequence<String>> correctedPredictionList = new ArrayList<ArraySequence<String>>();
        int i = 0;
        while (i < ilist.size()) {
            logger.fine("correcting instance# " + i + " / " + ilist.size());
            Instance instance = (Instance)ilist.get(i);
            Segment[] orderedSegments = new Segment[1];
            orderedSegments = this.confidenceEstimator.rankSegmentsByConfidence(instance, startTags, continueTags);
            Segment leastConfidentSegment = orderedSegments[0];
            logger.fine("Ordered Segments:\nTrue sequence: " + leastConfidentSegment.getTruth());
            int j = 0;
            while (j < orderedSegments.length) {
                logger.fine(orderedSegments[j].toString());
                ++j;
            }
            MultiSegmentationEvaluator eval = new MultiSegmentationEvaluator(new InstanceList[0], new String[0], startTags, continueTags);
            Sequence truth = leastConfidentSegment.getTruth();
            Sequence predicted = leastConfidentSegment.getPredicted();
            int numIncorrect = eval.numIncorrectSegments(truth, predicted);
            String[] sequence = new String[truth.size()];
            int j2 = 0;
            while (j2 < truth.size()) {
                sequence[j2] = j2 <= leastConfidentSegment.getEnd() && j2 >= leastConfidentSegment.getStart() ? (String)truth.get(j2) : (String)predicted.get(j2);
                ++j2;
            }
            ArraySequence<String> segmentCorrectedOutput = new ArraySequence<String>(sequence);
            logger.fine("Original prediction: ");
            int j3 = 0;
            while (j3 < predicted.size()) {
                logger.fine(String.valueOf((String)predicted.get(j3)) + "\t");
                ++j3;
            }
            logger.fine("\nCorrected prediction: ");
            j3 = 0;
            while (j3 < segmentCorrectedOutput.size()) {
                logger.fine(String.valueOf(segmentCorrectedOutput.get(j3)) + "\t");
                ++j3;
            }
            logger.fine("");
            if (numIncorrect > -1) {
                correctedPredictionList.add(segmentCorrectedOutput);
            } else {
                correctedPredictionList.add(null);
            }
            ++i;
        }
        return correctedPredictionList;
    }
}

