/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.TransducerConfidenceEstimator;
import cc.mallet.types.Sequence;
import java.util.HashMap;

public class GammaProductConfidenceEstimator
extends TransducerConfidenceEstimator {
    HashMap string2stateIndex = new HashMap();

    public GammaProductConfidenceEstimator(Transducer model) {
        super(model);
        int i = 0;
        while (i < model.numStates()) {
            this.string2stateIndex.put(model.getState(i).getName(), new Integer(i));
            ++i;
        }
    }

    @Override
    public double estimateConfidenceFor(Segment segment, SumLatticeDefault cachedLattice) {
        Sequence predSequence = segment.getPredicted();
        Sequence input = segment.getInput();
        SumLatticeDefault lattice = cachedLattice == null ? new SumLatticeDefault(this.model, input) : cachedLattice;
        double confidence = 1.0;
        int i = segment.getStart();
        while (i <= segment.getEnd()) {
            confidence *= lattice.getGammaProbability(i + 1, this.model.getState(this.stateIndexOfString((String)predSequence.get(i))));
            ++i;
        }
        return confidence;
    }

    private int stateIndexOfString(String s) {
        Integer index = (Integer)this.string2stateIndex.get(s);
        if (index == null) {
            throw new IllegalArgumentException("state label " + s + " not a state in transducer");
        }
        return index;
    }
}

