/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.InstanceAccuracyEvaluator;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.text.NumberFormat;
import java.util.logging.Logger;

public class LabelDistributionEvaluator
extends TransducerEvaluator {
    private static final Logger logger = MalletLogger.getLogger(InstanceAccuracyEvaluator.class.getName());

    public LabelDistributionEvaluator(InstanceList[] instanceLists, String[] descriptions) {
        super(instanceLists, descriptions);
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer transducer, InstanceList instances, String description) {
        double[] predCounts = new double[instances.getTargetAlphabet().size()];
        double[] trueCounts = new double[instances.getTargetAlphabet().size()];
        int total = 0;
        int i = 0;
        while (i < instances.size()) {
            Instance instance = (Instance)instances.get(i);
            Sequence trueOutput = (Sequence)instance.getTarget();
            Sequence predOutput = transducer.getTransducer().transduce((Sequence)instance.getData());
            int j = 0;
            while (j < predOutput.size()) {
                ++total;
                int n = instances.getTargetAlphabet().lookupIndex(predOutput.get(j));
                predCounts[n] = predCounts[n] + 1.0;
                int n2 = instances.getTargetAlphabet().lookupIndex(trueOutput.get(j));
                trueCounts[n2] = trueCounts[n2] + 1.0;
                ++j;
            }
            ++i;
        }
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(4);
        int li = 0;
        while (li < predCounts.length) {
            double ppred = predCounts[li] / (double)total;
            double ptrue = trueCounts[li] / (double)total;
            logger.info(String.valueOf(description) + " " + instances.getTargetAlphabet().lookupObject(li) + " predicted: " + formatter.format(ppred) + " - true: " + formatter.format(ptrue));
            ++li;
        }
    }
}

