/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.CRF;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class CRFOptimizableByGradientValues
implements Optimizable.ByGradientValue {
    private static Logger logger = MalletLogger.getLogger(CRFOptimizableByGradientValues.class.getName());
    private int cachedValueWeightsStamp;
    private int cachedGradientWeightsStamp;
    private double cachedValue = Double.NEGATIVE_INFINITY;
    private double[] cachedGradient;
    private Optimizable.ByGradientValue[] optimizables;
    private CRF crf;

    public CRFOptimizableByGradientValues(CRF crf, Optimizable.ByGradientValue[] opts) {
        this.crf = crf;
        this.optimizables = opts;
        this.cachedGradient = new double[crf.parameters.getNumFactors()];
        this.cachedValueWeightsStamp = -1;
        this.cachedGradientWeightsStamp = -1;
    }

    @Override
    public int getNumParameters() {
        return this.crf.parameters.getNumFactors();
    }

    @Override
    public void getParameters(double[] buffer) {
        this.crf.parameters.getParameters(buffer);
    }

    @Override
    public double getParameter(int index) {
        return this.crf.parameters.getParameter(index);
    }

    @Override
    public void setParameters(double[] buff) {
        this.crf.parameters.setParameters(buff);
        this.crf.weightsValueChanged();
    }

    @Override
    public void setParameter(int index, double value) {
        this.crf.parameters.setParameter(index, value);
        this.crf.weightsValueChanged();
    }

    @Override
    public double getValue() {
        if (this.crf.weightsValueChangeStamp != this.cachedValueWeightsStamp) {
            this.cachedValue = 0.0;
            int i = 0;
            while (i < this.optimizables.length) {
                this.cachedValue += this.optimizables[i].getValue();
                ++i;
            }
            this.cachedValueWeightsStamp = this.crf.weightsValueChangeStamp;
            logger.info("getValue() = " + this.cachedValue);
        }
        return this.cachedValue;
    }

    @Override
    public void getValueGradient(double[] buffer) {
        if (this.cachedGradientWeightsStamp != this.crf.weightsValueChangeStamp) {
            this.getValue();
            MatrixOps.setAll(this.cachedGradient, 0.0);
            double[] b2 = new double[buffer.length];
            int i = 0;
            while (i < this.optimizables.length) {
                MatrixOps.setAll(b2, 0.0);
                this.optimizables[i].getValueGradient(b2);
                MatrixOps.plusEquals(this.cachedGradient, b2);
                ++i;
            }
            this.cachedGradientWeightsStamp = this.crf.weightsValueChangeStamp;
        }
        System.arraycopy(this.cachedGradient, 0, buffer, 0, this.cachedGradient.length);
    }
}

