/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.extract.Span;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class HierarchicalTokenizationFilter
implements TokenizationFilter {
    Pattern ignorePattern = null;

    public HierarchicalTokenizationFilter() {
    }

    public HierarchicalTokenizationFilter(Pattern ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    @Override
    public LabeledSpans constructLabeledSpans(LabelAlphabet dict, Object document, Label backgroundTag, Tokenization input, Sequence seq) {
        LabeledSpans labeled = new LabeledSpans(document);
        this.addSpansFromTags(labeled, input, seq, dict, backgroundTag);
        return labeled;
    }

    private void addSpansFromTags(LabeledSpans labeled, Tokenization input, Sequence tags, LabelAlphabet dict, Label backgroundTag) {
        int i = 0;
        LinkedList<TagStart> openTags = new LinkedList<TagStart>();
        String[] lastTagSplit = new String[]{};
        while (i < tags.size()) {
            Label thisTag = dict.lookupLabel(tags.get(i).toString());
            String[] thisTagSplit = this.splitTag(thisTag);
            int numToClose = this.compareSplitTags(thisTagSplit, lastTagSplit);
            while (numToClose > 0) {
                TagStart tagStart = (TagStart)openTags.removeLast();
                this.addLabeledSpan(labeled, input, tagStart, i, backgroundTag);
                --numToClose;
            }
            int tidx = openTags.size();
            while (tidx < thisTagSplit.length) {
                openTags.add(new TagStart(i, dict.lookupLabel(thisTagSplit[tidx])));
                ++tidx;
            }
            lastTagSplit = thisTagSplit;
            ++i;
        }
        while (!openTags.isEmpty()) {
            TagStart tagStart = (TagStart)openTags.removeLast();
            this.addLabeledSpan(labeled, input, tagStart, i, backgroundTag);
        }
    }

    private void addLabeledSpan(LabeledSpans labeled, Tokenization input, TagStart tagStart, int end, Label backgroundTag) {
        Label splitTag;
        Span span = input.subspan(tagStart.start, end);
        labeled.add(new LabeledSpan(span, splitTag, (splitTag = tagStart.label) == backgroundTag));
    }

    private int compareSplitTags(String[] thisTagSplit, String[] lastTagSplit) {
        int idx = lastTagSplit.length - 1;
        while (idx >= 0) {
            String thisTag;
            if (idx < thisTagSplit.length && !this.isBeginName(thisTag = thisTagSplit[idx]) && this.matches(lastTagSplit[idx], thisTag)) break;
            --idx;
        }
        int numToClose = lastTagSplit.length - idx - 1;
        while (idx >= 0) {
            if (!this.matches(thisTagSplit[idx], lastTagSplit[idx])) {
                throw new IllegalArgumentException("Tags don't match.");
            }
            --idx;
        }
        return numToClose;
    }

    private boolean matches(String str1, String str2) {
        return this.trim(str1).equals(this.trim(str2));
    }

    private String trim(String name) {
        if (this.isBeginName(name) || this.isInsideName(name)) {
            return name.substring(2);
        }
        return name;
    }

    private String[] splitTag(Label tag) {
        String name = tag.toString();
        ArrayList<String> split1 = new ArrayList<String>(Arrays.asList(name.split("\\|")));
        Iterator it = split1.iterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            if (this.ignorePattern == null || !this.ignorePattern.matcher(str).matches()) continue;
            it.remove();
        }
        return split1.toArray(new String[0]);
    }

    private boolean isBeginName(String name) {
        return name.startsWith("B-");
    }

    private boolean isInsideName(String name) {
        return name.startsWith("I-");
    }

    private static class TagStart {
        int start;
        Label label;

        public TagStart(int start, Label label) {
            this.start = start;
            this.label = label;
        }
    }
}

