/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.tui;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.Clusterings;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.logging.Logger;

public class Clusterings2Info {
    private static Logger logger = MalletLogger.getLogger(Clusterings2Info.class.getName());
    static CommandOption.String inputFile = new CommandOption.String(Clusterings2Info.class, "input", "FILENAME", true, "text.vectors", "The filename from which to read the list of instances.", null);
    static CommandOption.Boolean printOption = new CommandOption.Boolean(Clusterings2Info.class, "print", "BOOLEAN", false, false, "If true, print all clusters", null);

    public static void main(String[] args) {
        CommandOption.setSummary(Clusterings2Info.class, "A tool to print statistics about a Clusterings.");
        CommandOption.process(Clusterings2Info.class, args);
        Clusterings clusterings = null;
        try {
            ObjectInputStream iis = new ObjectInputStream(new FileInputStream(Clusterings2Info.inputFile.value));
            clusterings = (Clusterings)iis.readObject();
        }
        catch (Exception e) {
            System.err.println("Exception reading clusterings from " + Clusterings2Info.inputFile.value + " " + e);
            e.printStackTrace();
        }
        if (Clusterings2Info.printOption.value) {
            int i = 0;
            while (i < clusterings.size()) {
                Clustering c = clusterings.get(i);
                int j = 0;
                while (j < c.getNumClusters()) {
                    InstanceList cluster = c.getCluster(j);
                    int k = 0;
                    while (k < cluster.size()) {
                        System.out.println("clustering " + i + " cluster " + j + " element " + k + " " + ((Instance)cluster.get(k)).getData());
                        ++k;
                    }
                    System.out.println();
                    ++j;
                }
                ++i;
            }
        }
        logger.info("number clusterings=" + clusterings.size());
        int totalInstances = 0;
        int totalClusters = 0;
        int i = 0;
        while (i < clusterings.size()) {
            Clustering c = clusterings.get(i);
            totalClusters += c.getNumClusters();
            totalInstances += c.getNumInstances();
            ++i;
        }
        logger.info("total instances=" + totalInstances);
        logger.info("total clusters=" + totalClusters);
        logger.info("instances per clustering=" + (double)totalInstances / (double)clusterings.size());
        logger.info("instances per cluster=" + (double)totalInstances / (double)totalClusters);
        logger.info("clusters per clustering=" + (double)totalClusters / (double)clusterings.size());
    }
}

