/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.iterator.tests;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.iterator.AllPairsIterator;
import cc.mallet.cluster.iterator.ClusterSampleIterator;
import cc.mallet.cluster.iterator.NeighborIterator;
import cc.mallet.cluster.iterator.PairSampleIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestIterators
extends TestCase {
    public TestIterators(String name) {
        super(name);
    }

    private Clustering generateClustering(InstanceList instances) {
        int[] nArray = new int[10];
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        int[] labels = nArray;
        return new Clustering(instances, 3, labels);
    }

    public void testEvaluators() {
        Instance instance;
        Randoms random = new Randoms(1);
        InstanceList instances = new InstanceList(random, 100, 2).subList(0, 10);
        System.err.println(String.valueOf(instances.size()) + " instances");
        Clustering clustering = this.generateClustering(instances);
        System.err.println("clustering=" + clustering);
        System.err.println("ClusterSampleIterator");
        NeighborIterator iter = new ClusterSampleIterator(clustering, random, 0.5, 10);
        while (iter.hasNext()) {
            instance = (Instance)iter.next();
            System.err.println(instance.getData() + "\n");
        }
        System.err.println("\n\nPairSampleIterator");
        iter = new PairSampleIterator(clustering, random, 0.5, 10);
        while (iter.hasNext()) {
            instance = (Instance)iter.next();
            System.err.println(instance.getData() + "\n");
        }
        System.err.println("\n\nAllPairsIterator");
        iter = new AllPairsIterator(clustering);
        while (iter.hasNext()) {
            instance = (Instance)iter.next();
            System.err.println(instance.getData() + "\n");
        }
    }

    public static Test suite() {
        return new TestSuite(TestIterators.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestIterators.suite());
    }
}

