/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.iterator;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.iterator.PairSampleIterator;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.types.Instance;
import cc.mallet.util.Randoms;
import java.util.ArrayList;
import java.util.Iterator;

public class ClusterSampleIterator
extends PairSampleIterator {
    public ClusterSampleIterator(Clustering clustering, Randoms random, double positiveProportion, int numberSamples) {
        super(clustering, random, positiveProportion, numberSamples);
    }

    @Override
    public Instance next() {
        AgglomerativeNeighbor neighbor = null;
        if ((this.positiveCount < this.positiveTarget || this.clustering.getNumClusters() == 1) && this.nonsingletonClusters.length > 0) {
            ++this.positiveCount;
            int label = this.nonsingletonClusters[this.random.nextInt(this.nonsingletonClusters.length)];
            int[] instances = this.clustering.getIndicesWithLabel(label);
            int[][] clusters = this.sampleSplitFromArray(instances, this.random, 2);
            neighbor = new AgglomerativeNeighbor(this.clustering, this.clustering, clusters);
        } else {
            int labeli = this.random.nextInt(this.clustering.getNumClusters());
            int labelj = this.random.nextInt(this.clustering.getNumClusters());
            while (labeli == labelj) {
                labelj = this.random.nextInt(this.clustering.getNumClusters());
            }
            neighbor = new AgglomerativeNeighbor(this.clustering, ClusterUtils.copyAndMergeClusters(this.clustering, labeli, labelj), this.sampleFromArray(this.clustering.getIndicesWithLabel(labeli), this.random, 1), this.sampleFromArray(this.clustering.getIndicesWithLabel(labelj), this.random, 1));
        }
        ++this.totalCount;
        return new Instance(neighbor, null, null, null);
    }

    protected int[] sampleFromArray(int[] a, Randoms random, int minSize) {
        int size = Math.max(random.nextInt(a.length) + 1, minSize);
        ArrayList<Integer> toInclude = new ArrayList<Integer>();
        int i = 0;
        while (i < a.length) {
            toInclude.add(new Integer(i));
            ++i;
        }
        while (toInclude.size() > size && size != a.length) {
            toInclude.remove(random.nextInt(toInclude.size()));
        }
        int[] ret = new int[toInclude.size()];
        int i2 = 0;
        Iterator iter = toInclude.iterator();
        while (iter.hasNext()) {
            ret[i2++] = a[(Integer)iter.next()];
        }
        return ret;
    }

    protected int[][] sampleSplitFromArray(int[] a, Randoms random, int minSize) {
        int size = Math.max(random.nextInt(a.length) + 1, minSize);
        ArrayList<Integer> toInclude = new ArrayList<Integer>();
        int i = 0;
        while (i < a.length) {
            toInclude.add(new Integer(i));
            ++i;
        }
        while (toInclude.size() > size && size != a.length) {
            toInclude.remove(random.nextInt(toInclude.size()));
        }
        int[][] ret = new int[2][];
        int size1 = Math.max(random.nextInt(toInclude.size() - 1), 1);
        ret[0] = new int[size1];
        ret[1] = new int[toInclude.size() - size1];
        int i2 = 0;
        while (i2 < size1) {
            ret[0][i2] = (Integer)toInclude.get(i2);
            ++i2;
        }
        int nadded = 0;
        int i3 = size1;
        while (i3 < toInclude.size()) {
            ret[1][nadded++] = (Integer)toInclude.get(i3);
            ++i3;
        }
        return ret;
    }
}

