/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.examples;

import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntTrainer;
import cc.mallet.classify.Trial;
import cc.mallet.classify.evaluate.ConfusionMatrix;
import cc.mallet.cluster.Clusterer;
import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.GreedyAgglomerativeByDensity;
import cc.mallet.cluster.evaluate.AccuracyEvaluator;
import cc.mallet.cluster.evaluate.BCubedEvaluator;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;
import cc.mallet.cluster.evaluate.ClusteringEvaluators;
import cc.mallet.cluster.evaluate.MUCEvaluator;
import cc.mallet.cluster.evaluate.PairF1Evaluator;
import cc.mallet.cluster.iterator.ClusterSampleIterator;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.neighbor_evaluator.ClassifyingNeighborEvaluator;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.util.PropertyList;
import cc.mallet.util.Randoms;
import java.util.Random;

public class FirstOrderClusterExample {
    Randoms random = new Randoms(123456789);
    double noise = 0.01;

    public void run() {
        Alphabet alphabet = this.dictOfSize(20);
        Clustering training = this.sampleClustering(alphabet);
        OverlappingFeaturePipe clusterPipe = new OverlappingFeaturePipe();
        System.err.println("Training with " + training);
        InstanceList trainList = new InstanceList(clusterPipe);
        trainList.addThruPipe(new ClusterSampleIterator(training, this.random, 0.5, 100));
        System.err.println("Created " + trainList.size() + " instances.");
        MaxEnt me = new MaxEntTrainer().train(trainList);
        ClassifyingNeighborEvaluator eval = new ClassifyingNeighborEvaluator(me, "YES");
        Trial trial = new Trial(me, trainList);
        System.err.println(new ConfusionMatrix(trial));
        InfoGain ig = new InfoGain(trainList);
        ig.print();
        GreedyAgglomerativeByDensity clusterer = new GreedyAgglomerativeByDensity(training.getInstances().getPipe(), eval, 0.5, false, new Random(1L));
        Clustering testing = this.sampleClustering(alphabet);
        InstanceList testList = testing.getInstances();
        Clustering predictedClusters = ((Clusterer)clusterer).cluster(testList);
        System.err.println("\n\nEvaluating System: " + clusterer);
        ClusteringEvaluators evaluators = new ClusteringEvaluators(new ClusteringEvaluator[]{new BCubedEvaluator(), new PairF1Evaluator(), new MUCEvaluator(), new AccuracyEvaluator()});
        System.err.println("truth:" + testing);
        System.err.println("pred: " + predictedClusters);
        System.err.println(evaluators.evaluate(testing, predictedClusters));
    }

    private Clustering sampleClustering(Alphabet alph) {
        InstanceList instances = new InstanceList(this.random, alph, new String[]{"foo", "bar"}, 30).subList(0, 20);
        Clustering singletons = ClusterUtils.createSingletonClustering(instances);
        int i = 0;
        while (i < instances.size()) {
            FeatureVector fvi = (FeatureVector)((Instance)instances.get(i)).getData();
            int j = i + 1;
            while (j < instances.size()) {
                FeatureVector fvj = (FeatureVector)((Instance)instances.get(j)).getData();
                if (fvi.contains("feature0") && fvj.contains("feature0")) {
                    singletons = ClusterUtils.mergeClusters(singletons, singletons.getLabel(i), singletons.getLabel(j));
                } else if (!fvi.contains("feature0") && !fvj.contains("feature0") && this.random.nextUniform() < this.noise) {
                    singletons = ClusterUtils.mergeClusters(singletons, singletons.getLabel(i), singletons.getLabel(j));
                }
                ++j;
            }
            ++i;
        }
        return singletons;
    }

    private Alphabet dictOfSize(int size) {
        Alphabet ret = new Alphabet();
        int i = 0;
        while (i < size) {
            ret.lookupIndex("feature" + i);
            ++i;
        }
        return ret;
    }

    public static void main(String[] args) {
        FirstOrderClusterExample ex = new FirstOrderClusterExample();
        ex.run();
    }

    private class OverlappingFeaturePipe
    extends Pipe {
        private static final long serialVersionUID = 1L;

        public OverlappingFeaturePipe() {
            super(new Alphabet(), new LabelAlphabet());
        }

        @Override
        public Instance pipe(Instance carrier) {
            boolean mergeFirst = false;
            AgglomerativeNeighbor neighbor = (AgglomerativeNeighbor)carrier.getData();
            Clustering original = neighbor.getOriginal();
            InstanceList list = original.getInstances();
            int[] mergedIndices = neighbor.getNewCluster();
            boolean match = true;
            int i = 0;
            while (i < mergedIndices.length) {
                int j = i + 1;
                while (j < mergedIndices.length) {
                    if (original.getLabel(mergedIndices[i]) != original.getLabel(mergedIndices[j]) || mergeFirst) {
                        FeatureVector fvi = (FeatureVector)((Instance)list.get(mergedIndices[i])).getData();
                        FeatureVector fvj = (FeatureVector)((Instance)list.get(mergedIndices[j])).getData();
                        if (!fvi.contains("feature0") || !fvj.contains("feature0")) {
                            match = false;
                            break;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            PropertyList pl = null;
            pl = match ? PropertyList.add("Match", 1.0, pl) : PropertyList.add("NoMatch", 1.0, pl);
            FeatureVector fv = new FeatureVector(this.getDataAlphabet(), pl, true);
            carrier.setData(fv);
            boolean positive = true;
            int i2 = 0;
            while (i2 < mergedIndices.length) {
                int j = i2 + 1;
                while (j < mergedIndices.length) {
                    if (original.getLabel(mergedIndices[i2]) != original.getLabel(mergedIndices[j])) {
                        positive = false;
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
            LabelAlphabet ldict = (LabelAlphabet)this.getTargetAlphabet();
            String label = positive ? "YES" : "NO";
            carrier.setTarget(ldict.lookupLabel(label));
            return carrier;
        }
    }
}

