/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;

public class PairF1Evaluator
extends ClusteringEvaluator {
    int tpTotal = 0;
    int fnTotal = 0;
    int fpTotal = 0;

    @Override
    public String evaluate(Clustering truth, Clustering predicted) {
        double[] vals = this.getEvaluationScores(truth, predicted);
        return "pr=" + vals[0] + " re=" + vals[1] + " f1=" + vals[2];
    }

    @Override
    public String evaluateTotals() {
        double prTotal = (double)this.tpTotal / (double)(this.tpTotal + this.fpTotal);
        double recTotal = (double)this.tpTotal / (double)(this.tpTotal + this.fnTotal);
        double f1Total = 2.0 * prTotal * recTotal / (prTotal + recTotal);
        return "pr=" + prTotal + " re=" + recTotal + " f1=" + f1Total;
    }

    @Override
    public double[] getEvaluationScores(Clustering truth, Clustering predicted) {
        int k;
        int j;
        int fp = 0;
        int fn = 0;
        int tp = 0;
        int i = 0;
        while (i < predicted.getNumClusters()) {
            int[] predIndices = predicted.getIndicesWithLabel(i);
            j = 0;
            while (j < predIndices.length) {
                k = j + 1;
                while (k < predIndices.length) {
                    if (truth.getLabel(predIndices[j]) == truth.getLabel(predIndices[k])) {
                        ++tp;
                    } else {
                        ++fp;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < truth.getNumClusters()) {
            int[] trueIndices = truth.getIndicesWithLabel(i);
            j = 0;
            while (j < trueIndices.length) {
                k = j + 1;
                while (k < trueIndices.length) {
                    if (predicted.getLabel(trueIndices[j]) != predicted.getLabel(trueIndices[k])) {
                        ++fn;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double pr = (double)tp / (double)(tp + fp);
        double rec = (double)tp / (double)(tp + fn);
        double f1 = 2.0 * pr * rec / (pr + rec);
        this.tpTotal += tp;
        this.fpTotal += fp;
        this.fnTotal += fn;
        return new double[]{pr, rec, f1};
    }
}

