/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.evaluate;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.evaluate.ClusteringEvaluator;

public class AccuracyEvaluator
extends ClusteringEvaluator {
    int correctTotal = 0;
    int comparisonsTotal = 0;

    @Override
    public String evaluate(Clustering truth, Clustering predicted) {
        return "accuracy=" + String.valueOf(this.getEvaluationScores(truth, predicted)[0]);
    }

    @Override
    public String evaluateTotals() {
        return "accuracy=" + (double)this.correctTotal / (double)this.comparisonsTotal;
    }

    @Override
    public double[] getEvaluationScores(Clustering truth, Clustering predicted) {
        int correct = 0;
        int comparisons = 0;
        int i = 0;
        while (i < truth.getNumInstances()) {
            int j = i + 1;
            while (j < truth.getNumInstances()) {
                if (truth.getLabel(i) == truth.getLabel(j) == (predicted.getLabel(i) == predicted.getLabel(j))) {
                    ++correct;
                }
                ++comparisons;
                ++j;
            }
            ++i;
        }
        this.correctTotal += correct;
        this.comparisonsTotal += comparisons;
        return new double[]{(double)correct / (double)comparisons};
    }
}

