/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.pr;

import cc.mallet.classify.constraints.pr.MaxEntFLPRConstraints;
import cc.mallet.types.FeatureVector;
import gnu.trove.TIntIntHashMap;

public class MaxEntL2FLPRConstraints
extends MaxEntFLPRConstraints {
    private TIntIntHashMap constraintIndices = new TIntIntHashMap();
    private boolean normalize;

    public MaxEntL2FLPRConstraints(int numFeatures, int numLabels, boolean useValues, boolean normalize) {
        super(numFeatures, numLabels, useValues);
        this.normalize = normalize;
    }

    @Override
    public void addConstraint(int fi, double[] ex, double weight) {
        this.constraints.put(fi, new MaxEntL2FLPRConstraint(ex, weight));
        this.constraintIndices.put(fi, this.constraintIndices.size());
    }

    @Override
    public int numDimensions() {
        return this.constraints.size() * this.numLabels;
    }

    @Override
    public double getAuxiliaryValueContribution(double[] parameters) {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            int ci = this.constraintIndices.get(fi);
            int li = 0;
            while (li < this.numLabels) {
                double param = parameters[ci + li * this.constraints.size()];
                value += ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).target[li] * param;
                value -= param * param / (2.0 * ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).weight);
                ++li;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public void getGradient(double[] parameters, double[] gradient) {
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            int ci = this.constraintIndices.get(fi);
            double norm = this.normalize ? ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).count : 1.0;
            int li = 0;
            while (li < this.numLabels) {
                double param = parameters[ci + li * this.constraints.size()];
                gradient[ci + li * this.constraints.size()] = ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).target[li] - ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).expectation[li] / norm;
                int n3 = ci + li * this.constraints.size();
                gradient[n3] = gradient[n3] - param / ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).weight;
                ++li;
            }
            ++n2;
        }
    }

    @Override
    public double getCompleteValueContribution() {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            double norm = this.normalize ? ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).count : 1.0;
            int li = 0;
            while (li < this.numLabels) {
                value -= ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).weight * Math.pow(((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).target[li] - ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)fi)).expectation[li] / norm, 2.0) / 2.0;
                ++li;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public double getScore(FeatureVector input, int label, double[] parameters) {
        double score = 0.0;
        int i = 0;
        while (i < this.indexCache.size()) {
            int ci = this.constraintIndices.get(this.indexCache.getQuick(i));
            double param = parameters[ci + label * this.constraints.size()];
            double norm = this.normalize ? ((MaxEntFLPRConstraints.MaxEntFLPRConstraint)this.constraints.get((int)this.indexCache.getQuick((int)i))).count : 1.0;
            score = this.useValues ? (score += param * this.valueCache.getQuick(i) / norm) : (score += param / norm);
            ++i;
        }
        return score;
    }

    protected class MaxEntL2FLPRConstraint
    extends MaxEntFLPRConstraints.MaxEntFLPRConstraint {
        public MaxEntL2FLPRConstraint(double[] target, double weight) {
            super(target, weight);
        }
    }
}

