/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.ge;

import cc.mallet.classify.constraints.ge.MaxEntFLGEConstraints;

public class MaxEntL2FLGEConstraints
extends MaxEntFLGEConstraints {
    private boolean normalize;

    public MaxEntL2FLGEConstraints(int numFeatures, int numLabels, boolean useValues, boolean normalize) {
        super(numFeatures, numLabels, useValues);
        this.normalize = normalize;
    }

    @Override
    public double getValue() {
        double value = 0.0;
        int[] nArray = this.constraints.keys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int fi = nArray[n2];
            MaxEntFLGEConstraints.MaxEntFLGEConstraint constraint = (MaxEntFLGEConstraints.MaxEntFLGEConstraint)this.constraints.get(fi);
            if (constraint.count > 0.0) {
                double featureValue = 0.0;
                int labelIndex = 0;
                while (labelIndex < this.numLabels) {
                    double ex = this.normalize ? constraint.expectation[labelIndex] / constraint.count : constraint.expectation[labelIndex];
                    featureValue -= Math.pow(constraint.target[labelIndex] - ex, 2.0);
                    ++labelIndex;
                }
                assert (!Double.isNaN(featureValue) && !Double.isInfinite(featureValue));
                value += featureValue * constraint.weight;
            }
            ++n2;
        }
        return value;
    }

    @Override
    public void addConstraint(int fi, double[] ex, double weight) {
        this.constraints.put(fi, new MaxEntL2FLGEConstraint(ex, weight));
    }

    protected class MaxEntL2FLGEConstraint
    extends MaxEntFLGEConstraints.MaxEntFLGEConstraint {
        public MaxEntL2FLGEConstraint(double[] target, double weight) {
            super(MaxEntL2FLGEConstraints.this, target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            if (MaxEntL2FLGEConstraints.this.normalize) {
                return 2.0 * this.weight * (this.target[li] / this.count - this.expectation[li] / (this.count * this.count));
            }
            return 2.0 * this.weight * (this.target[li] - this.expectation[li]);
        }
    }
}

