/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Trial;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.AlphabetCarrying;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Labeling;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public abstract class Classifier
implements AlphabetCarrying,
Serializable {
    private static Logger logger = Logger.getLogger(Classifier.class.getName());
    protected Pipe instancePipe;

    protected Classifier() {
    }

    public Classifier(Pipe instancePipe) {
        this.instancePipe = instancePipe;
        assert (instancePipe.getTargetAlphabet() != null);
        assert (instancePipe.getTargetAlphabet().getClass().isAssignableFrom(LabelAlphabet.class));
    }

    public Pipe getInstancePipe() {
        return this.instancePipe;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.instancePipe.getDataAlphabet();
    }

    public LabelAlphabet getLabelAlphabet() {
        return (LabelAlphabet)this.instancePipe.getTargetAlphabet();
    }

    @Override
    public Alphabet[] getAlphabets() {
        return new Alphabet[]{this.getAlphabet(), this.getLabelAlphabet()};
    }

    public boolean alphabetsMatch(AlphabetCarrying object) {
        Alphabet[] otherAlphabets = object.getAlphabets();
        return otherAlphabets.length == 2 && otherAlphabets[0] == this.getAlphabet() && otherAlphabets[1] == this.getLabelAlphabet();
    }

    public ArrayList<Classification> classify(InstanceList instances) {
        ArrayList<Classification> ret = new ArrayList<Classification>(instances.size());
        for (Instance inst : instances) {
            ret.add(this.classify(inst));
        }
        return ret;
    }

    public Classification[] classify(Instance[] instances) {
        Classification[] ret = new Classification[instances.length];
        int i = 0;
        while (i < instances.length) {
            ret[i] = this.classify(instances[i]);
            ++i;
        }
        return ret;
    }

    public abstract Classification classify(Instance var1);

    public Classification classify(Object obj) {
        if (obj instanceof Instance) {
            return this.classify((Instance)obj);
        }
        return this.classify(this.instancePipe.instanceFrom(new Instance(obj, null, null, null)));
    }

    public FeatureSelection getFeatureSelection() {
        return null;
    }

    public FeatureSelection[] getPerClassFeatureSelection() {
        return null;
    }

    public double getAccuracy(InstanceList ilist) {
        return new Trial(this, ilist).getAccuracy();
    }

    public double getPrecision(InstanceList ilist, int index) {
        return new Trial(this, ilist).getPrecision(index);
    }

    public double getPrecision(InstanceList ilist, Labeling labeling) {
        return new Trial(this, ilist).getPrecision(labeling);
    }

    public double getPrecision(InstanceList ilist, Object labelEntry) {
        return new Trial(this, ilist).getPrecision(labelEntry);
    }

    public double getRecall(InstanceList ilist, int index) {
        return new Trial(this, ilist).getRecall(index);
    }

    public double getRecall(InstanceList ilist, Labeling labeling) {
        return new Trial(this, ilist).getRecall(labeling);
    }

    public double getRecall(InstanceList ilist, Object labelEntry) {
        return new Trial(this, ilist).getRecall(labelEntry);
    }

    public double getF1(InstanceList ilist, int index) {
        return new Trial(this, ilist).getF1(index);
    }

    public double getF1(InstanceList ilist, Labeling labeling) {
        return new Trial(this, ilist).getF1(labeling);
    }

    public double getF1(InstanceList ilist, Object labelEntry) {
        return new Trial(this, ilist).getF1(labelEntry);
    }

    public double getAverageRank(InstanceList ilist) {
        return new Trial(this, ilist).getAverageRank();
    }

    public void print() {
        System.out.println("Classifier " + this.getClass().getName() + "\n  Detailed printout not yet implemented.");
    }

    public void print(PrintWriter out) {
        out.println("Classifier " + this.getClass().getName() + "\n  Detailed printout not yet implemented.");
    }
}

