/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classifier;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Labeling;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;

public class Classification
implements Serializable {
    Instance instance;
    Classifier classifier;
    Labeling labeling;

    public Classification(Instance instance, Classifier classifier, Labeling labeling) {
        this.instance = instance;
        this.classifier = classifier;
        this.labeling = labeling;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public Labeling getLabeling() {
        return this.labeling;
    }

    public LabelVector getLabelVector() {
        return this.labeling.toLabelVector();
    }

    public boolean bestLabelIsCorrect() {
        Labeling correctLabeling = this.instance.getLabeling();
        if (correctLabeling == null) {
            throw new IllegalStateException("Instance has no label.");
        }
        return this.labeling.getBestLabel().equals(correctLabeling.getBestLabel());
    }

    public double valueOfCorrectLabel() {
        Labeling correctLabeling = this.instance.getLabeling();
        int correctLabelIndex = correctLabeling.getBestIndex();
        return this.labeling.value(correctLabelIndex);
    }

    public void print() {
    }

    public void print(PrintWriter pw) throws FileNotFoundException {
        pw.print(this.classifier.getClass().getName());
        pw.print(" ");
        pw.print(this.instance.getSource() + " ");
        int i = 0;
        while (i < this.labeling.numLocations()) {
            pw.print(String.valueOf(this.labeling.labelAtLocation(i).toString()) + "=" + this.labeling.valueAtLocation(i) + " ");
            ++i;
        }
        pw.println();
    }

    public void printRank(PrintWriter pw) throws FileNotFoundException {
        pw.print(this.classifier.getClass().getName());
        pw.print(" ");
        pw.print(this.instance.getSource() + " ");
        LabelVector lv = this.labeling.toLabelVector();
        lv.printByRank(pw);
        pw.println();
    }

    public Instance toInstance() {
        double[] values = new double[this.labeling.numLocations()];
        int[] indices = new int[this.labeling.numLocations()];
        int i = 0;
        while (i < this.labeling.numLocations()) {
            indices[i] = this.labeling.indexAtLocation(i);
            values[i] = this.labeling.valueAtLocation(i);
            ++i;
        }
        FeatureVector fv = new FeatureVector(this.labeling.getAlphabet(), indices, values);
        Instance ret = new Instance(fv, null, null, this.instance.getSource());
        return ret;
    }
}

