/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Labeling;
import cc.mallet.types.MatrixOps;

public class BaggingClassifier
extends Classifier {
    Classifier[] baggedClassifiers;
    double[] weights;

    public BaggingClassifier(Pipe instancePipe, Classifier[] baggedClassifiers) {
        super(instancePipe);
        this.baggedClassifiers = baggedClassifiers;
    }

    @Override
    public Classification classify(Instance inst) {
        int numClasses = this.getLabelAlphabet().size();
        double[] scores = new double[numClasses];
        double sum = 0.0;
        int i = 0;
        while (i < this.baggedClassifiers.length) {
            Labeling labeling = this.baggedClassifiers[i].classify(inst).getLabeling();
            labeling.addTo(scores);
            ++i;
        }
        MatrixOps.normalize(scores);
        return new Classification(inst, this, new LabelVector(this.getLabelAlphabet(), scores));
    }
}

