/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jpos.pipes;

import java.util.ArrayList;

public class NGramGenerator {
    public ArrayList<String> generateTokenNGrams(String[] tokens, int currPos, int[] ngramSizes) {
        ArrayList<String> allNGrams = new ArrayList<String>();
        int[] nArray = ngramSizes;
        int n = ngramSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int ngramSize = nArray[n2];
            allNGrams.addAll(this.generateTokenNGrams(tokens, currPos, ngramSize));
            ++n2;
        }
        return allNGrams;
    }

    public ArrayList<String> generateTokenNGrams(String[] tokens, int currPos, int ngramSize) {
        if (currPos > tokens.length - 1) {
            return null;
        }
        int minStart = Math.max(0, currPos - ngramSize + 1);
        int maxStart = Math.min(currPos, tokens.length - 1);
        ArrayList<String> ngrams = new ArrayList<String>();
        int i = minStart;
        while (i <= maxStart) {
            if (i + ngramSize <= tokens.length) {
                StringBuffer ngram = new StringBuffer();
                int j = 0;
                while (j < ngramSize) {
                    ngram.append(String.valueOf(tokens[i + j]) + " ");
                    ++j;
                }
                ngrams.add(ngram.toString().trim());
            }
            ++i;
        }
        return ngrams;
    }

    public static void main(String[] args) {
        String[] tokens = new String[]{"0", "1", "2", "3", "4", "5"};
        System.out.println(new NGramGenerator().generateTokenNGrams(tokens, 2, new int[]{2, 3, 4}));
    }
}

