/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jpos.postagger;

import de.julielab.jcore.ae.jpos.postagger.UIMAUtils;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jpos.tagger.POSTagger;
import de.julielab.jpos.tagger.Unit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSAnnotator
extends JCasAnnotator_ImplBase {
    private static final String COMPONENT_ID = "de.julielab.jcore.ae.jpos.postagger.POSAnnotator";
    private static final Logger LOGGER = LoggerFactory.getLogger(POSAnnotator.class);
    private POSTagger tagger;
    Properties featureConfig = null;
    private String postagset;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        LOGGER.info("initialize() - initializing JPOS...");
        super.initialize(aContext);
        try {
            this.setModel(aContext);
            this.postagset = (String)aContext.getConfigParameterValue("tagset");
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
        catch (AnnotatorConfigurationException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
        catch (AnnotatorInitializationException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
    }

    private void setModel(UimaContext aContext) throws AnnotatorConfigurationException, AnnotatorContextException, AnnotatorInitializationException {
        String modelFilename = "";
        Object o = aContext.getConfigParameterValue("ModelFilename");
        if (o == null) {
            LOGGER.error("setModel() - descriptor incomplete, no model file specified!");
            throw new AnnotatorConfigurationException();
        }
        modelFilename = (String)o;
        try {
            InputStream is;
            LOGGER.debug("setModel() -  loading JPOS model...");
            File modelFile = new File(modelFilename);
            if (!modelFile.exists()) {
                String resourceLocation = modelFilename.startsWith("/") ? modelFilename : "/" + modelFilename;
                is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceLocation);
            } else {
                is = new FileInputStream(modelFile);
            }
            this.tagger = POSTagger.readModel(is);
        }
        catch (Exception e) {
            LOGGER.error("setModel() - Could not load JPOS model from " + new File(modelFilename).getAbsolutePath() + ": " + e.getMessage(), (Throwable)e);
            throw new AnnotatorInitializationException();
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        LOGGER.info("process() - processing next document");
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        for (Sentence sentence : indexes.getAnnotationIndex(Sentence.type)) {
            ArrayList tokenList = (ArrayList)UIMAUtils.getAnnotations(aJCas, (Annotation)sentence, new Token(aJCas, 0, 0).getClass());
            de.julielab.jpos.tagger.Sentence unitSentence = this.createUnitSentence(tokenList, aJCas);
            LOGGER.debug("process() - original sentence: " + sentence.getCoveredText());
            StringBuffer unitS = new StringBuffer();
            for (Unit unit : unitSentence.getUnits()) {
                unitS.append(String.valueOf(unit.getRep()) + " ");
            }
            LOGGER.debug("process() - sentence for prediction: " + unitSentence.toString());
            try {
                this.tagger.predictForUIMA(unitSentence);
            }
            catch (IllegalStateException e) {
                LOGGER.error("process() - predicting with JPOS failed: " + e.getMessage());
                throw new AnalysisEngineProcessException();
            }
            LOGGER.debug("process() - sentence with labels: " + unitSentence.toString());
            this.writeToCAS(unitSentence, aJCas, tokenList);
        }
    }

    protected de.julielab.jpos.tagger.Sentence createUnitSentence(ArrayList<Token> tokenList, JCas JCas2) {
        de.julielab.jpos.tagger.Sentence unitSentence = new de.julielab.jpos.tagger.Sentence();
        int i = 0;
        while (i < tokenList.size()) {
            Token token = tokenList.get(i);
            String tokenRepresentation = token.getCoveredText();
            if (tokenRepresentation != null && tokenRepresentation.equals(token.getCoveredText())) {
                Unit unit = new Unit(token.getBegin(), token.getEnd(), tokenRepresentation);
                unitSentence.add(unit);
            }
            ++i;
        }
        return unitSentence;
    }

    public void writeToCAS(de.julielab.jpos.tagger.Sentence unitSentence, JCas aJCas, ArrayList<Token> tokenList) throws AnalysisEngineProcessException {
        if (tokenList.size() != unitSentence.size()) {
            LOGGER.error("process() - writing results to CAS failed: " + tokenList + "\n is incompatible in length with\n" + tokenList);
            throw new AnalysisEngineProcessException();
        }
        int i = 0;
        while (i < unitSentence.size()) {
            try {
                Class[] parameterTypes = new Class[]{JCas.class};
                Class<?> myNewClass = Class.forName(this.postagset);
                Constructor<?> myConstructor = myNewClass.getConstructor(parameterTypes);
                POSTag pos = (POSTag)myConstructor.newInstance(aJCas);
                pos.setBegin(unitSentence.get((int)i).begin);
                pos.setEnd(unitSentence.get((int)i).end);
                pos.setValue(unitSentence.get(i).getLabel());
                pos.setComponentId(COMPONENT_ID);
                pos.addToIndexes();
                if (tokenList.get(i).getPosTag() == null) {
                    tokenList.get(i).setPosTag(new FSArray(aJCas, 1));
                }
                tokenList.get(i).setPosTag(JCoReTools.addToFSArray((FSArray)tokenList.get(i).getPosTag(), (FeatureStructure)pos));
            }
            catch (Exception e) {
                LOGGER.error("error storing results in CAS:\n" + e);
                e.printStackTrace();
            }
            ++i;
        }
    }
}

