/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.index;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.julielab.java.utilities.index.IndexCreationException;
import de.julielab.java.utilities.index.StringArrayMapProvider;
import de.julielab.java.utilities.index.StringIndex;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class PersistentIndexStringArrayMapProvider
extends StringArrayMapProvider
implements Closeable {
    public static final int MAXIMUM_MEMCACHE_SIZE = 10000;
    private final LoadingCache<String, Optional<String[]>> cache;
    protected StringIndex index;
    private Path indexDirectoryPath = Path.of("large-map-indices", new String[0]);

    public PersistentIndexStringArrayMapProvider(final Logger log) {
        super(log);
        this.map = new Map<String, String[]>(){

            @Override
            public int size() {
                return PersistentIndexStringArrayMapProvider.this.index.size();
            }

            @Override
            public boolean isEmpty() {
                throw new NotImplementedException();
            }

            @Override
            public boolean containsKey(Object key) {
                throw new NotImplementedException();
            }

            @Override
            public boolean containsValue(Object value) {
                throw new NotImplementedException();
            }

            @Override
            public String[] get(Object key) {
                try {
                    return PersistentIndexStringArrayMapProvider.this.cache.get((String)key).orElse(null);
                }
                catch (ExecutionException e) {
                    log.error("Could not retrieve value from the cache for key '{}'.", key);
                    throw new IllegalStateException();
                }
            }

            @Override
            @Nullable
            public String[] put(String key, String[] value) {
                throw new NotImplementedException();
            }

            @Override
            public String[] remove(Object key) {
                throw new NotImplementedException();
            }

            @Override
            public void putAll(@NotNull Map<? extends String, ? extends String[]> m) {
                throw new NotImplementedException();
            }

            @Override
            public void clear() {
                throw new NotImplementedException();
            }

            @Override
            @NotNull
            public Set<String> keySet() {
                throw new NotImplementedException();
            }

            @Override
            @NotNull
            public Collection<String[]> values() {
                throw new NotImplementedException();
            }

            @Override
            @NotNull
            public Set<Map.Entry<String, String[]>> entrySet() {
                throw new NotImplementedException();
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(Duration.ofHours(1L)).build(new CacheLoader<String, Optional<String[]>>(){

            @Override
            public Optional<String[]> load(String s) {
                return Optional.ofNullable(PersistentIndexStringArrayMapProvider.this.index.getArray(s));
            }
        });
    }

    public StringIndex getIndex() {
        return this.index;
    }

    public Path getIndexDirectoryPath() {
        return this.indexDirectoryPath;
    }

    public void setIndexDirectoryPath(Path indexDirectoryPath) {
        this.indexDirectoryPath = indexDirectoryPath;
    }

    protected abstract StringIndex initializeIndex(String var1);

    @Override
    public void load(URI uri) throws IndexCreationException {
        File indexFile = null;
        boolean loadData = true;
        try {
            File resourceFile;
            try {
                resourceFile = new File(uri);
            }
            catch (IllegalArgumentException e) {
                resourceFile = new File(uri.getSchemeSpecificPart());
            }
            String resourceFileName = FilenameUtils.getName(uri.toURL().getPath());
            indexFile = new File(this.indexDirectoryPath.toFile(), resourceFileName);
            if (resourceFile.exists() && indexFile.exists() && resourceFile.lastModified() > indexFile.lastModified()) {
                this.log.info("Resource file {} is newer than the existing cached index at {}. Creating new index.", (Object)resourceFile, (Object)indexFile);
                if (indexFile.isDirectory()) {
                    this.log.info("Deleting index directory {}", (Object)indexFile);
                    FileUtils.deleteDirectory(indexFile);
                } else {
                    this.log.info("Deleting index file {}", (Object)indexFile);
                    indexFile.delete();
                }
            } else {
                boolean indexFileExisted = indexFile.exists();
                if (!indexFileExisted) {
                    this.log.info("Creating persistent cache for resource {} at {}.", (Object)uri, (Object)indexFile);
                } else {
                    this.log.info("Using existing persistent cache {} for resource {}.", (Object)indexFile, (Object)uri);
                    loadData = false;
                }
            }
            this.index = this.initializeIndex(indexFile.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            this.log.error("Could obtain file name from resource URI '{}'", (Object)uri, (Object)e);
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            this.log.error("Could not delete index file {}", (Object)indexFile, (Object)e);
            throw new IndexCreationException(e);
        }
        if (loadData) {
            super.load(uri);
            if (this.index.requiresExplicitCommit()) {
                this.index.commit();
            }
        }
        this.index.close();
        this.index.open();
        this.log.info("There are {} entries in the cache at {}.", (Object)this.index.size(), (Object)indexFile);
    }

    @Override
    protected void put(String term, String[] addonArray) {
        this.index.put(term, addonArray);
    }

    public void initializeEmpty(String indexName) {
        Path indexPath = Path.of(this.indexDirectoryPath.toString(), indexName);
        this.log.info("Initializing empty index at {} without loading data from file.", (Object)indexPath);
        this.index = this.initializeIndex(indexPath.toString());
    }
}

