/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.index;

import de.julielab.java.utilities.index.StringIndex;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
implements StringIndex {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndex.class);
    private final FSDirectory directory;
    private final String indexDirectory;
    private IndexWriter iw;
    private IndexSearcher searcher;
    private boolean retrieveAllKeys = true;
    private int firstRetrievalPage = 10;

    public LuceneIndex(String indexDirectory) {
        this.indexDirectory = indexDirectory;
        try {
            Path lucene = Path.of(indexDirectory, new String[0]);
            File directoryFile = lucene.toFile();
            boolean indexExists = directoryFile.exists() && directoryFile.isDirectory() && directoryFile.list().length != 0;
            this.directory = NIOFSDirectory.open((Path)lucene);
            if (!indexExists) {
                log.debug("Creating index writer for index directory {}.", (Object)indexDirectory);
                IndexWriterConfig iwc = new IndexWriterConfig();
                this.iw = new IndexWriter((Directory)this.directory, iwc);
            } else {
                log.debug("Index directory {} already exists.", (Object)indexDirectory);
            }
        }
        catch (IOException e) {
            log.error("could not initialize Lucene index", e);
            throw new IllegalStateException(e);
        }
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public boolean isRetrieveAllKeys() {
        return this.retrieveAllKeys;
    }

    public void setRetrieveAllKeys(boolean retrieveAllKeys) {
        this.retrieveAllKeys = retrieveAllKeys;
    }

    public int getFirstRetrievalPage() {
        return this.firstRetrievalPage;
    }

    public void setFirstRetrievalPage(int firstRetrievalPage) {
        this.firstRetrievalPage = firstRetrievalPage;
    }

    @Override
    public String get(String key) {
        TermQuery tq = new TermQuery(new Term("key", key));
        BooleanQuery.Builder b = new BooleanQuery.Builder();
        b.add((Query)tq, BooleanClause.Occur.FILTER);
        BooleanQuery q = b.build();
        try {
            if (this.searcher == null) {
                throw new IllegalStateException("Call 'open()' on the index object before trying to access its contents.");
            }
            TopDocs topDocs = this.searcher.search((Query)q, 1);
            if (topDocs.scoreDocs.length > 0) {
                Document doc = this.searcher.getIndexReader().document(topDocs.scoreDocs[0].doc);
                return doc.getField("value").stringValue();
            }
        }
        catch (IOException e) {
            log.error("Could not retrieve results for '{}' in Lucene index.", (Object)key, (Object)e);
            throw new IllegalStateException(e);
        }
        return null;
    }

    @Override
    public String[] getArray(String key) {
        TermQuery tq = new TermQuery(new Term("key", key));
        BooleanQuery.Builder b = new BooleanQuery.Builder();
        b.add((Query)tq, BooleanClause.Occur.FILTER);
        BooleanQuery q = b.build();
        try {
            String[] ret;
            if (this.searcher == null) {
                throw new IllegalStateException("Call 'open()' on the index object before trying to access its contents.");
            }
            TopDocs topDocs = this.searcher.search((Query)q, this.firstRetrievalPage);
            Stream<Object> values = Stream.empty();
            if (topDocs.scoreDocs.length > 0) {
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    Document doc = this.searcher.getIndexReader().document(scoreDoc.doc);
                    values = Stream.concat(values, Arrays.stream(doc.getFields("value")).map(IndexableField::stringValue));
                }
            }
            if (this.retrieveAllKeys && topDocs.totalHits.value > (long)this.firstRetrievalPage) {
                log.debug("There are more hits for key {} than were retrieved in the first page of size {}. The retrieval of all values is enabled and the remaining values are obtained now.", (Object)key, (Object)this.firstRetrievalPage);
                TopDocs remainingValues = this.searcher.searchAfter(topDocs.scoreDocs[topDocs.scoreDocs.length - 1], (Query)q, (int)(topDocs.totalHits.value - (long)this.firstRetrievalPage));
                for (ScoreDoc scoreDoc : remainingValues.scoreDocs) {
                    Document doc = this.searcher.getIndexReader().document(scoreDoc.doc);
                    values = Stream.concat(values, Arrays.stream(doc.getFields("value")).map(IndexableField::stringValue));
                }
            }
            return (ret = (String[])values.toArray(String[]::new)).length > 0 ? ret : null;
        }
        catch (IOException e) {
            log.error("Could not retrieve results for '{}' in Lucene index.", (Object)key, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void put(String key, String value) {
        StringField keyField = new StringField("key", key, Field.Store.NO);
        StoredField valueField = new StoredField("value", value);
        Document doc = new Document();
        doc.add((IndexableField)keyField);
        doc.add((IndexableField)valueField);
        try {
            this.iw.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            log.error("Could not index key-value pair {}:{} with Lucene", key, value, e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void put(String key, String[] value) {
        StringField keyField = new StringField("key", key, Field.Store.NO);
        Document doc = new Document();
        doc.add((IndexableField)keyField);
        for (String v : value) {
            doc.add((IndexableField)new StoredField("value", v));
        }
        try {
            this.iw.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            log.error("Could not index key-value pair {}:{} with Lucene", key, value, e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.iw.commit();
        }
        catch (IOException e) {
            log.error("Could not commit Lucene index", e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean requiresExplicitCommit() {
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.searcher != null) {
                this.searcher.getIndexReader().close();
                this.searcher = null;
            }
            if (this.iw != null) {
                this.iw.close();
                this.iw = null;
            }
        }
        catch (IOException e) {
            log.error("Could not close Lucene index reader.", e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void open() {
        try {
            this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.directory));
        }
        catch (IOException e) {
            log.error("Could not open Lucene index searcher.", e);
            if (e.getMessage() != null && e.getMessage().contains("no segments* file")) {
                throw new IllegalStateException("No index files found in directory " + this.directory.getDirectory() + ". Before the index can be used it needs to be committed via the 'commit()' method.", e);
            }
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int size() {
        if (this.iw != null && this.iw.isOpen()) {
            return this.iw.getDocStats().numDocs;
        }
        if (this.searcher != null) {
            return this.searcher.getIndexReader().numDocs();
        }
        return 0;
    }
}

