/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.index;

import de.julielab.java.utilities.UriUtilities;
import de.julielab.java.utilities.index.IMapProvider;
import de.julielab.java.utilities.index.IndexCreationException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractMapProvider<K, V>
implements IMapProvider<K, V> {
    protected final Logger log;
    protected boolean reverse = false;
    protected Map<K, V> map;
    private int keyIndex = 0;
    private int valueIndex = 1;
    private Set<K> eligibleKeys = Collections.emptySet();

    public AbstractMapProvider(Logger log) {
        this.log = log;
        this.map = new HashMap();
    }

    public Set<K> getEligibleKeys() {
        return this.eligibleKeys;
    }

    public void setEligibleKeys(Set<K> eligibleKeys) {
        this.eligibleKeys = eligibleKeys;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    @Override
    public void setKeyIndex(int keyIndex) {
        this.keyIndex = keyIndex;
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void setValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void load(URI uri) throws IndexCreationException {
        try {
            BufferedInputStream is = UriUtilities.getInputStreamFromUri(uri);
            this.load(is);
        }
        catch (IndexCreationException e) {
            this.log.error("Could not create index from URI {}", (Object)uri, (Object)e);
            throw e;
        }
        catch (Exception e) {
            throw new IndexCreationException("Resource " + uri + " not found");
        }
    }

    @Override
    public void load(InputStream is) throws IndexCreationException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String splitExpression = "\t";
            int numEntries = 0;
            while ((line = br.readLine()) != null) {
                K key;
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                ++numEntries;
                int maxIndex = Math.max(this.keyIndex, this.valueIndex);
                String[] split = line.split(splitExpression, maxIndex + 2);
                if (split.length < maxIndex) {
                    splitExpression = "\\s+";
                    split = line.split(splitExpression);
                }
                if (split.length < maxIndex) {
                    throw new IllegalArgumentException("Format error in map file: Expected format is file with tab-separated columns with at least " + maxIndex + " fields but the input line '" + line + "' has " + split.length + " columns.");
                }
                if (this.reverse) {
                    key = this.getKey(split[this.valueIndex]);
                    if (!this.eligibleKeys.isEmpty() && !this.eligibleKeys.contains(key)) continue;
                    this.put(key, this.getValue(split[this.keyIndex]));
                    continue;
                }
                key = this.getKey(split[this.keyIndex]);
                if (!this.eligibleKeys.isEmpty() && !this.eligibleKeys.contains(key)) continue;
                this.put(key, this.getValue(split[this.valueIndex]));
            }
            this.log.info("Finished reading resource from InputStream and got {} entries.", (Object)numEntries);
        }
        catch (IOException e) {
            throw new IndexCreationException(e);
        }
        finally {
            try {
                if (null != br) {
                    br.close();
                }
            }
            catch (IOException e) {
                throw new IndexCreationException(e);
            }
        }
    }

    protected abstract void put(K var1, V var2);

    protected abstract V getValue(String var1);

    protected abstract K getKey(String var1);

    @Override
    public Map<K, V> getMap() {
        return this.map;
    }
}

