/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.regression;

import cc.mallet.regression.LinearRegression;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MVNormal;
import cc.mallet.util.StatFunctions;
import java.io.File;
import java.text.NumberFormat;

public class LeastSquares {
    LinearRegression regression;
    double[] parameters;
    InstanceList trainingData;
    double[] residuals;
    double meanSquaredError = 0.0;
    double sumSquaredError;
    double sumSquaredModel;
    int degreesOfFreedom;
    NumberFormat formatter;
    int precisionIndex;
    int interceptIndex;
    int dimension;
    double[] xTransposeXInverse;

    public LeastSquares(InstanceList data) {
        this(data, 0.0);
    }

    public LeastSquares(InstanceList data, double regularization) {
        this.trainingData = data;
        this.regression = new LinearRegression(this.trainingData.getDataAlphabet());
        this.parameters = this.regression.getParameters();
        this.interceptIndex = this.parameters.length - 2;
        this.precisionIndex = this.parameters.length - 1;
        this.residuals = new double[this.trainingData.size()];
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(8);
        this.dimension = this.parameters.length - 1;
        double[] xTransposeX = new double[this.dimension * this.dimension];
        double[] xTransposeY = new double[this.dimension];
        double meanY = 0.0;
        for (Instance instance : data) {
            FeatureVector predictors = (FeatureVector)instance.getData();
            double y = (Double)instance.getTarget();
            meanY += y;
            int i = 0;
            while (i < predictors.numLocations()) {
                int index1 = predictors.indexAtLocation(i);
                double value1 = predictors.valueAtLocation(i);
                int j = 0;
                while (j < predictors.numLocations()) {
                    int index2 = predictors.indexAtLocation(j);
                    double value2 = predictors.valueAtLocation(j);
                    int n = this.dimension * index1 + index2;
                    xTransposeX[n] = xTransposeX[n] + value1 * value2;
                    ++j;
                }
                int n = this.dimension * index1 + this.interceptIndex;
                xTransposeX[n] = xTransposeX[n] + value1;
                int n2 = this.dimension * this.interceptIndex + index1;
                xTransposeX[n2] = xTransposeX[n2] + value1;
                int n3 = index1;
                xTransposeY[n3] = xTransposeY[n3] + value1 * y;
                ++i;
            }
            int n = this.dimension * this.interceptIndex + this.interceptIndex;
            xTransposeX[n] = xTransposeX[n] + 1.0;
            int n4 = this.interceptIndex;
            xTransposeY[n4] = xTransposeY[n4] + y;
        }
        if (regularization > 0.0) {
            int d = 0;
            while (d < this.dimension) {
                int n = this.dimension * d + d;
                xTransposeX[n] = xTransposeX[n] + regularization;
                ++d;
            }
        }
        meanY /= (double)data.size();
        this.xTransposeXInverse = MVNormal.invertSPD(xTransposeX, this.dimension);
        double oneOverNSquared = 1.0 / (double)(data.size() * data.size());
        int index1 = 0;
        while (index1 < this.dimension) {
            int index2 = 0;
            while (index2 < this.dimension) {
                int n = index1;
                this.parameters[n] = this.parameters[n] + this.xTransposeXInverse[index1 * this.dimension + index2] * xTransposeY[index2];
                ++index2;
            }
            ++index1;
        }
        this.sumSquaredError = 0.0;
        this.sumSquaredModel = 0.0;
        this.degreesOfFreedom = this.trainingData.size() - this.dimension;
        int i = 0;
        while (i < this.trainingData.size()) {
            Instance instance = (Instance)this.trainingData.get(i);
            double prediction = this.regression.predict(instance);
            double y = (Double)instance.getTarget();
            this.residuals[i] = y - prediction;
            this.sumSquaredError += this.residuals[i] * this.residuals[i];
            this.sumSquaredModel += (meanY - prediction) * (meanY - prediction);
            ++i;
        }
        this.meanSquaredError = this.sumSquaredError / (double)this.degreesOfFreedom;
    }

    public double[] pValues() {
        double[] values = new double[this.dimension];
        int index = 0;
        while (index < this.dimension) {
            double standardError = Math.sqrt(this.meanSquaredError * this.xTransposeXInverse[this.dimension * index + index]);
            values[index] = 2.0 * (1.0 - StatFunctions.pt(Math.abs(this.parameters[index] / standardError), this.degreesOfFreedom));
            ++index;
        }
        return values;
    }

    public void printSummary() {
        System.out.println("\tparam\tStd.Err\tt value\tPr(>|t|)");
        System.out.print("(Int)\t");
        System.out.print(String.valueOf(this.formatter.format(this.parameters[this.interceptIndex])) + "\t");
        double standardError = Math.sqrt(this.meanSquaredError * this.xTransposeXInverse[this.dimension * this.interceptIndex + this.interceptIndex]);
        System.out.print(String.valueOf(this.formatter.format(standardError)) + "\t");
        System.out.print(String.valueOf(this.formatter.format(this.parameters[this.interceptIndex] / standardError)) + "\t");
        double tPercentile = 2.0 * (1.0 - StatFunctions.pt(Math.abs(this.parameters[this.interceptIndex] / standardError), this.degreesOfFreedom));
        System.out.println(String.valueOf(this.formatter.format(tPercentile)) + " " + this.significanceStars(tPercentile));
        int index = 0;
        while (index < this.dimension - 1) {
            System.out.print(this.trainingData.getDataAlphabet().lookupObject(index) + "\t");
            System.out.print(String.valueOf(this.formatter.format(this.parameters[index])) + "\t");
            standardError = Math.sqrt(this.meanSquaredError * this.xTransposeXInverse[this.dimension * index + index]);
            System.out.print(String.valueOf(this.formatter.format(standardError)) + "\t");
            System.out.print(String.valueOf(this.formatter.format(this.parameters[index] / standardError)) + "\t");
            tPercentile = 2.0 * (1.0 - StatFunctions.pt(Math.abs(this.parameters[index] / standardError), this.degreesOfFreedom));
            System.out.println(String.valueOf(this.formatter.format(tPercentile)) + " " + this.significanceStars(tPercentile));
            ++index;
        }
        System.out.println();
        System.out.println("SSE: " + this.formatter.format(this.sumSquaredError) + " DF: " + this.degreesOfFreedom);
        System.out.println("R^2: " + this.formatter.format(this.sumSquaredModel / (this.sumSquaredError + this.sumSquaredModel)));
    }

    public String significanceStars(double p) {
        if (p < 0.001) {
            return "***";
        }
        if (p < 0.01) {
            return "**";
        }
        if (p < 0.05) {
            return "*";
        }
        if (p < 0.1) {
            return ".";
        }
        return " ";
    }

    public int getNumParameters() {
        return this.parameters.length;
    }

    public double getParameter(int i) {
        return this.parameters[i];
    }

    public void getParameters(double[] buffer) {
        int i = 0;
        while (i < this.parameters.length) {
            buffer[i] = this.parameters[i];
            ++i;
        }
    }

    public LinearRegression getRegression() {
        return this.regression;
    }

    public static void main(String[] args) throws Exception {
        InstanceList data = InstanceList.load(new File(args[0]));
        LeastSquares ls = null;
        ls = args.length > 1 ? new LeastSquares(data, Double.parseDouble(args[1])) : new LeastSquares(data);
        ls.printSummary();
    }
}

