/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureInducer;
import cc.mallet.types.FeatureSelection;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.FeatureVectorSequence;
import cc.mallet.types.IndexedSparseVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.RankedFeatureVector;
import cc.mallet.types.Sequence;
import cc.mallet.types.SparseVector;
import cc.mallet.util.ArrayUtils;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Maths;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CRF
extends Transducer
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(CRF.class.getName());
    static final String LABEL_SEPARATOR = ",";
    protected Alphabet inputAlphabet;
    protected Alphabet outputAlphabet;
    protected ArrayList<State> states = new ArrayList();
    protected ArrayList<State> initialStates = new ArrayList();
    protected HashMap<String, State> name2state = new HashMap();
    protected Factors parameters = new Factors();
    protected FeatureSelection globalFeatureSelection;
    protected FeatureSelection[] featureSelections;
    protected ArrayList<FeatureInducer> featureInducers = new ArrayList();
    protected int weightsValueChangeStamp = 0;
    protected int weightsStructureChangeStamp = 0;
    protected int cachedNumParametersStamp = -1;
    protected int numParameters;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public CRF(Pipe inputPipe, Pipe outputPipe) {
        super(inputPipe, outputPipe);
        this.inputAlphabet = inputPipe.getDataAlphabet();
        this.outputAlphabet = inputPipe.getTargetAlphabet();
    }

    public CRF(Alphabet inputAlphabet, Alphabet outputAlphabet) {
        super(new Noop(inputAlphabet, outputAlphabet), null);
        inputAlphabet.stopGrowth();
        logger.info("CRF input dictionary size = " + inputAlphabet.size());
        this.inputAlphabet = inputAlphabet;
        this.outputAlphabet = outputAlphabet;
    }

    public CRF(CRF other) {
        this(other.getInputPipe(), other.getOutputPipe());
        this.copyStatesAndWeightsFrom(other);
        this.assertWeightsLength();
    }

    private void copyStatesAndWeightsFrom(CRF initialCRF) {
        this.parameters = new Factors(initialCRF.parameters, true);
        this.parameters.weightAlphabet = (Alphabet)initialCRF.parameters.weightAlphabet.clone();
        this.states.clear();
        this.parameters.initialWeights = new double[0];
        this.parameters.finalWeights = new double[0];
        int i = 0;
        while (i < initialCRF.states.size()) {
            State s = (State)initialCRF.getState(i);
            String[][] weightNames = new String[s.weightsIndices.length][];
            int j = 0;
            while (j < weightNames.length) {
                int[] thisW = s.weightsIndices[j];
                weightNames[j] = (String[])initialCRF.parameters.weightAlphabet.lookupObjects(thisW, new String[s.weightsIndices[j].length]);
                ++j;
            }
            this.addState(s.name, initialCRF.parameters.initialWeights[i], initialCRF.parameters.finalWeights[i], s.destinationNames, s.labels, weightNames);
            ++i;
        }
        this.featureSelections = (FeatureSelection[])initialCRF.featureSelections.clone();
    }

    public Alphabet getInputAlphabet() {
        return this.inputAlphabet;
    }

    public Alphabet getOutputAlphabet() {
        return this.outputAlphabet;
    }

    public void weightsStructureChanged() {
        ++this.weightsStructureChangeStamp;
        ++this.weightsValueChangeStamp;
    }

    public void weightsValueChanged() {
        ++this.weightsValueChangeStamp;
    }

    protected State newState(String name, int index, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames, String[][] weightNames, CRF crf) {
        return new State(name, index, initialWeight, finalWeight, destinationNames, labelNames, weightNames, crf);
    }

    public void addState(String name, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames, String[][] weightNames) {
        assert (weightNames.length == destinationNames.length);
        assert (labelNames.length == destinationNames.length);
        this.weightsStructureChanged();
        if (this.name2state.get(name) != null) {
            throw new IllegalArgumentException("State with name `" + name + "' already exists.");
        }
        this.parameters.initialWeights = MatrixOps.append(this.parameters.initialWeights, initialWeight);
        this.parameters.finalWeights = MatrixOps.append(this.parameters.finalWeights, finalWeight);
        State s = this.newState(name, this.states.size(), initialWeight, finalWeight, destinationNames, labelNames, weightNames, this);
        s.print();
        this.states.add(s);
        if (initialWeight > Double.NEGATIVE_INFINITY) {
            this.initialStates.add(s);
        }
        this.name2state.put(name, s);
    }

    public void addState(String name, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames, String[] weightNames) {
        String[][] newWeightNames = new String[weightNames.length][1];
        int i = 0;
        while (i < weightNames.length) {
            newWeightNames[i][0] = weightNames[i];
            ++i;
        }
        this.addState(name, initialWeight, finalWeight, destinationNames, labelNames, newWeightNames);
    }

    public void addState(String name, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames) {
        assert (destinationNames.length == labelNames.length);
        String[] weightNames = new String[labelNames.length];
        int i = 0;
        while (i < labelNames.length) {
            weightNames[i] = String.valueOf(name) + "->" + destinationNames[i] + ":" + labelNames[i];
            ++i;
        }
        this.addState(name, initialWeight, finalWeight, destinationNames, labelNames, weightNames);
    }

    public void addState(String name, String[] destinationNames) {
        this.addState(name, 0.0, 0.0, destinationNames, destinationNames);
    }

    public void addFullyConnectedStates(String[] stateNames) {
        int i = 0;
        while (i < stateNames.length) {
            this.addState(stateNames[i], stateNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        this.addFullyConnectedStates(labels);
    }

    public void addStartState() {
        this.addStartState("<START>");
    }

    public void addStartState(String name) {
        int i = 0;
        while (i < this.numStates()) {
            this.parameters.initialWeights[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        String[] dests = new String[this.numStates()];
        int i2 = 0;
        while (i2 < dests.length) {
            dests[i2] = this.getState(i2).getName();
            ++i2;
        }
        this.addState(name, 0.0, 0.0, dests, dests);
    }

    public void setAsStartState(State state) {
        int i = 0;
        while (i < this.numStates()) {
            Transducer.State other = this.getState(i);
            if (other == state) {
                other.setInitialWeight(0.0);
            } else {
                other.setInitialWeight(Double.NEGATIVE_INFINITY);
            }
            ++i;
        }
        this.weightsValueChanged();
    }

    private boolean[][] labelConnectionsIn(InstanceList trainingSet) {
        return this.labelConnectionsIn(trainingSet, null);
    }

    private boolean[][] labelConnectionsIn(InstanceList trainingSet, String start) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = new boolean[numLabels][numLabels];
        int i = 0;
        while (i < trainingSet.size()) {
            Instance instance = (Instance)trainingSet.get(i);
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            int j = 1;
            while (j < output.size()) {
                int sourceIndex = this.outputAlphabet.lookupIndex(output.get(j - 1));
                int destIndex = this.outputAlphabet.lookupIndex(output.get(j));
                assert (sourceIndex >= 0 && destIndex >= 0);
                connections[sourceIndex][destIndex] = true;
                ++j;
            }
            ++i;
        }
        if (start != null) {
            int startIndex = this.outputAlphabet.lookupIndex(start);
            int j = 0;
            while (j < this.outputAlphabet.size()) {
                connections[startIndex][j] = true;
                ++j;
            }
        }
        return connections;
    }

    public void addStatesForLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j2);
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), destinationNames);
            ++i;
        }
    }

    public void addStatesForHalfLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    destinationNames[destinationIndex++] = (String)this.outputAlphabet.lookupObject(j2);
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames, destinationNames);
            ++i;
        }
    }

    public void addStatesForThreeQuarterLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int numDestinations = 0;
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    ++numDestinations;
                }
                ++j;
            }
            String[] destinationNames = new String[numDestinations];
            String[][] weightNames = new String[numDestinations][];
            int destinationIndex = 0;
            int j2 = 0;
            while (j2 < numLabels) {
                if (connections[i][j2]) {
                    String wn;
                    String labelName;
                    destinationNames[destinationIndex] = labelName = (String)this.outputAlphabet.lookupObject(j2);
                    weightNames[destinationIndex] = new String[2];
                    weightNames[destinationIndex][0] = labelName;
                    weightNames[destinationIndex][1] = wn = String.valueOf((String)this.outputAlphabet.lookupObject(i)) + "->" + (String)this.outputAlphabet.lookupObject(j2);
                    int wi = this.getWeightsIndex(wn);
                    this.featureSelections[wi] = new FeatureSelection(trainingSet.getDataAlphabet());
                    ++destinationIndex;
                }
                ++j2;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames, weightNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForThreeQuarterLabels(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        int i = 0;
        while (i < numLabels) {
            String[] destinationNames = new String[numLabels];
            String[][] weightNames = new String[numLabels][];
            int j = 0;
            while (j < numLabels) {
                String wn;
                String labelName;
                destinationNames[j] = labelName = (String)this.outputAlphabet.lookupObject(j);
                weightNames[j] = new String[2];
                weightNames[j][0] = labelName;
                weightNames[j][1] = wn = String.valueOf((String)this.outputAlphabet.lookupObject(i)) + "->" + (String)this.outputAlphabet.lookupObject(j);
                int wi = this.getWeightsIndex(wn);
                this.featureSelections[wi] = new FeatureSelection(trainingSet.getDataAlphabet());
                ++j;
            }
            this.addState((String)this.outputAlphabet.lookupObject(i), 0.0, 0.0, destinationNames, destinationNames, weightNames);
            ++i;
        }
    }

    public void addFullyConnectedStatesForBiLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels.length) {
                String[] destinationNames = new String[labels.length];
                int k = 0;
                while (k < labels.length) {
                    destinationNames[k] = String.valueOf(labels[j]) + LABEL_SEPARATOR + labels[k];
                    ++k;
                }
                this.addState(String.valueOf(labels[i]) + LABEL_SEPARATOR + labels[j], 0.0, 0.0, destinationNames, labels);
                ++j;
            }
            ++i;
        }
    }

    public void addStatesForBiLabelsConnectedAsIn(InstanceList trainingSet) {
        int numLabels = this.outputAlphabet.size();
        boolean[][] connections = this.labelConnectionsIn(trainingSet);
        int i = 0;
        while (i < numLabels) {
            int j = 0;
            while (j < numLabels) {
                if (connections[i][j]) {
                    int numDestinations = 0;
                    int k = 0;
                    while (k < numLabels) {
                        if (connections[j][k]) {
                            ++numDestinations;
                        }
                        ++k;
                    }
                    String[] destinationNames = new String[numDestinations];
                    String[] labels = new String[numDestinations];
                    int destinationIndex = 0;
                    int k2 = 0;
                    while (k2 < numLabels) {
                        if (connections[j][k2]) {
                            destinationNames[destinationIndex] = String.valueOf((String)this.outputAlphabet.lookupObject(j)) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(k2);
                            labels[destinationIndex] = (String)this.outputAlphabet.lookupObject(k2);
                            ++destinationIndex;
                        }
                        ++k2;
                    }
                    this.addState(String.valueOf((String)this.outputAlphabet.lookupObject(i)) + LABEL_SEPARATOR + (String)this.outputAlphabet.lookupObject(j), 0.0, 0.0, destinationNames, labels);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addFullyConnectedStatesForTriLabels() {
        String[] labels = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            ++i;
        }
        i = 0;
        while (i < labels.length) {
            int j = 0;
            while (j < labels.length) {
                int k = 0;
                while (k < labels.length) {
                    String[] destinationNames = new String[labels.length];
                    int l = 0;
                    while (l < labels.length) {
                        destinationNames[l] = String.valueOf(labels[j]) + LABEL_SEPARATOR + labels[k] + LABEL_SEPARATOR + labels[l];
                        ++l;
                    }
                    this.addState(String.valueOf(labels[i]) + LABEL_SEPARATOR + labels[j] + LABEL_SEPARATOR + labels[k], 0.0, 0.0, destinationNames, labels);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addSelfTransitioningStateForAllLabels(String name) {
        String[] labels = new String[this.outputAlphabet.size()];
        String[] destinationNames = new String[this.outputAlphabet.size()];
        int i = 0;
        while (i < this.outputAlphabet.size()) {
            logger.info("CRF: outputAlphabet.lookup class = " + this.outputAlphabet.lookupObject(i).getClass().getName());
            labels[i] = (String)this.outputAlphabet.lookupObject(i);
            destinationNames[i] = name;
            ++i;
        }
        this.addState(name, 0.0, 0.0, destinationNames, labels);
    }

    private String concatLabels(String[] labels) {
        String sep = "";
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < labels.length) {
            buf.append(sep).append(labels[i]);
            sep = LABEL_SEPARATOR;
            ++i;
        }
        return buf.toString();
    }

    private String nextKGram(String[] history, int k, String next) {
        int start;
        String sep = "";
        StringBuffer buf = new StringBuffer();
        int i = start = history.length + 1 - k;
        while (i < history.length) {
            buf.append(sep).append(history[i]);
            sep = LABEL_SEPARATOR;
            ++i;
        }
        buf.append(sep).append(next);
        return buf.toString();
    }

    private boolean allowedTransition(String prev, String curr, Pattern no, Pattern yes) {
        String pair = this.concatLabels(new String[]{prev, curr});
        if (no != null && no.matcher(pair).matches()) {
            return false;
        }
        return yes == null || yes.matcher(pair).matches();
    }

    private boolean allowedHistory(String[] history, Pattern no, Pattern yes) {
        int i = 1;
        while (i < history.length) {
            if (!this.allowedTransition(history[i - 1], history[i], no, yes)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String addOrderNStates(InstanceList trainingSet, int[] orders, boolean[] defaults, String start, Pattern forbidden, Pattern allowed, boolean fullyConnected) {
        boolean[][] connections = null;
        if (start != null) {
            this.outputAlphabet.lookupIndex(start);
        }
        if (!fullyConnected) {
            connections = this.labelConnectionsIn(trainingSet, start);
        }
        int order = -1;
        if (defaults != null && defaults.length != orders.length) {
            throw new IllegalArgumentException("Defaults must be null or match orders");
        }
        if (orders == null) {
            order = 0;
        } else {
            int i = 0;
            while (i < orders.length) {
                if (orders[i] <= order) {
                    throw new IllegalArgumentException("Orders must be non-negative and in ascending order");
                }
                order = orders[i];
                ++i;
            }
            if (order < 0) {
                order = 0;
            }
        }
        if (order > 0) {
            int[] historyIndexes = new int[order];
            String[] history = new String[order];
            String label0 = (String)this.outputAlphabet.lookupObject(0);
            int i = 0;
            while (i < order) {
                history[i] = label0;
                ++i;
            }
            int numLabels = this.outputAlphabet.size();
            block2: while (historyIndexes[0] < numLabels) {
                logger.info("Preparing " + this.concatLabels(history));
                if (this.allowedHistory(history, forbidden, allowed)) {
                    String stateName = this.concatLabels(history);
                    int nt = 0;
                    String[] destNames = new String[numLabels];
                    String[] labelNames = new String[numLabels];
                    String[][] weightNames = new String[numLabels][orders.length];
                    int nextIndex = 0;
                    while (nextIndex < numLabels) {
                        String next = (String)this.outputAlphabet.lookupObject(nextIndex);
                        if (this.allowedTransition(history[order - 1], next, forbidden, allowed) && (fullyConnected || connections[historyIndexes[order - 1]][nextIndex])) {
                            destNames[nt] = this.nextKGram(history, order, next);
                            labelNames[nt] = next;
                            int i2 = 0;
                            while (i2 < orders.length) {
                                weightNames[nt][i2] = this.nextKGram(history, orders[i2] + 1, next);
                                if (defaults != null && defaults[i2]) {
                                    int wi = this.getWeightsIndex(weightNames[nt][i2]);
                                    this.featureSelections[wi] = new FeatureSelection(trainingSet.getDataAlphabet());
                                }
                                ++i2;
                            }
                            ++nt;
                        }
                        ++nextIndex;
                    }
                    if (nt < numLabels) {
                        String[] newDestNames = new String[nt];
                        String[] newLabelNames = new String[nt];
                        String[][] newWeightNames = new String[nt][];
                        int t = 0;
                        while (t < nt) {
                            newDestNames[t] = destNames[t];
                            newLabelNames[t] = labelNames[t];
                            newWeightNames[t] = weightNames[t];
                            ++t;
                        }
                        destNames = newDestNames;
                        labelNames = newLabelNames;
                        weightNames = newWeightNames;
                    }
                    int i3 = 0;
                    while (i3 < destNames.length) {
                        StringBuffer b = new StringBuffer();
                        int j = 0;
                        while (j < orders.length) {
                            b.append(" ").append(weightNames[i3][j]);
                            ++j;
                        }
                        logger.info(String.valueOf(stateName) + "->" + destNames[i3] + "(" + labelNames[i3] + ")" + b.toString());
                        ++i3;
                    }
                    this.addState(stateName, 0.0, 0.0, destNames, labelNames, weightNames);
                }
                int o = order - 1;
                while (o >= 0) {
                    int n = o;
                    historyIndexes[n] = historyIndexes[n] + 1;
                    if (historyIndexes[n] < numLabels) {
                        history[o] = (String)this.outputAlphabet.lookupObject(historyIndexes[o]);
                        continue block2;
                    }
                    if (o > 0) {
                        historyIndexes[o] = 0;
                        history[o] = label0;
                    }
                    --o;
                }
            }
            int i4 = 0;
            while (i4 < order) {
                history[i4] = start;
                ++i4;
            }
            return this.concatLabels(history);
        }
        String[] stateNames = new String[this.outputAlphabet.size()];
        int s = 0;
        while (s < this.outputAlphabet.size()) {
            stateNames[s] = (String)this.outputAlphabet.lookupObject(s);
            ++s;
        }
        s = 0;
        while (s < this.outputAlphabet.size()) {
            this.addState(stateNames[s], 0.0, 0.0, stateNames, stateNames, stateNames);
            ++s;
        }
        return start;
    }

    public State getState(String name) {
        return this.name2state.get(name);
    }

    public void setWeights(int weightsIndex, SparseVector transitionWeights) {
        this.weightsStructureChanged();
        if (weightsIndex >= this.parameters.weights.length || weightsIndex < 0) {
            throw new IllegalArgumentException("weightsIndex " + weightsIndex + " is out of bounds");
        }
        this.parameters.weights[weightsIndex] = transitionWeights;
    }

    public void setWeights(String weightName, SparseVector transitionWeights) {
        this.setWeights(this.getWeightsIndex(weightName), transitionWeights);
    }

    public String getWeightsName(int weightIndex) {
        return (String)this.parameters.weightAlphabet.lookupObject(weightIndex);
    }

    public SparseVector getWeights(String weightName) {
        return this.parameters.weights[this.getWeightsIndex(weightName)];
    }

    public SparseVector getWeights(int weightIndex) {
        return this.parameters.weights[weightIndex];
    }

    public double[] getDefaultWeights() {
        return this.parameters.defaultWeights;
    }

    public SparseVector[] getWeights() {
        return this.parameters.weights;
    }

    public void setWeights(SparseVector[] m) {
        this.weightsStructureChanged();
        this.parameters.weights = m;
    }

    public void setDefaultWeights(double[] w) {
        this.weightsStructureChanged();
        this.parameters.defaultWeights = w;
    }

    public void setDefaultWeight(int widx, double val) {
        this.weightsValueChanged();
        this.parameters.defaultWeights[widx] = val;
    }

    public boolean isWeightsFrozen(int weightsIndex) {
        return this.parameters.weightsFrozen[weightsIndex];
    }

    public void freezeWeights(int weightsIndex) {
        this.parameters.weightsFrozen[weightsIndex] = true;
    }

    public void freezeWeights(String weightsName) {
        int widx = this.getWeightsIndex(weightsName);
        this.freezeWeights(widx);
    }

    public void unfreezeWeights(String weightsName) {
        int widx = this.getWeightsIndex(weightsName);
        this.parameters.weightsFrozen[widx] = false;
    }

    public void setFeatureSelection(int weightIdx, FeatureSelection fs) {
        this.featureSelections[weightIdx] = fs;
        this.weightsStructureChanged();
    }

    public void setWeightsDimensionAsIn(InstanceList trainingData) {
        this.setWeightsDimensionAsIn(trainingData, false);
    }

    public void setWeightsDimensionAsIn(InstanceList trainingData, boolean useSomeUnsupportedTrick) {
        int numWeights = 0;
        this.weightsStructureChanged();
        final BitSet[] weightsPresent = new BitSet[this.parameters.weights.length];
        int i = 0;
        while (i < this.parameters.weights.length) {
            weightsPresent[i] = new BitSet();
            ++i;
        }
        i = 0;
        while (i < this.parameters.weights.length) {
            int j = this.parameters.weights[i].numLocations() - 1;
            while (j >= 0) {
                weightsPresent[i].set(this.parameters.weights[i].indexAtLocation(j));
                --j;
            }
            ++i;
        }
        i = 0;
        while (i < trainingData.size()) {
            Instance instance = (Instance)trainingData.get(i);
            FeatureVectorSequence input = (FeatureVectorSequence)instance.getData();
            FeatureSequence output = (FeatureSequence)instance.getTarget();
            if (output != null && output.size() > 0) {
                this.sumLatticeFactory.newSumLattice(this, input, output, new Transducer.Incrementor(){

                    @Override
                    public void incrementTransition(Transducer.TransitionIterator ti, double count) {
                        State source = (State)ti.getSourceState();
                        FeatureVector input = (FeatureVector)ti.getInput();
                        int index = ti.getIndex();
                        int nwi = source.weightsIndices[index].length;
                        int wi = 0;
                        while (wi < nwi) {
                            int weightsIndex = source.weightsIndices[index][wi];
                            int i = 0;
                            while (i < input.numLocations()) {
                                int featureIndex = input.indexAtLocation(i);
                                if ((CRF.this.globalFeatureSelection == null || CRF.this.globalFeatureSelection.contains(featureIndex)) && (CRF.this.featureSelections == null || CRF.this.featureSelections[weightsIndex] == null || CRF.this.featureSelections[weightsIndex].contains(featureIndex))) {
                                    weightsPresent[weightsIndex].set(featureIndex);
                                }
                                ++i;
                            }
                            ++wi;
                        }
                    }

                    @Override
                    public void incrementInitialState(Transducer.State s, double count) {
                    }

                    @Override
                    public void incrementFinalState(Transducer.State s, double count) {
                    }
                });
            }
            if (useSomeUnsupportedTrick && this.getParametersAbsNorm() > 0.0) {
                if (i == 0) {
                    logger.info("CRF: Incremental training detected.  Adding weights for some unsupported features...");
                }
                this.sumLatticeFactory.newSumLattice(this, input, null, new Transducer.Incrementor(){

                    @Override
                    public void incrementTransition(Transducer.TransitionIterator ti, double count) {
                        if (count < 0.2) {
                            return;
                        }
                        State source = (State)ti.getSourceState();
                        FeatureVector input = (FeatureVector)ti.getInput();
                        int index = ti.getIndex();
                        int nwi = source.weightsIndices[index].length;
                        int wi = 0;
                        while (wi < nwi) {
                            int weightsIndex = source.weightsIndices[index][wi];
                            int i = 0;
                            while (i < input.numLocations()) {
                                int featureIndex = input.indexAtLocation(i);
                                if ((CRF.this.globalFeatureSelection == null || CRF.this.globalFeatureSelection.contains(featureIndex)) && (CRF.this.featureSelections == null || CRF.this.featureSelections[weightsIndex] == null || CRF.this.featureSelections[weightsIndex].contains(featureIndex))) {
                                    weightsPresent[weightsIndex].set(featureIndex);
                                }
                                ++i;
                            }
                            ++wi;
                        }
                    }

                    @Override
                    public void incrementInitialState(Transducer.State s, double count) {
                    }

                    @Override
                    public void incrementFinalState(Transducer.State s, double count) {
                    }
                });
            }
            ++i;
        }
        SparseVector[] newWeights = new SparseVector[this.parameters.weights.length];
        int i2 = 0;
        while (i2 < this.parameters.weights.length) {
            int numLocations = weightsPresent[i2].cardinality();
            logger.info("CRF weights[" + this.parameters.weightAlphabet.lookupObject(i2) + "] num features = " + numLocations);
            int[] indices = new int[numLocations];
            int j = 0;
            while (j < numLocations) {
                indices[j] = weightsPresent[i2].nextSetBit(j == 0 ? 0 : indices[j - 1] + 1);
                ++j;
            }
            newWeights[i2] = new IndexedSparseVector(indices, new double[numLocations], numLocations, numLocations, false, false, false);
            newWeights[i2].plusEqualsSparse(this.parameters.weights[i2]);
            numWeights += numLocations + 1;
            ++i2;
        }
        logger.info("Number of weights = " + numWeights);
        this.parameters.weights = newWeights;
    }

    public void setWeightsDimensionDensely() {
        this.weightsStructureChanged();
        SparseVector[] newWeights = new SparseVector[this.parameters.weights.length];
        int max = this.inputAlphabet.size();
        int numWeights = 0;
        logger.info("CRF using dense weights, num input features = " + max);
        int i = 0;
        while (i < this.parameters.weights.length) {
            int nfeatures;
            if (this.featureSelections[i] == null) {
                nfeatures = max;
                newWeights[i] = new SparseVector(null, new double[max], max, max, false, false, false);
            } else {
                FeatureSelection fs = this.featureSelections[i];
                nfeatures = fs.getBitSet().cardinality();
                int[] idxs = new int[nfeatures];
                int j = 0;
                int thisIdx = -1;
                while ((thisIdx = fs.nextSelectedIndex(thisIdx + 1)) >= 0) {
                    idxs[j++] = thisIdx;
                }
                newWeights[i] = new IndexedSparseVector(idxs, new double[nfeatures], nfeatures, nfeatures, false, false, false);
            }
            newWeights[i].plusEqualsSparse(this.parameters.weights[i]);
            numWeights += nfeatures + 1;
            ++i;
        }
        logger.info("Number of weights = " + numWeights);
        this.parameters.weights = newWeights;
    }

    public int getWeightsIndex(String weightName) {
        int wi = this.parameters.weightAlphabet.lookupIndex(weightName);
        if (wi == -1) {
            throw new IllegalArgumentException("Alphabet frozen, and no weight with name " + weightName);
        }
        if (this.parameters.weights == null) {
            assert (wi == 0);
            this.parameters.weights = new SparseVector[1];
            this.parameters.defaultWeights = new double[1];
            this.featureSelections = new FeatureSelection[1];
            this.parameters.weightsFrozen = new boolean[1];
            this.parameters.weights[0] = new IndexedSparseVector();
            this.parameters.defaultWeights[0] = 0.0;
            this.featureSelections[0] = null;
            this.weightsStructureChanged();
        } else if (wi == this.parameters.weights.length) {
            SparseVector[] newWeights = new SparseVector[this.parameters.weights.length + 1];
            double[] newDefaultWeights = new double[this.parameters.weights.length + 1];
            FeatureSelection[] newFeatureSelections = new FeatureSelection[this.parameters.weights.length + 1];
            int i = 0;
            while (i < this.parameters.weights.length) {
                newWeights[i] = this.parameters.weights[i];
                newDefaultWeights[i] = this.parameters.defaultWeights[i];
                newFeatureSelections[i] = this.featureSelections[i];
                ++i;
            }
            newWeights[wi] = new IndexedSparseVector();
            newDefaultWeights[wi] = 0.0;
            newFeatureSelections[wi] = null;
            this.parameters.weights = newWeights;
            this.parameters.defaultWeights = newDefaultWeights;
            this.featureSelections = newFeatureSelections;
            this.parameters.weightsFrozen = ArrayUtils.append(this.parameters.weightsFrozen, false);
            this.weightsStructureChanged();
        }
        return wi;
    }

    private void assertWeightsLength() {
        if (this.parameters.weights != null) {
            assert (this.parameters.defaultWeights != null);
            assert (this.featureSelections != null);
            assert (this.parameters.weightsFrozen != null);
            int n = this.parameters.weights.length;
            assert (this.parameters.defaultWeights.length == n);
            assert (this.featureSelections.length == n);
            assert (this.parameters.weightsFrozen.length == n);
        }
    }

    @Override
    public int numStates() {
        return this.states.size();
    }

    @Override
    public Transducer.State getState(int index) {
        return this.states.get(index);
    }

    @Override
    public Iterator initialStateIterator() {
        return this.initialStates.iterator();
    }

    public boolean isTrainable() {
        return true;
    }

    public int getWeightsValueChangeStamp() {
        return this.weightsValueChangeStamp;
    }

    public int getWeightsStructureChangeStamp() {
        return this.weightsStructureChangeStamp;
    }

    public Factors getParameters() {
        return this.parameters;
    }

    public double getParametersAbsNorm() {
        double ret = 0.0;
        int i = 0;
        while (i < this.numStates()) {
            ret += Math.abs(this.parameters.initialWeights[i]);
            ret += Math.abs(this.parameters.finalWeights[i]);
            ++i;
        }
        i = 0;
        while (i < this.parameters.weights.length) {
            ret += Math.abs(this.parameters.defaultWeights[i]);
            ret += this.parameters.weights[i].absNorm();
            ++i;
        }
        return ret;
    }

    public void setParameter(int sourceStateIndex, int destStateIndex, int featureIndex, double value) {
        this.setParameter(sourceStateIndex, destStateIndex, featureIndex, 0, value);
    }

    public void setParameter(int sourceStateIndex, int destStateIndex, int featureIndex, int weightIndex, double value) {
        this.weightsValueChanged();
        State source = (State)this.getState(sourceStateIndex);
        State dest = (State)this.getState(destStateIndex);
        int rowIndex = 0;
        while (rowIndex < source.destinationNames.length) {
            if (source.destinationNames[rowIndex].equals(dest.name)) break;
            ++rowIndex;
        }
        if (rowIndex == source.destinationNames.length) {
            throw new IllegalArgumentException("No transtition from state " + sourceStateIndex + " to state " + destStateIndex + ".");
        }
        int weightsIndex = source.weightsIndices[rowIndex][weightIndex];
        if (featureIndex < 0) {
            this.parameters.defaultWeights[weightsIndex] = value;
        } else {
            this.parameters.weights[weightsIndex].setValue(featureIndex, value);
        }
    }

    public double getParameter(int sourceStateIndex, int destStateIndex, int featureIndex) {
        return this.getParameter(sourceStateIndex, destStateIndex, featureIndex, 0);
    }

    public double getParameter(int sourceStateIndex, int destStateIndex, int featureIndex, int weightIndex) {
        State source = (State)this.getState(sourceStateIndex);
        State dest = (State)this.getState(destStateIndex);
        int rowIndex = 0;
        while (rowIndex < source.destinationNames.length) {
            if (source.destinationNames[rowIndex].equals(dest.name)) break;
            ++rowIndex;
        }
        if (rowIndex == source.destinationNames.length) {
            throw new IllegalArgumentException("No transtition from state " + sourceStateIndex + " to state " + destStateIndex + ".");
        }
        int weightsIndex = source.weightsIndices[rowIndex][weightIndex];
        if (featureIndex < 0) {
            return this.parameters.defaultWeights[weightsIndex];
        }
        return this.parameters.weights[weightsIndex].value(featureIndex);
    }

    public int getNumParameters() {
        if (this.cachedNumParametersStamp != this.weightsStructureChangeStamp) {
            this.numParameters = 2 * this.numStates() + this.parameters.defaultWeights.length;
            int i = 0;
            while (i < this.parameters.weights.length) {
                this.numParameters += this.parameters.weights[i].numLocations();
                ++i;
            }
        }
        return this.numParameters;
    }

    @Deprecated
    public Sequence[] predict(InstanceList testing) {
        testing.setFeatureSelection(this.globalFeatureSelection);
        int i = 0;
        while (i < this.featureInducers.size()) {
            FeatureInducer klfi = this.featureInducers.get(i);
            klfi.induceFeaturesFor(testing, false, false);
            ++i;
        }
        Sequence[] ret = new Sequence[testing.size()];
        int i2 = 0;
        while (i2 < testing.size()) {
            Instance instance = (Instance)testing.get(i2);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence<Object> predOutput = new MaxLatticeDefault(this, input).bestOutputSequence();
            assert (predOutput.size() == trueOutput.size());
            ret[i2] = predOutput;
            ++i2;
        }
        return ret;
    }

    @Deprecated
    public void evaluate(TransducerEvaluator eval, InstanceList testing) {
        throw new IllegalStateException("This method is no longer usable.  Use CRF.induceFeaturesFor() instead.");
    }

    public void induceFeaturesFor(InstanceList instances) {
        instances.setFeatureSelection(this.globalFeatureSelection);
        int i = 0;
        while (i < this.featureInducers.size()) {
            FeatureInducer klfi = this.featureInducers.get(i);
            klfi.induceFeaturesFor(instances, false, false);
            ++i;
        }
    }

    @Override
    public void print() {
        this.print(new PrintWriter((Writer)new OutputStreamWriter(System.out), true));
    }

    public void print(PrintWriter out) {
        out.println("*** CRF STATES ***");
        int i = 0;
        while (i < this.numStates()) {
            State s = (State)this.getState(i);
            out.print("STATE NAME=\"");
            out.print(s.name);
            out.print("\" (");
            out.print(s.destinations.length);
            out.print(" outgoing transitions)\n");
            out.print("  ");
            out.print("initialWeight = ");
            out.print(this.parameters.initialWeights[i]);
            out.print('\n');
            out.print("  ");
            out.print("finalWeight = ");
            out.print(this.parameters.finalWeights[i]);
            out.print('\n');
            out.println("  transitions:");
            int j = 0;
            while (j < s.destinations.length) {
                out.print("    ");
                out.print(s.name);
                out.print(" -> ");
                out.println(s.getDestinationState(j).getName());
                int k = 0;
                while (k < s.weightsIndices[j].length) {
                    out.print("        WEIGHTS = \"");
                    int widx = s.weightsIndices[j][k];
                    out.print(this.parameters.weightAlphabet.lookupObject(widx).toString());
                    out.print("\"\n");
                    ++k;
                }
                ++j;
            }
            out.println();
            ++i;
        }
        if (this.parameters.weights == null) {
            out.println("\n\n*** NO WEIGHTS ***");
        } else {
            out.println("\n\n*** CRF WEIGHTS ***");
            int widx = 0;
            while (widx < this.parameters.weights.length) {
                out.println("WEIGHTS NAME = " + this.parameters.weightAlphabet.lookupObject(widx));
                out.print(": <DEFAULT_FEATURE> = ");
                out.print(this.parameters.defaultWeights[widx]);
                out.print('\n');
                SparseVector transitionWeights = this.parameters.weights[widx];
                if (transitionWeights.numLocations() != 0) {
                    RankedFeatureVector rfv = new RankedFeatureVector(this.inputAlphabet, transitionWeights);
                    int m = 0;
                    while (m < rfv.numLocations()) {
                        double v = rfv.getValueAtRank(m);
                        int index = rfv.getIndexAtRank(m);
                        Object feature = this.inputAlphabet.lookupObject(index);
                        if (v != 0.0) {
                            out.print(": ");
                            out.print(feature);
                            out.print(" = ");
                            out.println(v);
                        }
                        ++m;
                    }
                }
                ++widx;
            }
        }
        out.flush();
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            System.err.println("Exception writing file " + f + ": " + e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.inputAlphabet);
        out.writeObject(this.outputAlphabet);
        out.writeObject(this.states);
        out.writeObject(this.initialStates);
        out.writeObject(this.name2state);
        out.writeObject(this.parameters);
        out.writeObject(this.globalFeatureSelection);
        out.writeObject(this.featureSelections);
        out.writeObject(this.featureInducers);
        out.writeInt(this.weightsValueChangeStamp);
        out.writeInt(this.weightsStructureChangeStamp);
        out.writeInt(this.cachedNumParametersStamp);
        out.writeInt(this.numParameters);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.inputAlphabet = (Alphabet)in.readObject();
        this.outputAlphabet = (Alphabet)in.readObject();
        this.states = (ArrayList)in.readObject();
        this.initialStates = (ArrayList)in.readObject();
        this.name2state = (HashMap)in.readObject();
        this.parameters = (Factors)in.readObject();
        this.globalFeatureSelection = (FeatureSelection)in.readObject();
        this.featureSelections = (FeatureSelection[])in.readObject();
        this.featureInducers = (ArrayList)in.readObject();
        this.weightsValueChangeStamp = in.readInt();
        this.weightsStructureChangeStamp = in.readInt();
        this.cachedNumParametersStamp = in.readInt();
        this.numParameters = in.readInt();
    }

    public static class Factors
    implements Serializable {
        public Alphabet weightAlphabet;
        public SparseVector[] weights;
        public double[] defaultWeights;
        public boolean[] weightsFrozen;
        public double[] initialWeights;
        public double[] finalWeights;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 1;

        public Factors() {
            this.weightAlphabet = new Alphabet();
            this.initialWeights = new double[0];
            this.finalWeights = new double[0];
        }

        public Factors(Factors other) {
            this.weightAlphabet = other.weightAlphabet;
            this.weights = new SparseVector[other.weights.length];
            int i = 0;
            while (i < this.weights.length) {
                this.weights[i] = (SparseVector)other.weights[i].cloneMatrixZeroed();
                ++i;
            }
            this.defaultWeights = new double[other.defaultWeights.length];
            this.weightsFrozen = other.weightsFrozen;
            this.initialWeights = new double[other.initialWeights.length];
            this.finalWeights = new double[other.finalWeights.length];
        }

        public Factors(Factors other, boolean cloneAlphabet) {
            this.weightAlphabet = cloneAlphabet ? (Alphabet)other.weightAlphabet.clone() : other.weightAlphabet;
            this.weights = new SparseVector[other.weights.length];
            int i = 0;
            while (i < this.weights.length) {
                this.weights[i] = (SparseVector)other.weights[i].cloneMatrix();
                ++i;
            }
            this.defaultWeights = (double[])other.defaultWeights.clone();
            this.weightsFrozen = other.weightsFrozen;
            this.initialWeights = (double[])other.initialWeights.clone();
            this.finalWeights = (double[])other.finalWeights.clone();
        }

        public Factors(CRF crf) {
            this.weightAlphabet = crf.parameters.weightAlphabet;
            this.weights = new SparseVector[crf.parameters.weights.length];
            int i = 0;
            while (i < this.weights.length) {
                this.weights[i] = (SparseVector)crf.parameters.weights[i].cloneMatrixZeroed();
                ++i;
            }
            this.defaultWeights = new double[crf.parameters.weights.length];
            this.weightsFrozen = crf.parameters.weightsFrozen;
            assert (crf.numStates() == crf.parameters.initialWeights.length);
            assert (crf.parameters.initialWeights.length == crf.parameters.finalWeights.length);
            this.initialWeights = new double[crf.parameters.initialWeights.length];
            this.finalWeights = new double[crf.parameters.finalWeights.length];
        }

        public int getNumFactors() {
            assert (this.initialWeights.length == this.finalWeights.length);
            assert (this.defaultWeights.length == this.weights.length);
            int ret = this.initialWeights.length + this.finalWeights.length + this.defaultWeights.length;
            int i = 0;
            while (i < this.weights.length) {
                ret += this.weights[i].numLocations();
                ++i;
            }
            return ret;
        }

        public void zero() {
            int i = 0;
            while (i < this.weights.length) {
                this.weights[i].setAll(0.0);
                ++i;
            }
            Arrays.fill(this.defaultWeights, 0.0);
            Arrays.fill(this.initialWeights, 0.0);
            Arrays.fill(this.finalWeights, 0.0);
        }

        public boolean structureMatches(Factors other) {
            if (this.weightAlphabet.size() != other.weightAlphabet.size()) {
                return false;
            }
            if (this.weights.length != other.weights.length) {
                return false;
            }
            int i = 0;
            while (i < this.weights.length) {
                if (this.weights[i].numLocations() != other.weights[i].numLocations()) {
                    return false;
                }
                ++i;
            }
            if (this.defaultWeights.length != other.defaultWeights.length) {
                return false;
            }
            assert (this.initialWeights.length == this.finalWeights.length);
            return this.initialWeights.length == other.initialWeights.length;
        }

        public void assertNotNaN() {
            int i = 0;
            while (i < this.weights.length) {
                assert (!this.weights[i].isNaN());
                ++i;
            }
            assert (!MatrixOps.isNaN(this.defaultWeights));
            assert (!MatrixOps.isNaN(this.initialWeights));
            assert (!MatrixOps.isNaN(this.finalWeights));
        }

        public void assertNotNaNOrInfinite() {
            int i = 0;
            while (i < this.weights.length) {
                assert (!this.weights[i].isNaNOrInfinite());
                ++i;
            }
            assert (!MatrixOps.isNaNOrInfinite(this.defaultWeights));
            assert (!MatrixOps.isNaNOrInfinite(this.initialWeights));
            assert (!MatrixOps.isNaNOrInfinite(this.finalWeights));
        }

        public void plusEquals(Factors other, double factor) {
            this.plusEquals(other, factor, false);
        }

        public void plusEquals(Factors other, double factor, boolean obeyWeightsFrozen) {
            int i = 0;
            while (i < this.weights.length) {
                if (!obeyWeightsFrozen || !this.weightsFrozen[i]) {
                    this.weights[i].plusEqualsSparse(other.weights[i], factor);
                    int n = i;
                    this.defaultWeights[n] = this.defaultWeights[n] + other.defaultWeights[i] * factor;
                }
                ++i;
            }
            i = 0;
            while (i < this.initialWeights.length) {
                int n = i;
                this.initialWeights[n] = this.initialWeights[n] + other.initialWeights[i] * factor;
                int n2 = i;
                this.finalWeights[n2] = this.finalWeights[n2] + other.finalWeights[i] * factor;
                ++i;
            }
        }

        public double gaussianPrior(double variance) {
            double value = 0.0;
            double priorDenom = 2.0 * variance;
            assert (this.initialWeights.length == this.finalWeights.length);
            int i = 0;
            while (i < this.initialWeights.length) {
                if (!Double.isInfinite(this.initialWeights[i])) {
                    value -= this.initialWeights[i] * this.initialWeights[i] / priorDenom;
                }
                if (!Double.isInfinite(this.finalWeights[i])) {
                    value -= this.finalWeights[i] * this.finalWeights[i] / priorDenom;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.weights.length) {
                if (!Double.isInfinite(this.defaultWeights[i2])) {
                    value -= this.defaultWeights[i2] * this.defaultWeights[i2] / priorDenom;
                }
                int j = 0;
                while (j < this.weights[i2].numLocations()) {
                    double w = this.weights[i2].valueAtLocation(j);
                    if (!Double.isInfinite(w)) {
                        value -= w * w / priorDenom;
                    }
                    ++j;
                }
                ++i2;
            }
            return value;
        }

        public void plusEqualsGaussianPriorGradient(Factors other, double variance) {
            assert (this.initialWeights.length == this.finalWeights.length);
            int i = 0;
            while (i < this.initialWeights.length) {
                if (!Double.isInfinite(this.initialWeights[i]) && !Double.isInfinite(other.initialWeights[i])) {
                    int n = i;
                    this.initialWeights[n] = this.initialWeights[n] - other.initialWeights[i] / variance;
                }
                if (!Double.isInfinite(this.finalWeights[i]) && !Double.isInfinite(other.finalWeights[i])) {
                    int n = i;
                    this.finalWeights[n] = this.finalWeights[n] - other.finalWeights[i] / variance;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.weights.length) {
                if (!this.weightsFrozen[i2]) {
                    if (!Double.isInfinite(this.defaultWeights[i2])) {
                        int n = i2;
                        this.defaultWeights[n] = this.defaultWeights[n] - other.defaultWeights[i2] / variance;
                    }
                    int j = 0;
                    while (j < this.weights[i2].numLocations()) {
                        double w = this.weights[i2].valueAtLocation(j);
                        double ow = other.weights[i2].valueAtLocation(j);
                        if (!Double.isInfinite(w)) {
                            this.weights[i2].setValueAtLocation(j, w - ow / variance);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }

        public double hyberbolicPrior(double slope, double sharpness) {
            double value = 0.0;
            assert (this.initialWeights.length == this.finalWeights.length);
            int i = 0;
            while (i < this.initialWeights.length) {
                if (!Double.isInfinite(this.initialWeights[i])) {
                    value -= slope / sharpness * Math.log(Maths.cosh(sharpness * -this.initialWeights[i]));
                }
                if (!Double.isInfinite(this.finalWeights[i])) {
                    value -= slope / sharpness * Math.log(Maths.cosh(sharpness * -this.finalWeights[i]));
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.weights.length) {
                value -= slope / sharpness * Math.log(Maths.cosh(sharpness * this.defaultWeights[i2]));
                int j = 0;
                while (j < this.weights[i2].numLocations()) {
                    double w = this.weights[i2].valueAtLocation(j);
                    if (!Double.isInfinite(w)) {
                        value -= slope / sharpness * Math.log(Maths.cosh(sharpness * w));
                    }
                    ++j;
                }
                ++i2;
            }
            return value;
        }

        public void plusEqualsHyperbolicPriorGradient(Factors other, double slope, double sharpness) {
            assert (this.initialWeights.length == this.finalWeights.length);
            double ss = slope * sharpness;
            int i = 0;
            while (i < this.initialWeights.length) {
                if (!Double.isInfinite(this.initialWeights[i]) && !Double.isInfinite(other.initialWeights[i])) {
                    int n = i;
                    this.initialWeights[n] = this.initialWeights[n] + ss * Maths.tanh(-other.initialWeights[i]);
                }
                if (!Double.isInfinite(this.finalWeights[i]) && !Double.isInfinite(other.finalWeights[i])) {
                    int n = i;
                    this.finalWeights[n] = this.finalWeights[n] + ss * Maths.tanh(-other.finalWeights[i]);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.weights.length) {
                if (!this.weightsFrozen[i2]) {
                    if (!Double.isInfinite(this.defaultWeights[i2])) {
                        int n = i2;
                        this.defaultWeights[n] = this.defaultWeights[n] + ss * Maths.tanh(-other.defaultWeights[i2]);
                    }
                    int j = 0;
                    while (j < this.weights[i2].numLocations()) {
                        double w = this.weights[i2].valueAtLocation(j);
                        double ow = other.weights[i2].valueAtLocation(j);
                        if (!Double.isInfinite(w)) {
                            this.weights[i2].setValueAtLocation(j, w + ss * Maths.tanh(-ow));
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }

        public double getParametersAbsNorm() {
            double ret = 0.0;
            int i = 0;
            while (i < this.initialWeights.length) {
                if (this.initialWeights[i] > Double.NEGATIVE_INFINITY) {
                    ret += Math.abs(this.initialWeights[i]);
                }
                if (this.finalWeights[i] > Double.NEGATIVE_INFINITY) {
                    ret += Math.abs(this.finalWeights[i]);
                }
                ++i;
            }
            i = 0;
            while (i < this.weights.length) {
                ret += Math.abs(this.defaultWeights[i]);
                int nl = this.weights[i].numLocations();
                int j = 0;
                while (j < nl) {
                    ret += Math.abs(this.weights[i].valueAtLocation(j));
                    ++j;
                }
                ++i;
            }
            return ret;
        }

        public void getParameters(double[] buffer) {
            if (buffer.length != this.getNumFactors()) {
                throw new IllegalArgumentException("Expected size of buffer: " + this.getNumFactors() + ", actual size: " + buffer.length);
            }
            int pi = 0;
            int i = 0;
            while (i < this.initialWeights.length) {
                buffer[pi++] = this.initialWeights[i];
                buffer[pi++] = this.finalWeights[i];
                ++i;
            }
            i = 0;
            while (i < this.weights.length) {
                buffer[pi++] = this.defaultWeights[i];
                int nl = this.weights[i].numLocations();
                int j = 0;
                while (j < nl) {
                    buffer[pi++] = this.weights[i].valueAtLocation(j);
                    ++j;
                }
                ++i;
            }
        }

        public double getParameter(int index) {
            int numStateParms = 2 * this.initialWeights.length;
            if (index < numStateParms) {
                if (index % 2 == 0) {
                    return this.initialWeights[index / 2];
                }
                return this.finalWeights[index / 2];
            }
            index -= numStateParms;
            int i = 0;
            while (i < this.weights.length) {
                if (index == 0) {
                    return this.defaultWeights[i];
                }
                if (--index < this.weights[i].numLocations()) {
                    return this.weights[i].valueAtLocation(index);
                }
                index -= this.weights[i].numLocations();
                ++i;
            }
            throw new IllegalArgumentException("index too high = " + index);
        }

        public void setParameters(double[] buff) {
            assert (buff.length == this.getNumFactors());
            int pi = 0;
            int i = 0;
            while (i < this.initialWeights.length) {
                this.initialWeights[i] = buff[pi++];
                this.finalWeights[i] = buff[pi++];
                ++i;
            }
            i = 0;
            while (i < this.weights.length) {
                this.defaultWeights[i] = buff[pi++];
                int nl = this.weights[i].numLocations();
                int j = 0;
                while (j < nl) {
                    this.weights[i].setValueAtLocation(j, buff[pi++]);
                    ++j;
                }
                ++i;
            }
        }

        public void setParameter(int index, double value) {
            int numStateParms = 2 * this.initialWeights.length;
            if (index < numStateParms) {
                if (index % 2 == 0) {
                    this.initialWeights[index / 2] = value;
                } else {
                    this.finalWeights[index / 2] = value;
                }
            } else {
                index -= numStateParms;
                int i = 0;
                while (i < this.weights.length) {
                    if (index == 0) {
                        this.defaultWeights[i] = value;
                        return;
                    }
                    if (--index < this.weights[i].numLocations()) {
                        this.weights[i].setValueAtLocation(index, value);
                        return;
                    }
                    index -= this.weights[i].numLocations();
                    ++i;
                }
                throw new IllegalArgumentException("index too high = " + index);
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
            out.writeObject(this.weightAlphabet);
            out.writeObject(this.weights);
            out.writeObject(this.defaultWeights);
            out.writeObject(this.weightsFrozen);
            out.writeObject(this.initialWeights);
            out.writeObject(this.finalWeights);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.weightAlphabet = (Alphabet)in.readObject();
            this.weights = (SparseVector[])in.readObject();
            this.defaultWeights = (double[])in.readObject();
            this.weightsFrozen = (boolean[])in.readObject();
            this.initialWeights = (double[])in.readObject();
            this.finalWeights = (double[])in.readObject();
        }

        public class Incrementor
        implements Transducer.Incrementor {
            @Override
            public void incrementFinalState(Transducer.State s, double count) {
                int n = s.getIndex();
                Factors.this.finalWeights[n] = Factors.this.finalWeights[n] + count;
            }

            @Override
            public void incrementInitialState(Transducer.State s, double count) {
                int n = s.getIndex();
                Factors.this.initialWeights[n] = Factors.this.initialWeights[n] + count;
            }

            @Override
            public void incrementTransition(Transducer.TransitionIterator ti, double count) {
                int index = ti.getIndex();
                State source = (State)ti.getSourceState();
                int nwi = source.weightsIndices[index].length;
                int wi = 0;
                while (wi < nwi) {
                    int weightsIndex = source.weightsIndices[index][wi];
                    if (!Factors.this.weightsFrozen[weightsIndex]) {
                        Factors.this.weights[weightsIndex].plusEqualsSparse((FeatureVector)ti.getInput(), count);
                        int n = weightsIndex;
                        Factors.this.defaultWeights[n] = Factors.this.defaultWeights[n] + count;
                    }
                    ++wi;
                }
            }
        }

        public class WeightedIncrementor
        implements Transducer.Incrementor {
            double instanceWeight = 1.0;

            public WeightedIncrementor(double instanceWeight) {
                this.instanceWeight = instanceWeight;
            }

            @Override
            public void incrementFinalState(Transducer.State s, double count) {
                int n = s.getIndex();
                Factors.this.finalWeights[n] = Factors.this.finalWeights[n] + count * this.instanceWeight;
            }

            @Override
            public void incrementInitialState(Transducer.State s, double count) {
                int n = s.getIndex();
                Factors.this.initialWeights[n] = Factors.this.initialWeights[n] + count * this.instanceWeight;
            }

            @Override
            public void incrementTransition(Transducer.TransitionIterator ti, double count) {
                int index = ti.getIndex();
                State source = (State)ti.getSourceState();
                int nwi = source.weightsIndices[index].length;
                count *= this.instanceWeight;
                int wi = 0;
                while (wi < nwi) {
                    int weightsIndex = source.weightsIndices[index][wi];
                    if (!Factors.this.weightsFrozen[weightsIndex]) {
                        Factors.this.weights[weightsIndex].plusEqualsSparse((FeatureVector)ti.getInput(), count);
                        int n = weightsIndex;
                        Factors.this.defaultWeights[n] = Factors.this.defaultWeights[n] + count;
                    }
                    ++wi;
                }
            }
        }
    }

    public static class State
    extends Transducer.State
    implements Serializable {
        String name;
        int index;
        String[] destinationNames;
        State[] destinations;
        int[][] weightsIndices;
        String[] labels;
        CRF crf;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        protected State() {
        }

        protected State(String name, int index, double initialWeight, double finalWeight, String[] destinationNames, String[] labelNames, String[][] weightNames, CRF crf) {
            assert (destinationNames.length == labelNames.length);
            assert (destinationNames.length == weightNames.length);
            this.name = name;
            this.index = index;
            crf.parameters.initialWeights[index] = initialWeight;
            crf.parameters.finalWeights[index] = finalWeight;
            this.destinationNames = new String[destinationNames.length];
            this.destinations = new State[labelNames.length];
            this.weightsIndices = new int[labelNames.length][];
            this.labels = new String[labelNames.length];
            this.crf = crf;
            int i = 0;
            while (i < labelNames.length) {
                crf.outputAlphabet.lookupIndex(labelNames[i]);
                this.destinationNames[i] = destinationNames[i];
                this.labels[i] = labelNames[i];
                this.weightsIndices[i] = new int[weightNames[i].length];
                int j = 0;
                while (j < weightNames[i].length) {
                    this.weightsIndices[i][j] = crf.getWeightsIndex(weightNames[i][j]);
                    ++j;
                }
                ++i;
            }
            crf.weightsStructureChanged();
        }

        @Override
        public Transducer getTransducer() {
            return this.crf;
        }

        @Override
        public double getInitialWeight() {
            return this.crf.parameters.initialWeights[this.index];
        }

        @Override
        public void setInitialWeight(double c) {
            this.crf.parameters.initialWeights[this.index] = c;
        }

        @Override
        public double getFinalWeight() {
            return this.crf.parameters.finalWeights[this.index];
        }

        @Override
        public void setFinalWeight(double c) {
            this.crf.parameters.finalWeights[this.index] = c;
        }

        public void print() {
            System.out.println("State #" + this.index + " \"" + this.name + "\"");
            System.out.println("initialWeight=" + this.crf.parameters.initialWeights[this.index] + ", finalWeight=" + this.crf.parameters.finalWeights[this.index]);
            System.out.println("#destinations=" + this.destinations.length);
            int i = 0;
            while (i < this.destinations.length) {
                System.out.println("-> " + this.destinationNames[i]);
                ++i;
            }
        }

        public int numDestinations() {
            return this.destinations.length;
        }

        public String[] getWeightNames(int index) {
            int[] indices = this.weightsIndices[index];
            String[] ret = new String[indices.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = this.crf.parameters.weightAlphabet.lookupObject(indices[i]).toString();
                ++i;
            }
            return ret;
        }

        public void addWeight(int didx, String weightName) {
            int widx = this.crf.getWeightsIndex(weightName);
            this.weightsIndices[didx] = ArrayUtils.append(this.weightsIndices[didx], widx);
        }

        public String getLabelName(int index) {
            return this.labels[index];
        }

        public State getDestinationState(int index) {
            State ret = this.destinations[index];
            if (ret == null && (ret = (this.destinations[index] = this.crf.name2state.get(this.destinationNames[index]))) == null) {
                throw new IllegalArgumentException("this.name=" + this.name + " index=" + index + " destinationNames[index]=" + this.destinationNames[index] + " name2state.size()=" + this.crf.name2state.size());
            }
            return ret;
        }

        @Override
        public Transducer.TransitionIterator transitionIterator(Sequence inputSequence, int inputPosition, Sequence outputSequence, int outputPosition) {
            if (inputPosition < 0 || outputPosition < 0) {
                throw new UnsupportedOperationException("Epsilon transitions not implemented.");
            }
            if (inputSequence == null) {
                throw new UnsupportedOperationException("CRFs are not generative models; must have an input sequence.");
            }
            return new TransitionIterator(this, (FeatureVectorSequence)inputSequence, inputPosition, outputSequence == null ? null : (String)outputSequence.get(outputPosition), this.crf);
        }

        public Transducer.TransitionIterator transitionIterator(FeatureVector fv, String output) {
            return new TransitionIterator(this, fv, output, this.crf);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public final int getIndex() {
            return this.index;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.name);
            out.writeInt(this.index);
            out.writeObject(this.destinationNames);
            out.writeObject(this.destinations);
            out.writeObject(this.weightsIndices);
            out.writeObject(this.labels);
            out.writeObject(this.crf);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.readInt();
            this.name = (String)in.readObject();
            this.index = in.readInt();
            this.destinationNames = (String[])in.readObject();
            this.destinations = (State[])in.readObject();
            this.weightsIndices = (int[][])in.readObject();
            this.labels = (String[])in.readObject();
            this.crf = (CRF)in.readObject();
        }
    }

    protected static class TransitionIterator
    extends Transducer.TransitionIterator
    implements Serializable {
        State source;
        int index;
        int nextIndex;
        protected double[] weights;
        FeatureVector input;
        CRF crf;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;
        private static final int NULL_INTEGER = -1;

        public TransitionIterator(State source, FeatureVectorSequence inputSeq, int inputPosition, String output, CRF crf) {
            this(source, inputSeq.get(inputPosition), output, crf);
        }

        protected TransitionIterator(State source, FeatureVector fv, String output, CRF crf) {
            this.source = source;
            this.crf = crf;
            this.input = fv;
            this.weights = new double[source.destinations.length];
            int transIndex = 0;
            while (transIndex < source.destinations.length) {
                if (output == null || output.equals(source.labels[transIndex])) {
                    this.weights[transIndex] = 0.0;
                    int nwi = source.weightsIndices[transIndex].length;
                    int wi = 0;
                    while (wi < nwi) {
                        int swi = source.weightsIndices[transIndex][wi];
                        int n = transIndex;
                        this.weights[n] = this.weights[n] + (crf.parameters.weights[swi].dotProduct(fv) + crf.parameters.defaultWeights[swi]);
                        ++wi;
                    }
                    assert (!Double.isNaN(this.weights[transIndex]));
                    assert (this.weights[transIndex] != Double.POSITIVE_INFINITY);
                } else {
                    this.weights[transIndex] = Double.NEGATIVE_INFINITY;
                }
                ++transIndex;
            }
            this.nextIndex = 0;
            while (this.nextIndex < source.destinations.length && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
                ++this.nextIndex;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.source.destinations.length;
        }

        @Override
        public Transducer.State nextState() {
            assert (this.nextIndex < this.source.destinations.length);
            this.index = this.nextIndex++;
            while (this.nextIndex < this.source.destinations.length && this.weights[this.nextIndex] == Double.NEGATIVE_INFINITY) {
                ++this.nextIndex;
            }
            return this.source.getDestinationState(this.index);
        }

        @Override
        public final int getIndex() {
            return this.index;
        }

        @Override
        public final Object getInput() {
            return this.input;
        }

        @Override
        public final Object getOutput() {
            return this.source.labels[this.index];
        }

        @Override
        public final double getWeight() {
            return this.weights[this.index];
        }

        @Override
        public final Transducer.State getSourceState() {
            return this.source;
        }

        @Override
        public final Transducer.State getDestinationState() {
            return this.source.getDestinationState(this.index);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.source);
            out.writeInt(this.index);
            out.writeInt(this.nextIndex);
            out.writeObject(this.weights);
            out.writeObject(this.input);
            out.writeObject(this.crf);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.readInt();
            this.source = (State)in.readObject();
            this.index = in.readInt();
            this.nextIndex = in.readInt();
            this.weights = (double[])in.readObject();
            this.input = (FeatureVector)in.readObject();
            this.crf = (CRF)in.readObject();
        }

        @Override
        public String describeTransition(double cutoff) {
            DecimalFormat f = new DecimalFormat("0.###");
            StringBuffer buf = new StringBuffer();
            buf.append("Value: " + f.format(-this.getWeight()) + " <br />\n");
            try {
                int[] theseWeights = this.source.weightsIndices[this.index];
                int i = 0;
                while (i < theseWeights.length) {
                    int wi = theseWeights[i];
                    SparseVector w = this.crf.parameters.weights[wi];
                    buf.append("WEIGHTS <br />\n" + this.crf.parameters.weightAlphabet.lookupObject(wi) + "<br />\n");
                    buf.append("  d.p. = " + f.format(w.dotProduct(this.input)) + "<br />\n");
                    double[] vals = new double[this.input.numLocations()];
                    double[] absVals = new double[this.input.numLocations()];
                    int k = 0;
                    while (k < vals.length) {
                        int index = this.input.indexAtLocation(k);
                        vals[k] = w.value(index) * this.input.value(index);
                        absVals[k] = Math.abs(vals[k]);
                        ++k;
                    }
                    buf.append("DEFAULT " + f.format(this.crf.parameters.defaultWeights[wi]) + "<br />\n");
                    RankedFeatureVector rfv = new RankedFeatureVector(this.crf.inputAlphabet, this.input.getIndices(), absVals);
                    int rank = 0;
                    while (rank < absVals.length) {
                        int fidx = rfv.getIndexAtRank(rank);
                        Object fname = this.crf.inputAlphabet.lookupObject(this.input.indexAtLocation(fidx));
                        if (absVals[fidx] < cutoff) break;
                        if (vals[fidx] != 0.0) {
                            buf.append(fname + " " + f.format(vals[fidx]) + "<br />\n");
                        }
                        ++rank;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("Error writing transition descriptions.");
                e.printStackTrace();
                buf.append("ERROR WHILE WRITING OUTPUT...\n");
            }
            return buf.toString();
        }
    }
}

