/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.utils;

import java.util.ArrayList;
import java.util.HashMap;

public class IOBEvaluation {
    public String getType() {
        return "IOB tags";
    }

    public static double[] evaluate(ArrayList<?> gold_tok, ArrayList<?> eval_tok) throws Exception {
        if (gold_tok.size() != eval_tok.size()) {
            System.out.println(gold_tok);
            System.out.println(eval_tok);
            throw new Exception("size of gold standard different from predicted data");
        }
        ArrayList<String> gold = new ArrayList<String>();
        ArrayList<String> eval = new ArrayList<String>();
        for (int i = 0; i < gold_tok.size(); ++i) {
            String[] gTok = ((String)gold_tok.get(i)).split("[\\s]+");
            String[] eTok = ((String)eval_tok.get(i)).split("\t");
            if (gTok.length != 2) {
                System.err.println("ERR: format error in gold file. IOB format must be: token<tab>label");
                System.exit(-1);
            } else if (eTok.length != 2) {
                System.err.println("ERR: format error in eval file. IOB format must be: token<tab>label");
                System.exit(-1);
            }
            gold.add(gTok[1]);
            eval.add(eTok[1]);
        }
        return IOBEvaluation.getValuesMulti(gold, eval);
    }

    private static double[] getValuesMulti(ArrayList<String> gold, ArrayList<String> eval) {
        if (gold.size() != eval.size()) {
            System.err.println("error!, gold.size!=eval.size -> I quit!");
            System.exit(0);
        }
        HashMap<String, String> gold_chunks = IOBEvaluation.getChunksMulti(gold);
        HashMap<String, String> eval_chunks = IOBEvaluation.getChunksMulti(eval);
        int numcorr = 0;
        int numans = eval_chunks.size();
        int numref = gold_chunks.size();
        for (String offset : eval_chunks.keySet()) {
            String tags_gold;
            String tags_eval;
            if (!gold_chunks.containsKey(offset) || !(tags_eval = eval_chunks.get(offset)).equals(tags_gold = gold_chunks.get(offset))) continue;
            ++numcorr;
        }
        double precision = 0.0;
        double recall = 0.0;
        double fscore = 0.0;
        if (numans > 0) {
            precision = (double)numcorr / (double)numans;
        }
        if (numref > 0) {
            recall = (double)numcorr / (double)numref;
        }
        if (precision + recall > 0.0) {
            fscore = 2.0 * precision * recall / (precision + recall);
        }
        double[] values = new double[]{recall, precision, fscore};
        return values;
    }

    static HashMap<String, String> getChunksMulti(ArrayList<String> taglist) {
        int begin = -1;
        int end = -1;
        boolean inside = false;
        HashMap<String, String> blocks = new HashMap<String, String>();
        for (int i = 0; i < taglist.size(); ++i) {
            int j;
            String info;
            String curr_tag = taglist.get(i);
            String curr_marker = "";
            if (curr_tag.length() != 0) {
                curr_marker = curr_tag.substring(0, 1);
                curr_tag = curr_marker.equals("O") ? "" : curr_tag.substring(2, curr_tag.length());
            }
            if (!inside) {
                if (!curr_marker.equals("B")) continue;
                inside = true;
                begin = i;
                end = -1;
                continue;
            }
            if (curr_marker.equals("B")) {
                end = i - 1;
                info = "";
                for (j = begin; j < end + 1; ++j) {
                    if (info.length() > 0) {
                        info = info + "#";
                    }
                    info = info + taglist.get(j);
                }
                blocks.put(begin + "," + end, info);
                begin = i;
                end = -1;
                continue;
            }
            if (!curr_marker.equals("O") && !curr_marker.equals("")) continue;
            end = i - 1;
            info = "";
            for (j = begin; j < end + 1; ++j) {
                if (info.length() > 0) {
                    info = info + "#";
                }
                info = info + taglist.get(j);
            }
            blocks.put(begin + "," + end, info);
            begin = -1;
            end = -1;
            inside = false;
        }
        return blocks;
    }
}

