/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseVector;
import cc.mallet.types.SparseVector;
import cc.mallet.util.MalletLogger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Logger;

public class IndexedSparseVector
extends SparseVector
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(SparseVector.class.getName());
    private transient int[] index2location;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public IndexedSparseVector(int[] indices, double[] values, int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        super(indices, values, capacity, size, copy, checkIndicesSorted, removeDuplicates);
        assert (indices != null);
    }

    public IndexedSparseVector() {
        super(new int[0], new double[0], 0, 0, false, false, false);
    }

    public IndexedSparseVector(int[] featureIndices, double[] values) {
        super(featureIndices, values);
    }

    public IndexedSparseVector(int[] featureIndices) {
        super(featureIndices);
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        return new IndexedSparseVector(this.indices, this.values);
    }

    @Override
    public ConstantMatrix cloneMatrixZeroed() {
        assert (this.values != null);
        int[] newIndices = new int[this.indices.length];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        IndexedSparseVector sv = new IndexedSparseVector(newIndices, new double[this.values.length], this.values.length, this.values.length, false, false, false);
        if (this.index2location != null) {
            sv.index2location = this.index2location;
        }
        return sv;
    }

    public void indexVector() {
        if (this.index2location == null && this.indices.length > 0) {
            this.setIndex2Location();
        }
    }

    private void setIndex2Location() {
        assert (this.indices != null);
        assert (this.index2location == null);
        int size = this.indices.length == 0 ? 0 : this.indices[this.indices.length - 1] + 1;
        assert (size >= this.indices.length);
        this.index2location = new int[size];
        Arrays.fill(this.index2location, -1);
        int i = 0;
        while (i < this.indices.length) {
            this.index2location[this.indices[i]] = i;
            ++i;
        }
    }

    @Override
    public final void setValue(int index, double value) {
        int location;
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int n = location = index < this.index2location.length ? this.index2location[index] : -1;
        if (location < 0) {
            throw new IllegalArgumentException("Trying to set value that isn't present in IndexedSparseVector");
        }
        this.values[location] = value;
    }

    @Override
    public final void setValueAtLocation(int location, double value) {
        this.values[location] = value;
    }

    public void columnPlusEquals(int index, double value) {
        int location;
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int n = location = index < this.index2location.length ? this.index2location[index] : -1;
        if (location < 0) {
            throw new IllegalArgumentException("Trying to set value that isn't present in IndexedSparseVector");
        }
        int n2 = location;
        this.values[n2] = this.values[n2] + value;
    }

    @Override
    public final double dotProduct(DenseVector v) {
        double ret = 0.0;
        if (this.values == null) {
            int i = 0;
            while (i < this.indices.length) {
                ret += v.value(this.indices[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.indices.length) {
                ret += this.values[i] * v.value(this.indices[i]);
                ++i;
            }
        }
        return ret;
    }

    @Override
    public final double dotProduct(SparseVector v) {
        if (this.indices.length == 0) {
            return 0.0;
        }
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        double ret = 0.0;
        int vNumLocs = v.numLocations();
        if (this.isBinary()) {
            int i = 0;
            while (i < vNumLocs) {
                int index = v.indexAtLocation(i);
                if (index < this.index2location.length) {
                    if (this.index2location[index] >= 0) {
                        ret += v.valueAtLocation(i);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else if (v.isBinary()) {
            int i = 0;
            while (i < vNumLocs) {
                int index = v.indexAtLocation(i);
                if (index < this.index2location.length) {
                    int location = this.index2location[index];
                    if (location >= 0) {
                        ret += this.values[location];
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < vNumLocs) {
                int index = v.indexAtLocation(i);
                if (index < this.index2location.length) {
                    int location = this.index2location[index];
                    if (location >= 0) {
                        ret += this.values[location] * v.valueAtLocation(i);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        return ret;
    }

    @Override
    public final void plusEqualsSparse(SparseVector v, double factor) {
        if (this.indices.length == 0) {
            return;
        }
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int i = 0;
        while (i < v.numLocations()) {
            int index = v.indexAtLocation(i);
            if (index >= this.index2location.length) break;
            int location = this.index2location[index];
            if (location >= 0) {
                int n = location;
                this.values[n] = this.values[n] + v.valueAtLocation(i) * factor;
            }
            ++i;
        }
    }

    @Override
    public final void plusEqualsSparse(SparseVector v) {
        if (this.indices.length == 0) {
            return;
        }
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        int i = 0;
        while (i < v.numLocations()) {
            int index = v.indexAtLocation(i);
            if (index >= this.index2location.length) break;
            int location = this.index2location[index];
            if (location >= 0) {
                int n = location;
                this.values[n] = this.values[n] + v.valueAtLocation(i);
            }
            ++i;
        }
    }

    @Override
    public final void setAll(double v) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = v;
            ++i;
        }
    }

    @Override
    public int location(int index) {
        if (this.index2location == null) {
            this.setIndex2Location();
        }
        if (index >= this.index2location.length) {
            return -1;
        }
        return this.index2location[index];
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }
}

