/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.TransducerSequenceConfidenceEstimator;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import cc.mallet.types.SequencePairAlignment;
import cc.mallet.util.MalletLogger;
import java.util.List;
import java.util.logging.Logger;

public class NBestViterbiConfidenceEstimator
extends TransducerSequenceConfidenceEstimator {
    int N;
    private static Logger logger = MalletLogger.getLogger(NBestViterbiConfidenceEstimator.class.getName());

    public NBestViterbiConfidenceEstimator(Transducer model, int N) {
        super(model);
        this.N = N;
    }

    @Override
    public double estimateConfidenceFor(Instance instance, Object[] startTags, Object[] inTags) {
        SumLatticeDefault lattice = new SumLatticeDefault(this.model, (Sequence)instance.getData());
        double[] costs = new double[this.N];
        List<SequencePairAlignment<Object, Object>> as = new MaxLatticeDefault(this.model, (Sequence)instance.getData()).bestOutputAlignments(this.N);
        int i = 0;
        while (i < this.N) {
            costs[i] = as.get(i).getWeight();
            ++i;
        }
        double latticeCost = lattice.getTotalWeight();
        double prFirstIsCorrect = Math.exp(latticeCost - costs[0]);
        double prOtherIsCorrect = 0.0;
        int i2 = 1;
        while (i2 < this.N) {
            prOtherIsCorrect += Math.exp(latticeCost - costs[i2]);
            ++i2;
        }
        return prFirstIsCorrect / prOtherIsCorrect;
    }
}

