/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classification;
import cc.mallet.classify.Classifier;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;

public class ClassifierEnsemble
extends Classifier {
    Classifier[] ensemble;
    double[] weights;

    public ClassifierEnsemble(Classifier[] classifiers, double[] weights) {
        this.ensemble = new Classifier[classifiers.length];
        int i = 0;
        while (i < classifiers.length) {
            if (i > 0 && this.ensemble[i - 1].getLabelAlphabet() != classifiers[i].getLabelAlphabet()) {
                throw new IllegalStateException("LabelAlphabet's do not match.");
            }
            this.ensemble[i] = classifiers[i];
            ++i;
        }
        System.arraycopy(classifiers, 0, this.ensemble, 0, classifiers.length);
        this.weights = (double[])weights.clone();
    }

    @Override
    public Classification classify(Instance instance) {
        int numLabels = this.ensemble[0].getLabelAlphabet().size();
        double[] scores = new double[numLabels];
        int i = 0;
        while (i < this.ensemble.length) {
            Classification c = this.ensemble[i].classify(instance);
            c.getLabelVector().addTo(scores, this.weights[i]);
            ++i;
        }
        ClassifierEnsemble.expNormalize(scores);
        return new Classification(instance, this, new LabelVector(this.ensemble[0].getLabelAlphabet(), scores));
    }

    private static void expNormalize(double[] a) {
        double max = MatrixOps.max(a);
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            assert (!Double.isNaN(a[i]));
            a[i] = Math.exp(a[i] - max);
            sum += a[i];
            ++i;
        }
        i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] / sum;
        }
    }
}

