/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.utility.index;

import de.julielab.jcore.utility.index.IndexTermGenerator;
import de.julielab.jcore.utility.index.JCoReAnnotationIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class JCoReMapAnnotationIndex<K extends Comparable<K>, T extends Annotation>
implements JCoReAnnotationIndex<T> {
    protected final Map<K, Collection<T>> index;
    protected final IndexTermGenerator<K> indexTermGenerator;
    protected final IndexTermGenerator<K> searchTermGenerator;
    protected Supplier<Collection<T>> indexAnnotationStorageSupplier;

    public JCoReMapAnnotationIndex(Supplier<Map<K, Collection<T>>> indexMapSupplier, IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator, JCas jCas, Type type) {
        this.indexTermGenerator = indexTermGenerator;
        this.searchTermGenerator = searchTermGenerator;
        this.index = indexMapSupplier.get();
        this.indexAnnotationStorageSupplier = ArrayList::new;
        if (jCas != null && type != null) {
            this.index(jCas, type);
        }
    }

    public JCoReMapAnnotationIndex(Supplier<Map<K, Collection<T>>> indexMapSupplier, IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator, JCas jCas, int type) {
        this(indexMapSupplier, indexTermGenerator, searchTermGenerator, jCas, jCas.getCasType(type));
    }

    public JCoReMapAnnotationIndex(Supplier<Map<K, Collection<T>>> indexMapSupplier, IndexTermGenerator<K> indexTermGenerator, IndexTermGenerator<K> searchTermGenerator) {
        this(indexMapSupplier, indexTermGenerator, searchTermGenerator, null, null);
    }

    @Override
    public void index(JCas jCas, int type) {
        this.index(jCas, jCas.getCasType(type));
    }

    @Override
    public void index(JCas jCas, Type type) {
        for (Annotation annotation : jCas.getAnnotationIndex(type)) {
            this.index(annotation);
        }
    }

    @Override
    public void index(T a) {
        Object o = this.indexTermGenerator.generateIndexTerms((Annotation)a);
        if (o instanceof Stream) {
            Stream indexTerms = (Stream)o;
            indexTerms.forEach(t -> this.index(t, a));
            indexTerms.close();
        } else {
            this.index((Comparable)o, a);
        }
    }

    private void index(K t, T a) {
        Collection<T> annotations = this.index.get(t);
        if (annotations == null) {
            annotations = this.indexAnnotationStorageSupplier.get();
            this.index.put(t, annotations);
        }
        annotations.add(a);
    }

    public Stream<T> search(Annotation a) {
        Object o = this.searchTermGenerator.generateIndexTerms(a);
        if (o instanceof Stream) {
            Stream searchTerms = (Stream)o;
            return this.search((K)searchTerms);
        }
        return this.search((Comparable)o);
    }

    public Stream<T> search(Stream<K> searchTerms) {
        Stream<T> hits = null;
        Iterator it = searchTerms.iterator();
        while (it.hasNext()) {
            Comparable t = (Comparable)it.next();
            Collection<T> hit = this.index.get(t);
            if (hit == null) continue;
            if (hits == null) {
                hits = hit.stream();
                continue;
            }
            Stream.concat(hits, hit.stream());
        }
        return hits;
    }

    public Stream<T> search(K searchTerm) {
        Collection<T> collection = this.index.get(searchTerm);
        return collection != null ? collection.stream() : Stream.empty();
    }

    public T getFirst(K searchTerm) {
        Collection<T> collection = this.index.get(searchTerm);
        if (collection == null) {
            return null;
        }
        Iterator<T> it = collection.iterator();
        if (it.hasNext()) {
            return (T)((Annotation)it.next());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirst(Annotation a) {
        Object o = this.searchTermGenerator.generateIndexTerms(a);
        if (o instanceof Stream) {
            Annotation result = null;
            try (Stream searchTerms = (Stream)o;){
                Iterator it = searchTerms.iterator();
                while (it.hasNext()) {
                    Comparable term = (Comparable)it.next();
                    Collection<T> annotations = this.index.get(term);
                    Iterator<T> annIt = annotations.iterator();
                    if (!annIt.hasNext()) continue;
                    Annotation annotation = result = (Annotation)annIt.next();
                    return (T)annotation;
                }
            }
            return (T)result;
        }
        return this.getFirst((Comparable)o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K searchTerm) {
        Collection<T> collection = this.index.get(searchTerm);
        if (collection == null) {
            return null;
        }
        Iterator<T> it = collection.iterator();
        try {
            if (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                return (T)annotation;
            }
            T t = null;
            return t;
        }
        finally {
            if (it.hasNext()) {
                throw new IllegalStateException("There are multiple values associated with key \"" + searchTerm + "\". Use the search(K) method.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Annotation a) {
        Object o = this.searchTermGenerator.generateIndexTerms(a);
        if (o instanceof Stream) {
            Annotation result = null;
            try (Stream searchTerms = (Stream)o;){
                Iterator it = searchTerms.iterator();
                while (it.hasNext()) {
                    Comparable term = (Comparable)it.next();
                    Collection<T> annotations = this.index.get(term);
                    if (annotations != null && result == null) {
                        Iterator<T> annIt = annotations.iterator();
                        if (annIt.hasNext()) {
                            result = (Annotation)annIt.next();
                        }
                        if (!it.hasNext()) continue;
                        throw new IllegalStateException("There are multiple values associated with key \"" + term + "\". Use the search(Annotation) method.");
                    }
                    if (annotations == null) continue;
                    throw new IllegalStateException("Multiple search terms produced search hits for annotation " + a + ". Use the search(Annotation) method.");
                }
            }
            return (T)result;
        }
        return this.get((Comparable)o);
    }

    public Map<K, Collection<T>> getIndex() {
        return this.index;
    }

    public void setIndexAnnotationStorageSupplier(Supplier<Collection<T>> supplier) {
        if (!this.index.isEmpty()) {
            throw new IllegalStateException("The index must be empty when the supplier for the internal storage of annotations is changed.");
        }
        this.indexAnnotationStorageSupplier = supplier;
    }

    @Override
    public void add(T a) {
        this.index(a);
    }
}

