/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SumLatticeConstrained
extends SumLatticeDefault {
    private static Logger logger = MalletLogger.getLogger(SumLatticeConstrained.class.getName());

    public SumLatticeConstrained(Transducer t, Sequence input, Sequence output, Segment requiredSegment, Sequence constrainedSequence) {
        this(t, input, output, null, null, SumLatticeConstrained.makeConstraints(t, input, output, requiredSegment, constrainedSequence));
    }

    private static int[] makeConstraints(Transducer t, Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        if (constrainedSequence.size() != inputSequence.size()) {
            throw new IllegalArgumentException("constrainedSequence.size [" + constrainedSequence.size() + "] != inputSequence.size [" + inputSequence.size() + "]");
        }
        int[] constraints = new int[constrainedSequence.size() + 1];
        int c = 0;
        while (c < constraints.length) {
            constraints[c] = 0;
            ++c;
        }
        int i = requiredSegment.getStart();
        while (i <= requiredSegment.getEnd()) {
            int si = t.stateIndexOfString((String)constrainedSequence.get(i));
            if (si == -1) {
                logger.warning("Could not find state " + constrainedSequence.get(i) + ". Check that state labels match startTages and inTags, and that all labels are seen in training data.");
            }
            constraints[i + 1] = si + 1;
            ++i;
        }
        if (requiredSegment.getEnd() + 2 < constraints.length) {
            String endTag = requiredSegment.getInTag().toString();
            int statei = t.stateIndexOfString(endTag);
            if (statei == -1) {
                throw new IllegalArgumentException("Could not find state " + endTag + ". Check that state labels match startTags and InTags.");
            }
            constraints[requiredSegment.getEnd() + 2] = -(statei + 1);
        }
        logger.fine("Segment:\n" + requiredSegment.sequenceToString() + "\nconstrainedSequence:\n" + constrainedSequence + "\nConstraints:\n");
        i = 0;
        while (i < constraints.length) {
            logger.fine(String.valueOf(constraints[i]) + "\t");
            ++i;
        }
        logger.fine("");
        return constraints;
    }

    /*
     * Unable to fully structure code
     */
    public SumLatticeConstrained(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, LabelAlphabet outputAlphabet, int[] constraints) {
        super();
        this.t = trans;
        this.input = input;
        this.output = output;
        this.latticeLength = input.size() + 1;
        numStates = this.t.numStates();
        this.nodes = new SumLatticeDefault.LatticeNode[this.latticeLength][numStates];
        this.gammas = new double[this.latticeLength][numStates];
        outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        i = 0;
        while (i < numStates) {
            ip = 0;
            while (ip < this.latticeLength) {
                this.gammas[ip][i] = -Infinity;
                ++ip;
            }
            ++i;
        }
        SumLatticeConstrained.logger.fine("Starting Constrained Foward pass");
        atLeastOneInitialState = false;
        i = 0;
        while (i < numStates) {
            initialWeight = this.t.getState(i).getInitialWeight();
            if (initialWeight > -Infinity) {
                this.getLatticeNode((int)0, (int)i).alpha = initialWeight;
                atLeastOneInitialState = true;
            }
            ++i;
        }
        if (!atLeastOneInitialState) {
            SumLatticeConstrained.logger.warning("There are no starting states!");
        }
        ip = 0;
        while (ip < this.latticeLength - 1) {
            i = 0;
            while (i < numStates) {
                block51: {
                    block50: {
                        SumLatticeConstrained.logger.fine("ip=" + ip + ", i=" + i);
                        if (constraints[ip] <= 0) break block50;
                        if (constraints[ip] - 1 == i) ** GOTO lbl-1000
                        SumLatticeConstrained.logger.fine("Current state does not match positive constraint. position=" + ip + ", constraint=" + (constraints[ip] - 1) + ", currState=" + i);
                        break block51;
                    }
                    if (constraints[ip] < 0 && constraints[ip] + 1 == -i) {
                        SumLatticeConstrained.logger.fine("Current state does not match negative constraint. position=" + ip + ", constraint=" + (constraints[ip] + 1) + ", currState=" + i);
                    } else if (this.nodes[ip][i] == null || this.nodes[ip][i].alpha == -Infinity) {
                        if (this.nodes[ip][i] == null) {
                            SumLatticeConstrained.logger.fine("nodes[ip][i] is NULL");
                        } else if (this.nodes[ip][i].alpha == -Infinity) {
                            SumLatticeConstrained.logger.fine("nodes[ip][i].alpha is -Inf");
                        }
                        SumLatticeConstrained.logger.fine("-INFINITE weight or NULL...skipping");
                    } else {
                        s = this.t.getState(i);
                        iter = s.transitionIterator(input, ip, output, ip);
                        if (SumLatticeConstrained.logger.isLoggable(Level.FINE)) {
                            SumLatticeConstrained.logger.fine(" Starting Forward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                        }
                        while (iter.hasNext()) {
                            destination = iter.nextState();
                            legalTransition = true;
                            if (ip + 1 < constraints.length && constraints[ip + 1] > 0 && constraints[ip + 1] - 1 != destination.getIndex()) {
                                SumLatticeConstrained.logger.fine("Destination state does not match positive constraint. Assigning -infinite weight. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] - 1) + ", source =" + i + ", destination=" + destination.getIndex());
                                legalTransition = false;
                            } else if (ip + 1 < constraints.length && constraints[ip + 1] < 0 && -(constraints[ip + 1] + 1) == destination.getIndex()) {
                                SumLatticeConstrained.logger.fine("Destination state does not match negative constraint. Assigning -infinite weight. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] + 1) + ", destination=" + destination.getIndex());
                                legalTransition = false;
                            }
                            if (SumLatticeConstrained.logger.isLoggable(Level.FINE)) {
                                SumLatticeConstrained.logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                            destinationNode.output = iter.getOutput();
                            transitionWeight = iter.getWeight();
                            if (legalTransition) {
                                SumLatticeConstrained.logger.fine("transitionWeight=" + transitionWeight + " nodes[" + ip + "][" + i + "].alpha=" + this.nodes[ip][i].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                                destinationNode.alpha = Transducer.sumLogProb(destinationNode.alpha, this.nodes[ip][i].alpha + transitionWeight);
                                SumLatticeConstrained.logger.fine("Set alpha of latticeNode at ip = " + (ip + 1) + " stateIndex = " + destination.getIndex() + ", destinationNode.alpha = " + destinationNode.alpha);
                                continue;
                            }
                            SumLatticeConstrained.logger.fine("Illegal transition from state " + i + " to state " + destination.getIndex() + ". Setting alpha to -Inf");
                        }
                    }
                }
                ++i;
            }
            ++ip;
        }
        this.totalWeight = -Infinity;
        i = 0;
        while (i < numStates) {
            if (!(this.nodes[this.latticeLength - 1][i] == null || constraints[this.latticeLength - 1] > 0 && i != constraints[this.latticeLength - 1] - 1 || constraints[this.latticeLength - 1] < 0 && -i == constraints[this.latticeLength - 1] + 1)) {
                SumLatticeConstrained.logger.fine("Summing final lattice weight. state=" + i + ", alpha=" + this.nodes[this.latticeLength - 1][i].alpha + ", final weight = " + this.t.getState(i).getFinalWeight());
                this.totalWeight = Transducer.sumLogProb(this.totalWeight, this.nodes[this.latticeLength - 1][i].alpha + this.t.getState(i).getFinalWeight());
            }
            ++i;
        }
        if (this.totalWeight == -Infinity) {
            return;
        }
        i = 0;
        while (i < numStates) {
            if (this.nodes[this.latticeLength - 1][i] != null) {
                s = this.t.getState(i);
                this.nodes[this.latticeLength - 1][i].beta = s.getFinalWeight();
                this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.totalWeight;
                if (incrementor != null) {
                    p = Math.exp(this.gammas[this.latticeLength - 1][i]);
                    if (!(SumLatticeConstrained.$assertionsDisabled || p >= 0.0 && p <= 1.0 && !Double.isNaN(p))) {
                        throw new AssertionError((Object)("p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i]));
                    }
                    incrementor.incrementFinalState(s, p);
                }
            }
            ++i;
        }
        ip = this.latticeLength - 2;
        while (ip >= 0) {
            i = 0;
            while (i < numStates) {
                if (this.nodes[ip][i] != null && this.nodes[ip][i].alpha != -Infinity) {
                    s = this.t.getState(i);
                    iter = s.transitionIterator(input, ip, output, ip);
                    while (iter.hasNext()) {
                        destination = iter.nextState();
                        if (SumLatticeConstrained.logger.isLoggable(Level.FINE)) {
                            SumLatticeConstrained.logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                        transitionWeight = iter.getWeight();
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(transitionWeight)) {
                            throw new AssertionError();
                        }
                        oldBeta = this.nodes[ip][i].beta;
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                            throw new AssertionError();
                        }
                        this.nodes[ip][i].beta = Transducer.sumLogProb(this.nodes[ip][i].beta, destinationNode.beta + transitionWeight);
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                            throw new AssertionError((Object)("dest.beta=" + destinationNode.beta + " trans=" + transitionWeight + " sum=" + (destinationNode.beta + transitionWeight) + " oldBeta=" + oldBeta));
                        }
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].alpha)) {
                            throw new AssertionError();
                        }
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(transitionWeight)) {
                            throw new AssertionError();
                        }
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(this.nodes[ip + 1][j].beta)) {
                            throw new AssertionError();
                        }
                        if (!SumLatticeConstrained.$assertionsDisabled && Double.isNaN(this.totalWeight)) {
                            throw new AssertionError();
                        }
                        if (incrementor == null && outputAlphabet == null) continue;
                        xi = this.nodes[ip][i].alpha + transitionWeight + this.nodes[ip + 1][j].beta - this.totalWeight;
                        p = Math.exp(xi);
                        if (!(SumLatticeConstrained.$assertionsDisabled || p > -Infinity && !Double.isNaN(p))) {
                            throw new AssertionError((Object)("xis[" + ip + "][" + i + "][" + j + "]=" + xi));
                        }
                        if (incrementor != null) {
                            incrementor.incrementTransition(iter, p);
                        }
                        if (outputAlphabet == null) continue;
                        outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                        if (!SumLatticeConstrained.$assertionsDisabled && outputIndex < 0) {
                            throw new AssertionError();
                        }
                        v0 = outputCounts[ip];
                        v1 = outputIndex;
                        v0[v1] = v0[v1] + p;
                    }
                    this.gammas[ip][i] = this.nodes[ip][i].alpha + this.nodes[ip][i].beta - this.totalWeight;
                }
                ++i;
            }
            --ip;
        }
        if (incrementor != null) {
            i = 0;
            while (i < numStates) {
                p = Math.exp(this.gammas[0][i]);
                if (!(SumLatticeConstrained.$assertionsDisabled || p > -Infinity && !Double.isNaN(p))) {
                    throw new AssertionError();
                }
                incrementor.incrementInitialState(this.t.getState(i), p);
                ++i;
            }
        }
        if (outputAlphabet != null) {
            this.labelings = new LabelVector[this.latticeLength];
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                if (!SumLatticeConstrained.$assertionsDisabled && !(Math.abs(1.0 - MatrixOps.sum(outputCounts[ip])) < 1.0E-6)) {
                    throw new AssertionError();
                }
                this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                --ip;
            }
        }
    }
}

