/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public abstract class ClassifierEvaluator {
    private static Logger logger = MalletLogger.getLogger(ClassifierEvaluator.class.getName());
    InstanceList[] instanceLists;
    String[] instanceListDescriptions;

    public ClassifierEvaluator(InstanceList[] instanceLists, String[] instanceListDescriptions) {
        this.instanceLists = instanceLists;
        this.instanceListDescriptions = instanceListDescriptions;
    }

    public ClassifierEvaluator(InstanceList instanceList1, String instanceListDescription1) {
        this(new InstanceList[]{instanceList1}, new String[]{instanceListDescription1});
    }

    public ClassifierEvaluator(InstanceList instanceList1, String instanceListDescription1, InstanceList instanceList2, String instanceListDescription2) {
        this(new InstanceList[]{instanceList1, instanceList2}, new String[]{instanceListDescription1, instanceListDescription2});
    }

    public ClassifierEvaluator(InstanceList instanceList1, String instanceListDescription1, InstanceList instanceList2, String instanceListDescription2, InstanceList instanceList3, String instanceListDescription3) {
        this(new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{instanceListDescription1, instanceListDescription2, instanceListDescription3});
    }

    public void evaluate(ClassifierTrainer ct) {
        this.preamble(ct);
        int k = 0;
        while (k < this.instanceLists.length) {
            if (this.instanceLists[k] != null) {
                this.evaluateInstanceList(ct, this.instanceLists[k], this.instanceListDescriptions[k]);
            }
            ++k;
        }
    }

    protected void preamble(ClassifierTrainer ct) {
        if (ct instanceof ClassifierTrainer.ByOptimization) {
            int iteration = ((ClassifierTrainer.ByOptimization)((Object)ct)).getIteration();
            Optimizable opt = ((ClassifierTrainer.ByOptimization)((Object)ct)).getOptimizer().getOptimizable();
            if (opt instanceof Optimizable.ByValue) {
                logger.info("Evaluator iteration=" + iteration + " cost=" + ((Optimizable.ByValue)opt).getValue());
            } else {
                logger.info("Evaluator iteration=" + iteration + " cost=NA (not Optimizable.ByValue)");
            }
        }
    }

    public abstract void evaluateInstanceList(ClassifierTrainer var1, InstanceList var2, String var3);
}

