/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.uima;

import cc.mallet.fst.CRF;
import cc.mallet.types.Alphabet;
import de.julielab.jcore.ae.jnet.uima.ConsistencyPreservation;
import de.julielab.jcore.ae.jnet.uima.Interval;
import de.julielab.jcore.ae.jnet.uima.NegativeList;
import de.julielab.jcore.ae.jnet.uima.UIMAUtils;
import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import de.julielab.jnet.tagger.NETagger;
import de.julielab.jnet.tagger.Unit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAnnotator
extends JCasAnnotator_ImplBase {
    private static final String COMPONENT_ID = EntityAnnotator.class.getCanonicalName();
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityAnnotator.class);
    private static final String OUTSIDE_LABEL = "O";
    protected static final String ABBREV_PATTERN = "[A-Z]{2,3}s?";
    public Pattern abbrevPattern = null;
    private HashMap<String, String> entityMap;
    private NETagger tagger;
    protected boolean expandAbbr = false;
    protected ConsistencyPreservation consistencyPreservation = null;
    protected float confidenceThresholdForConsistencyPreservation = -1.0f;
    protected boolean showSegmentConf = false;
    protected TreeSet<String> entityMentionTypes = null;
    protected NegativeList negativeList;
    Properties featureConfig = null;
    ArrayList<String> activatedMetas = null;
    ArrayList<FSIterator<Annotation>> annotationIterators = null;
    ArrayList<String> valueMethods = null;
    private String maxEnt_parameter = "maxEnt";
    private String iteration_parameter = "iterations";
    private boolean maxEnt = false;
    private int iterations_number = 0;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        LOGGER.info("initialize() - initializing JNET...");
        super.initialize(aContext);
        try {
            this.setModel(aContext);
            this.setEntityTypes(aContext);
            this.setShowSegmentConfidence(aContext);
            this.setNegativeList(aContext);
            Object tmp = aContext.getConfigParameterValue("ExpandAbbreviations");
            if (tmp != null) {
                this.expandAbbr = (Boolean)tmp;
            }
            if ((tmp = aContext.getConfigParameterValue("ConsistencyPreservation")) != null) {
                this.consistencyPreservation = new ConsistencyPreservation((String)tmp);
            }
            if ((tmp = aContext.getConfigParameterValue("ConfidenceThresholdForConsistencyPreservation")) != null) {
                this.confidenceThresholdForConsistencyPreservation = ((Float)tmp).floatValue();
            }
            if ((tmp = aContext.getConfigParameterValue("IgnoreNotIntroducedAbbreviations")) != null && ((Boolean)tmp).booleanValue()) {
                this.abbrevPattern = Pattern.compile(ABBREV_PATTERN);
            }
            if ((tmp = aContext.getConfigParameterValue(this.maxEnt_parameter)) != null && ((Boolean)tmp).booleanValue()) {
                this.maxEnt = true;
                this.tagger.set_Max_Ent(this.maxEnt);
            }
            if ((tmp = aContext.getConfigParameterValue(this.iteration_parameter)) != null && (Integer)tmp != null) {
                this.iterations_number = (Integer)tmp;
                this.tagger.set_Number_Iterations(this.iterations_number);
            }
            LOGGER.info("initialize() - abbreviation expansion: " + this.expandAbbr);
            LOGGER.info("initialize() - negative list: " + (this.negativeList != null));
            LOGGER.info("initialize() - show confidence: " + this.showSegmentConf);
            LOGGER.info("initialize() - consistency preservation: " + (this.consistencyPreservation != null ? this.consistencyPreservation.toString() : "none"));
            LOGGER.info("initialize() - ignore not introduces abbreviations: " + (this.abbrevPattern != null));
        }
        catch (AnnotatorContextException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
        catch (AnnotatorConfigurationException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
        catch (AnnotatorInitializationException e) {
            e.printStackTrace();
            throw new ResourceInitializationException();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void retrieveMetaInformation(JCas aJCas) throws AnalysisEngineProcessException {
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        this.featureConfig = this.tagger.getFeatureConfig();
        this.activatedMetas = new ArrayList();
        this.annotationIterators = new ArrayList();
        this.valueMethods = new ArrayList();
        Enumeration<Object> keys = this.featureConfig.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String meta = "";
            if (key.matches("[A-Za-z]+_feat_enabled") && this.featureConfig.getProperty(key).matches("true")) {
                meta = key.substring(0, key.indexOf("_feat_enabled"));
                this.activatedMetas.add(meta);
            }
            if (!key.matches("[A-Za-z]+_feat_valMethod")) continue;
            meta = key.substring(0, key.indexOf("_feat_valMethod"));
            this.valueMethods.add(this.featureConfig.getProperty(key));
        }
        int i = 0;
        while (i < this.activatedMetas.size()) {
            Annotation ann = null;
            try {
                ann = JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)this.featureConfig.getProperty(String.valueOf(this.activatedMetas.get(i)) + "_feat_data"));
                this.annotationIterators.add((FSIterator<Annotation>)indexes.getAnnotationIndex(ann.getTypeIndexID()).iterator());
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ++i;
        }
    }

    private void setEntityTypes(UimaContext aContext) throws ResourceInitializationException, AnnotatorContextException, AnnotatorConfigurationException {
        this.entityMentionTypes = new TreeSet();
        Object o = aContext.getConfigParameterValue("EntityTypes");
        if (o == null) {
            LOGGER.error("setEntityTypes() - descriptor incomplete, entity types not specified!");
            throw new AnnotatorConfigurationException();
        }
        String[] entityTypes = (String[])o;
        this.entityMap = new HashMap();
        int i = 0;
        while (i < entityTypes.length) {
            String[] entityParts = entityTypes[i].split("=");
            this.entityMap.put(entityParts[0], entityParts[1]);
            this.entityMentionTypes.add(entityParts[1]);
            ++i;
        }
        CRF model = (CRF)this.tagger.getModel();
        int j = 0;
        if (model != null) {
            Alphabet alpha = model.getOutputAlphabet();
            Object[] modelLabels = alpha.toArray();
            int i2 = 0;
            while (i2 < entityTypes.length) {
                String[] entityParts = entityTypes[i2].split("=");
                boolean entityFound = false;
                j = 0;
                while (j < modelLabels.length) {
                    if (entityParts[0].equals(modelLabels[j])) {
                        entityFound = true;
                    }
                    ++j;
                }
                if (!entityFound) {
                    LOGGER.error("setEntityTypes() - Could not find entity label \"{}\" from descriptor in the tagger's OutputAlphabet.", (Object)entityParts[0]);
                    throw new AnnotatorConfigurationException();
                }
                ++i2;
            }
        }
        LOGGER.debug("Entity mention types: " + this.entityMentionTypes.toString());
    }

    private void setModel(UimaContext aContext) throws AnnotatorConfigurationException, AnnotatorContextException, AnnotatorInitializationException, IOException {
        String modelFilename = "";
        Object o = aContext.getConfigParameterValue("ModelFilename");
        if (o == null) {
            LOGGER.error("setModel() - descriptor incomplete, no model file specified!");
            throw new AnnotatorConfigurationException();
        }
        modelFilename = (String)o;
        this.tagger = new NETagger();
        try {
            InputStream is;
            LOGGER.debug("setModel() -  loading JNET model " + modelFilename);
            File modelFile = new File(modelFilename);
            if (!modelFile.exists()) {
                String resourceLocation = modelFilename.startsWith("/") ? modelFilename : "/" + modelFilename;
                is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceLocation);
            } else {
                is = new FileInputStream(modelFile);
            }
            this.tagger.readModel(is);
        }
        catch (Exception e) {
            LOGGER.error("setModel() - Could not load JNET model: " + e.getMessage(), (Throwable)e);
            throw new AnnotatorInitializationException();
        }
    }

    private void setNegativeList(UimaContext aContext) throws AnnotatorConfigurationException, AnnotatorContextException {
        Object o = aContext.getConfigParameterValue("NegativeList");
        if (o != null) {
            File listFile = new File((String)o);
            try {
                this.negativeList = new NegativeList(listFile);
            }
            catch (IOException e) {
                LOGGER.error("setNegativeList() - specified negative list file cannot be read: " + e.getMessage());
                throw new AnnotatorConfigurationException();
            }
            LOGGER.debug("setNegativeList() - using negative list: " + listFile);
        }
    }

    private void setShowSegmentConfidence(UimaContext aContext) throws AnnotatorContextException {
        Object o = aContext.getConfigParameterValue("ShowSegmentConfidence");
        if (o != null) {
            this.showSegmentConf = (Boolean)o;
        }
        LOGGER.debug("setShowSegmentConfidence() - show segment confidence: " + this.showSegmentConf);
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        LOGGER.info("process() - processing next document");
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        this.retrieveMetaInformation(aJCas);
        for (Sentence sentence : indexes.getAnnotationIndex(Sentence.type)) {
            ArrayList tokenList = (ArrayList)UIMAUtils.getAnnotations(aJCas, (Annotation)sentence, new Token(aJCas, 0, 0).getClass());
            ArrayList<HashMap<String, String>> metaList = this.getMetaList(tokenList);
            if (tokenList.size() != metaList.size()) {
                LOGGER.error("process() - token list, and meta list for this sentence not of same size!");
                throw new AnalysisEngineProcessException();
            }
            de.julielab.jnet.tagger.Sentence unitSentence = this.createUnitSentence(tokenList, aJCas, metaList);
            LOGGER.debug("process() - original sentence: " + sentence.getCoveredText());
            StringBuffer unitS = new StringBuffer();
            for (Unit unit : unitSentence.getUnits()) {
                unitS.append(String.valueOf(unit.getRep()) + " ");
            }
            LOGGER.debug("process() - sentence for prediction: " + unitSentence.toString());
            try {
                this.tagger.predict(unitSentence, this.showSegmentConf);
            }
            catch (IllegalStateException e) {
                LOGGER.error("process() - predicting with JNET failed: " + e.getMessage());
                throw new AnalysisEngineProcessException();
            }
            if (this.expandAbbr) {
                unitSentence = this.removeDuplicatedTokens(unitSentence);
            }
            LOGGER.debug("process() - sentence with labels: " + unitSentence.toString());
            this.writeToCAS(unitSentence, aJCas);
        }
        if (this.consistencyPreservation != null) {
            LOGGER.debug("process() - running consistency preservation");
            this.consistencyPreservation.stringMatch(aJCas, this.entityMentionTypes, this.confidenceThresholdForConsistencyPreservation);
            this.consistencyPreservation.acroMatch(aJCas, this.entityMentionTypes);
        }
    }

    protected de.julielab.jnet.tagger.Sentence removeDuplicatedTokens(de.julielab.jnet.tagger.Sentence unitSentence) {
        de.julielab.jnet.tagger.Sentence newUnitSentence = new de.julielab.jnet.tagger.Sentence();
        String lastPos = null;
        Unit lastUnit = null;
        TreeSet<String> lastLabels = new TreeSet<String>();
        int k = 0;
        while (k < unitSentence.getUnits().size()) {
            Unit unit = unitSentence.get(k);
            lastLabels.add(unit.getLabel());
            String currPos = String.valueOf(unit.begin) + "@" + unit.end;
            if (lastPos != null && lastPos.equals(currPos)) {
                lastLabels.add(unit.getLabel());
                if (lastLabels.size() > 1) {
                    lastUnit.setLabel(OUTSIDE_LABEL);
                }
            } else {
                newUnitSentence.add(unit);
                lastLabels = new TreeSet();
                lastLabels.add(unit.getLabel());
            }
            lastPos = currPos;
            lastUnit = unit;
            ++k;
        }
        return newUnitSentence;
    }

    protected de.julielab.jnet.tagger.Sentence createUnitSentence(ArrayList<Token> tokenList, JCas JCas2, ArrayList<HashMap<String, String>> metaList) {
        de.julielab.jnet.tagger.Sentence unitSentence = new de.julielab.jnet.tagger.Sentence();
        ArrayList<Abbreviation> abbreviationList = this.getAbbreviationList(tokenList, JCas2);
        int i = 0;
        while (i < tokenList.size()) {
            Token token = tokenList.get(i);
            HashMap<String, String> metas = metaList.get(i);
            Abbreviation abbreviation = abbreviationList.get(i);
            String tokenRepresentation = token.getCoveredText();
            if (this.expandAbbr && abbreviation != null) {
                tokenRepresentation = abbreviation.getDefinedHere() ? null : abbreviation.getTextReference().getCoveredText();
            }
            if (tokenRepresentation != null) {
                if (tokenRepresentation.equals(token.getCoveredText())) {
                    Unit unit = new Unit(token.getBegin(), token.getEnd(), tokenRepresentation, "", metas);
                    unitSentence.add(unit);
                } else {
                    Unit unit;
                    ArrayList abbrevTokens = (ArrayList)UIMAUtils.getAnnotations(JCas2, (Annotation)abbreviation.getTextReference(), new Token(JCas2, 0, 0).getClass());
                    if (abbreviation.getTextReference().getCoveredText().length() > 0 && abbrevTokens.size() == 0) {
                        StringTokenizer st = new StringTokenizer(tokenRepresentation);
                        while (st.hasMoreTokens()) {
                            String fullformToken = st.nextToken();
                            unit = new Unit(token.getBegin(), token.getEnd(), fullformToken, "", metas);
                            unitSentence.add(unit);
                        }
                    } else {
                        for (Token abbrevToken : abbrevTokens) {
                            unit = new Unit(token.getBegin(), token.getEnd(), abbrevToken.getCoveredText(), "", metas);
                            unitSentence.add(unit);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.expandAbbr) {
            unitSentence = this.removeConsecutiveBrackets(unitSentence);
        }
        return unitSentence;
    }

    /*
     * Unable to fully structure code
     */
    private de.julielab.jnet.tagger.Sentence removeConsecutiveBrackets(de.julielab.jnet.tagger.Sentence unitSentence) {
        finalUnitSentence = new de.julielab.jnet.tagger.Sentence();
        i = 0;
        while (i < unitSentence.getUnits().size()) {
            currentUnit = unitSentence.getUnits().get(i);
            if (i + 1 >= unitSentence.getUnits().size()) ** GOTO lbl-1000
            nextUnit = unitSentence.getUnits().get(i + 1);
            if (currentUnit.getRep().equals("(") && nextUnit.getRep().equals(")") || currentUnit.getRep().equals("[") && nextUnit.getRep().equals("]")) {
                ++i;
            } else lbl-1000:
            // 2 sources

            {
                finalUnitSentence.add(currentUnit);
            }
            ++i;
        }
        return finalUnitSentence;
    }

    private ArrayList<Abbreviation> getAbbreviationList(ArrayList<Token> tokenList, JCas JCas2) {
        ArrayList<Abbreviation> abbreviationList = new ArrayList<Abbreviation>();
        for (Token token : tokenList) {
            ArrayList abbreviations = (ArrayList)UIMAUtils.getAnnotations(JCas2, (Annotation)token, new Abbreviation(JCas2, 0, 0).getClass());
            if (abbreviations != null && abbreviations.size() > 0) {
                abbreviationList.add((Abbreviation)abbreviations.get(0));
                continue;
            }
            abbreviationList.add(null);
        }
        return abbreviationList;
    }

    private ArrayList<HashMap<String, String>> getMetaList(ArrayList<Token> tokenList) {
        ArrayList<HashMap<String, String>> metaList = new ArrayList<HashMap<String, String>>();
        Interval[] metaAnnotationValues = new Interval[this.activatedMetas.size()];
        int i = 0;
        while (i < metaAnnotationValues.length) {
            metaAnnotationValues[i] = null;
            ++i;
        }
        for (Token token : tokenList) {
            metaList.add(this.getMetas(token, metaAnnotationValues));
        }
        return metaList;
    }

    private HashMap<String, String> getMetas(Token token, Interval[] metaAnnotationValues) {
        int i = 0;
        HashMap<String, String> metaInfos = new HashMap<String, String>();
        if (this.featureConfig == null) {
            return metaInfos;
        }
        try {
            i = 0;
            while (i < this.annotationIterators.size()) {
                if (this.annotationIterators.get(i).hasNext() && metaAnnotationValues[i] == null) {
                    Annotation ann = (Annotation)this.annotationIterators.get(i).next();
                    String valueMethodName = this.valueMethods.get(i);
                    Method valueMethod = ann.getClass().getMethod(valueMethodName, new Class[0]);
                    metaAnnotationValues[i] = new Interval(ann.getBegin(), ann.getEnd(), "" + valueMethod.invoke((Object)ann, null));
                }
                ++i;
            }
            i = 0;
            while (i < this.activatedMetas.size()) {
                Interval annotationInterval = metaAnnotationValues[i];
                String metaName = this.featureConfig.getProperty(String.valueOf(this.activatedMetas.get(i)) + "_feat_unit");
                if (annotationInterval != null && annotationInterval.isIn(token.getBegin(), token.getEnd())) {
                    if (this.featureConfig.getProperty(String.valueOf(this.activatedMetas.get(i)) + "_begin_flag").equals("true") && annotationInterval.getBegin() == token.getBegin()) {
                        metaInfos.put(metaName, "B_" + metaAnnotationValues[i].getAnnotation());
                    } else {
                        metaInfos.put(metaName, metaAnnotationValues[i].getAnnotation());
                    }
                    if (annotationInterval.getEnd() == token.getEnd()) {
                        metaAnnotationValues[i] = null;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.warn("getMetas() - failed getting meta information for current token. No metas used!");
            metaInfos = new HashMap();
        }
        return metaInfos;
    }

    public void writeToCAS(de.julielab.jnet.tagger.Sentence unitSentence, JCas aJCas) {
        String lastLabel = OUTSIDE_LABEL;
        int lastStart = 0;
        int lastEnd = 0;
        double conf = -1.0;
        double lastConf = -1.0;
        Unit unit = null;
        int i = 0;
        while (i < unitSentence.size()) {
            unit = unitSentence.get(i);
            String label = unit.getLabel();
            conf = unit.getConfidence();
            if (lastLabel.equals(OUTSIDE_LABEL) && !label.equals(OUTSIDE_LABEL)) {
                lastStart = unit.begin;
            } else if (!lastLabel.equals(OUTSIDE_LABEL) && !label.equals(OUTSIDE_LABEL) && !lastLabel.equals(label) || !lastLabel.equals(OUTSIDE_LABEL) && label.equals(OUTSIDE_LABEL)) {
                this.addAnnotation(aJCas, lastStart, lastEnd, lastLabel, lastConf);
                lastStart = unit.begin;
            }
            lastLabel = label;
            lastEnd = unit.end;
            lastConf = conf;
            if (i == unitSentence.size() - 1 && !label.equals(OUTSIDE_LABEL)) {
                lastEnd = unit.end;
                this.addAnnotation(aJCas, lastStart, lastEnd, lastLabel, lastConf);
            }
            ++i;
        }
    }

    private void addAnnotation(JCas aJCas, int start, int end, String label, double confidence) {
        String coveredText = aJCas.getDocumentText().substring(start, end);
        if (this.ignoreLabel(aJCas, start, end)) {
            return;
        }
        if (this.negativeList != null && this.negativeList.contains(coveredText, label)) {
            LOGGER.debug("addAnnotation() - ignoring current entity mention as contained in negativeList");
            return;
        }
        EntityMention entity = null;
        String entityType = this.entityMap.get(label);
        if (entityType != null) {
            try {
                entity = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)entityType);
                entity.setBegin(start);
                entity.setEnd(end);
                entity.setTextualRepresentation(aJCas.getDocumentText().substring(start, end));
                entity.setSpecificType(label);
                entity.setComponentId(COMPONENT_ID);
                if (this.showSegmentConf) {
                    entity.setConfidence(String.valueOf(confidence));
                }
                entity.addToIndexes();
            }
            catch (Exception e) {
                LOGGER.error("addAnnotation() - could not generate new EntityMention", (Throwable)e);
            }
        } else {
            LOGGER.debug("addAnnotation() - ommitted entity mention for label: " + label);
        }
    }

    protected boolean ignoreLabel(JCas aJCas, int start, int end) {
        String coveredText = aJCas.getDocumentText().substring(start, end);
        if (this.abbrevPattern != null && this.abbrevPattern.matcher(coveredText).matches()) {
            Annotation windowAnno = new Annotation(aJCas, start, end);
            windowAnno.addToIndexes();
            ArrayList abbreviations = (ArrayList)UIMAUtils.getAnnotations(aJCas, windowAnno, new Abbreviation(aJCas, 0, 0).getClass());
            windowAnno.removeFromIndexes();
            windowAnno = null;
            if (abbreviations != null && abbreviations.size() > 0) {
                LOGGER.debug("ignoreLabel() - found JACRO-recognized abbreviations under this string: " + coveredText);
                for (Abbreviation abbreviation : abbreviations) {
                    if (abbreviation.getTextReference() == null || !abbreviation.getCoveredText().matches(ABBREV_PATTERN)) continue;
                    LOGGER.debug("ignoreLabel() - abbreviation: " + abbreviation.getCoveredText() + " introduced for: " + abbreviation.getTextReference().getCoveredText());
                    return false;
                }
            }
            LOGGER.debug("ignoreLabel() - ignoring annotations on " + coveredText + " because it is a not introduced abbreviation!");
            return true;
        }
        return false;
    }
}

