/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.uima;

import com.google.common.collect.HashMultimap;
import de.julielab.jcore.ae.jnet.uima.UIMAUtils;
import de.julielab.jcore.types.Abbreviation;
import de.julielab.jcore.types.Annotation;
import de.julielab.jcore.types.EntityMention;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyPreservation {
    private static final String COMPONENT_ID = "de.julielab.jcore.ae.netagger.ConsistencyPreservation";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsistencyPreservation.class);
    public static final String MODE_ACRO2FULL = "acro2full";
    public static final String MODE_FULL2ACRO = "full2acro";
    public static final String MODE_STRING = "string";
    private TreeSet<String> activeModes = new TreeSet();

    public ConsistencyPreservation(String modesString) throws ResourceInitializationException {
        String[] modes;
        String[] stringArray = modes = modesString.split(",");
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode2 = stringArray[n2];
            String mode = mode2.trim();
            if (!(mode.equals(MODE_ACRO2FULL) || mode.equals(MODE_FULL2ACRO) || mode.equals(MODE_STRING))) {
                LOGGER.error("ConsistencyPreservation() - unknown mode found!");
                throw new ResourceInitializationException();
            }
            this.activeModes.add(mode);
            ++n2;
        }
        LOGGER.info("ConsistencyPreservation() - modes used in consistency engine: " + this.activeModes.toString());
    }

    public void acroMatch(JCas aJCas, TreeSet<String> entityMentionClassnames) throws AnalysisEngineProcessException {
        if (this.activeModes == null || this.activeModes.size() == 0 || !this.activeModes.contains(MODE_FULL2ACRO) && !this.activeModes.contains(MODE_ACRO2FULL)) {
            return;
        }
        HashSet<EntityMention> entityMentionTypes = null;
        try {
            entityMentionTypes = new HashSet<EntityMention>();
            for (String className : entityMentionClassnames) {
                entityMentionTypes.add((EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)className));
            }
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        for (Abbreviation abbrev : indexes.getAnnotationIndex(Abbreviation.type)) {
            EntityMention newEntityMention;
            EntityMention refEntityMention;
            ArrayList fullFormMentionList;
            Annotation fullFormAnnotation = abbrev.getTextReference();
            LOGGER.debug("doAbbreviationBased() - checking abbreviation: " + abbrev.getCoveredText());
            ArrayList mentionList = new ArrayList();
            for (EntityMention mention : entityMentionTypes) {
                mentionList.addAll(UIMAUtils.getAnnotations(aJCas, (org.apache.uima.jcas.tcas.Annotation)abbrev, mention.getClass()));
            }
            if (mentionList == null || mentionList.size() == 0) {
                if (!this.activeModes.contains(MODE_FULL2ACRO)) continue;
                LOGGER.debug("doAbbreviationBased() -  no entity mentions of interest found on this abbreviation");
                fullFormMentionList = new ArrayList();
                for (EntityMention mention : entityMentionTypes) {
                    fullFormMentionList.addAll(UIMAUtils.getExactAnnotations(aJCas, (org.apache.uima.jcas.tcas.Annotation)fullFormAnnotation, mention.getClass()));
                }
                if (fullFormMentionList == null || fullFormMentionList.size() <= 0) continue;
                refEntityMention = (EntityMention)fullFormMentionList.get(0);
                LOGGER.debug("doAbbreviationBased() -  but found entity mention on full form");
                LOGGER.debug("doAbbreviationBased() -  adding annotation to unlabeled entity mention");
                try {
                    newEntityMention = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)refEntityMention.getClass().getName());
                    newEntityMention.setBegin(abbrev.getBegin());
                    newEntityMention.setEnd(abbrev.getEnd());
                    newEntityMention.setSpecificType(refEntityMention.getSpecificType());
                    newEntityMention.setResourceEntryList(refEntityMention.getResourceEntryList());
                    newEntityMention.setConfidence(refEntityMention.getConfidence());
                    newEntityMention.setTextualRepresentation(abbrev.getCoveredText());
                    newEntityMention.setComponentId("de.julielab.jcore.ae.netagger.ConsistencyPreservation Abbrev");
                    newEntityMention.addToIndexes();
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("doAbbreviationBased() - could not get create new entity mention annotation: " + refEntityMention.getClass().getName());
                    throw new AnalysisEngineProcessException();
                }
            }
            if (!this.activeModes.contains(MODE_ACRO2FULL) || mentionList.size() <= 0) continue;
            LOGGER.debug("doAbbreviationBased() -  abbreviation has entity mentions of interest");
            fullFormMentionList = new ArrayList();
            for (EntityMention mention : entityMentionTypes) {
                fullFormMentionList.addAll(UIMAUtils.getAnnotations(aJCas, (org.apache.uima.jcas.tcas.Annotation)fullFormAnnotation, mention.getClass()));
            }
            if (fullFormMentionList != null && fullFormMentionList.size() != 0) continue;
            refEntityMention = (EntityMention)mentionList.get(0);
            LOGGER.debug("doAbbreviationBased() -  but reference full form has no entity mentions of interest");
            LOGGER.debug("doAbbreviationBased() -  adding annotation to unlabeled entity mention");
            try {
                newEntityMention = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)refEntityMention.getClass().getName());
                newEntityMention.setBegin(fullFormAnnotation.getBegin());
                newEntityMention.setEnd(fullFormAnnotation.getEnd());
                newEntityMention.setSpecificType(refEntityMention.getSpecificType());
                newEntityMention.setResourceEntryList(refEntityMention.getResourceEntryList());
                newEntityMention.setConfidence(refEntityMention.getConfidence());
                newEntityMention.setTextualRepresentation(abbrev.getCoveredText());
                newEntityMention.setComponentId("de.julielab.jcore.ae.netagger.ConsistencyPreservation Abbrev");
                newEntityMention.addToIndexes();
            }
            catch (Exception e) {
                LOGGER.error("doAbbreviationBased() - could not get create new entity mention annotation: " + refEntityMention.getClass().getName());
                throw new AnalysisEngineProcessException();
            }
        }
    }

    public void stringMatch(JCas aJCas, TreeSet<String> entityMentionClassnames, double confidenceThresholdForConsistencyPreservation) throws AnalysisEngineProcessException {
        if (this.activeModes == null || this.activeModes.size() == 0 || !this.activeModes.contains(MODE_STRING)) {
            return;
        }
        String text = aJCas.getDocumentText();
        for (String entityMentionClassname : entityMentionClassnames) {
            LOGGER.debug("doStringBased() - checking consistency for type: " + entityMentionClassname);
            HashMultimap entityMap = HashMultimap.create();
            JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
            try {
                EntityMention myEntity = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)entityMentionClassname);
                LOGGER.debug("doStringBased() - building entity map");
                for (EntityMention entity : indexes.getAnnotationIndex(myEntity.getTypeIndexID())) {
                    entityMap.put((Object)entity.getCoveredText(), (Object)entity);
                }
                LOGGER.debug("doStringBased() - searching for missed entities...");
                for (String entityString : entityMap.keySet()) {
                    EntityMention entity = (EntityMention)entityMap.get((Object)entityString).iterator().next();
                    LOGGER.debug("doStringBased() - checking entity string: " + entityString);
                    int pos = 0;
                    int length = 0;
                    ArrayList<EntityMention> stringMatchedEntities = new ArrayList<EntityMention>();
                    while ((pos = text.indexOf(entityString, pos + length)) > -1) {
                        LOGGER.debug("doStringBased() - found string at pos: " + pos);
                        EntityMention refEntity = (EntityMention)JCoReAnnotationTools.getOverlappingAnnotation((JCas)aJCas, (String)entityMentionClassname, (int)pos, (int)(pos + entityString.length()));
                        if (refEntity == null || refEntity.getSpecificType() == null ^ entity.getSpecificType() == null || refEntity.getSpecificType() != null && entity.getSpecificType() != null && !refEntity.getSpecificType().equals(entity.getSpecificType())) {
                            LOGGER.debug("doStringBased() - adding annotation to unlabeled entity mention");
                            refEntity = (EntityMention)JCoReAnnotationTools.getAnnotationByClassName((JCas)aJCas, (String)entityMentionClassname);
                            List overlappingTokens = JCoReAnnotationTools.getNearestOverlappingAnnotations((JCas)aJCas, (org.apache.uima.jcas.tcas.Annotation)new Annotation(entity.getCAS().getJCas(), pos, pos + entityString.length()), Token.class);
                            int begin = overlappingTokens.size() > 0 ? ((Token)overlappingTokens.get(0)).getBegin() : pos;
                            int end = overlappingTokens.size() > 0 ? ((Token)overlappingTokens.get(overlappingTokens.size() - 1)).getEnd() : pos + entityString.length();
                            refEntity.setBegin(begin);
                            refEntity.setEnd(end);
                            refEntity.setSpecificType(entity.getSpecificType());
                            refEntity.setResourceEntryList(entity.getResourceEntryList());
                            refEntity.setConfidence(entity.getConfidence());
                            refEntity.setTextualRepresentation(entity.getTextualRepresentation());
                            refEntity.setComponentId("de.julielab.jcore.ae.netagger.ConsistencyPreservation String");
                            stringMatchedEntities.add(refEntity);
                        } else {
                            LOGGER.debug("doStringBased() - there is already an entity!");
                        }
                        length = entityString.length();
                    }
                    if (confidenceThresholdForConsistencyPreservation > 0.0) {
                        if (stringMatchedEntities.isEmpty()) continue;
                        double meanConfidence = 0.0;
                        for (EntityMention recognizedEntity : entityMap.get((Object)entityString)) {
                            if (entity.getConfidence() == null) continue;
                            meanConfidence += Double.parseDouble(recognizedEntity.getConfidence());
                        }
                        meanConfidence /= (double)entityMap.get((Object)entityString).size();
                        int allMatches = stringMatchedEntities.size() + entityMap.get((Object)entityString).size();
                        if (!((double)entityMap.get((Object)entityString).size() >= (double)allMatches / 3.0) || !(meanConfidence > confidenceThresholdForConsistencyPreservation)) continue;
                        for (EntityMention refEntity : stringMatchedEntities) {
                            refEntity.addToIndexes();
                        }
                        continue;
                    }
                    for (EntityMention refEntity : stringMatchedEntities) {
                        refEntity.addToIndexes();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("doStringBased() - exception occured: " + e.getMessage());
                throw new AnalysisEngineProcessException();
            }
        }
    }

    public String toString() {
        return "activeModes: " + this.activeModes;
    }
}

