/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.tagger;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureConfiguration {
    public boolean featureActive(Properties propDef, String propName) {
        return propDef.getProperty(propName) != null && propDef.getProperty(propName).equals("true");
    }

    public int[] getIntArray(Properties propDef, String propName) {
        int[] intArray = null;
        if (propDef.getProperty(propName) != null) {
            String[] stringArray = propDef.getProperty(propName).trim().split(",");
            intArray = new int[stringArray.length];
            int i = 0;
            while (i < stringArray.length) {
                intArray[i] = new Integer(stringArray[i]);
                ++i;
            }
        }
        return intArray;
    }

    public int[][] offsetConjFromConfig(String offset_conjunctions) {
        if (offset_conjunctions == null) {
            return null;
        }
        Pattern inBrackets = Pattern.compile("\\([-\\d\\s,]+\\)");
        Matcher bracketMatcher = inBrackets.matcher(offset_conjunctions);
        ArrayList<String> bracketContents = new ArrayList<String>();
        int pos = 0;
        while (bracketMatcher.find(pos)) {
            int bracketStart = bracketMatcher.start() + 1;
            int bracketEnd = bracketMatcher.end() - 1;
            bracketContents.add(offset_conjunctions.substring(bracketStart, bracketEnd));
            pos = bracketMatcher.end();
        }
        int[][] conjunctions = new int[bracketContents.size()][];
        int i = 0;
        while (i < bracketContents.size()) {
            String[] digits = ((String)bracketContents.get(i)).split(",");
            conjunctions[i] = new int[digits.length];
            int j = 0;
            while (j < digits.length) {
                conjunctions[i][j] = Integer.parseInt(digits[j].trim());
                ++j;
            }
            ++i;
        }
        return conjunctions;
    }

    public ArrayList<String> getLexiconKeys(Properties propDef) {
        ArrayList<String> lexiconKeys = new ArrayList<String>();
        Enumeration<?> keys = propDef.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.matches("[a-zA-Z]+_lexicon")) continue;
            lexiconKeys.add(key);
        }
        return lexiconKeys;
    }

    public String[] getTrueMetas(Properties featureConfig) {
        ArrayList<String> trueMetas = new ArrayList<String>();
        Enumeration<?> keys = featureConfig.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.matches("[a-zA-Z]+_feat_enabled") || !featureConfig.getProperty(key).equals("true")) continue;
            trueMetas.add(key.substring(0, key.indexOf("_feat_enabled")));
        }
        String[] ret = new String[trueMetas.size()];
        trueMetas.toArray(ret);
        return ret;
    }

    public String[] getStringArray(Properties propDef, String propName) {
        if (propDef.getProperty(propName) != null) {
            return propDef.getProperty(propName).trim().split(", *");
        }
        return null;
    }
}

